/*
 * Decompiled with CFR 0.152.
 */
package fitnesseMain;

import fitnesse.Arguments;
import fitnesse.ComponentFactory;
import fitnesse.FitNesse;
import fitnesse.FitNesseContext;
import fitnesse.Updater;
import fitnesse.WikiPageFactory;
import fitnesse.authentication.Authenticator;
import fitnesse.authentication.MultiUserAuthenticator;
import fitnesse.authentication.OneUserAuthenticator;
import fitnesse.authentication.PromiscuousAuthenticator;
import fitnesse.components.Logger;
import fitnesse.components.PluginsClassLoader;
import fitnesse.responders.WikiImportTestEventListener;
import fitnesse.responders.run.formatters.TestTextFormatter;
import fitnesse.updates.UpdaterImplementation;
import fitnesse.wiki.PageVersionPruner;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import util.CommandLine;

/*
 * Exception performing whole class analysis ignored.
 */
public class FitNesseMain {
    private static String extraOutput;
    public static boolean dontExitAfterSingleCommand;

    public static void main(String[] args) throws Exception {
        Arguments arguments = FitNesseMain.parseCommandLine((String[])args);
        if (arguments != null) {
            FitNesseMain.launchFitNesse((Arguments)arguments);
        } else {
            FitNesseMain.printUsage();
            System.exit(1);
        }
    }

    public static void launchFitNesse(Arguments arguments) throws Exception {
        FitNesseMain.loadPlugins();
        FitNesseContext context = FitNesseMain.loadContext((Arguments)arguments);
        UpdaterImplementation updater = null;
        if (!arguments.isOmittingUpdates()) {
            updater = new UpdaterImplementation(context);
        }
        PageVersionPruner.daysTillVersionsExpire = arguments.getDaysTillVersionsExpire();
        FitNesse fitnesse = new FitNesse(context, (Updater)updater);
        FitNesseMain.update((Arguments)arguments, (FitNesse)fitnesse);
        FitNesseMain.launch((Arguments)arguments, (FitNesseContext)context, (FitNesse)fitnesse);
    }

    private static void loadPlugins() throws Exception {
        new PluginsClassLoader().addPluginsToClassLoader();
    }

    static void update(Arguments arguments, FitNesse fitnesse) throws Exception {
        if (!arguments.isOmittingUpdates()) {
            fitnesse.applyUpdates();
        }
    }

    static void launch(Arguments arguments, FitNesseContext context, FitNesse fitnesse) throws Exception {
        boolean started;
        if (!arguments.isInstallOnly() && (started = fitnesse.start())) {
            FitNesseMain.printStartMessage((Arguments)arguments, (FitNesseContext)context);
            if (arguments.getCommand() != null) {
                FitNesseMain.executeSingleCommand((Arguments)arguments, (FitNesse)fitnesse, (FitNesseContext)context);
            }
        }
    }

    private static void executeSingleCommand(Arguments arguments, FitNesse fitnesse, FitNesseContext context) throws Exception {
        OutputStream os;
        boolean outputRedirectedToFile;
        TestTextFormatter.finalErrorCount = 0;
        System.out.println("Executing command: " + arguments.getCommand());
        boolean bl = outputRedirectedToFile = arguments.getOutput() != null;
        if (outputRedirectedToFile) {
            System.out.println("-----Command Output redirected to " + arguments.getOutput() + "-----");
            os = new FileOutputStream(arguments.getOutput());
        } else {
            System.out.println("-----Command Output-----");
            os = System.out;
        }
        fitnesse.executeSingleCommand(arguments.getCommand(), os);
        fitnesse.stop();
        if (outputRedirectedToFile) {
            ((OutputStream)os).close();
        } else {
            System.out.println("-----Command Complete-----");
        }
        if (FitNesseMain.shouldExitAfterSingleCommand()) {
            System.exit(TestTextFormatter.finalErrorCount);
        }
    }

    private static boolean shouldExitAfterSingleCommand() {
        return !dontExitAfterSingleCommand;
    }

    private static FitNesseContext loadContext(Arguments arguments) throws Exception {
        FitNesseContext.Builder builder = new FitNesseContext.Builder();
        WikiPageFactory wikiPageFactory = new WikiPageFactory();
        ComponentFactory componentFactory = new ComponentFactory(arguments.getRootPath());
        builder.port = arguments.getPort();
        builder.rootPath = arguments.getRootPath();
        builder.rootDirectoryName = arguments.getRootDirectory();
        builder.pageTheme = componentFactory.getProperty("Theme");
        builder.defaultNewPageContent = componentFactory.getProperty("newpage.default.content");
        builder.root = wikiPageFactory.makeRootPage(builder.rootPath, builder.rootDirectoryName, componentFactory);
        builder.logger = FitNesseMain.makeLogger((Arguments)arguments);
        builder.authenticator = FitNesseMain.makeAuthenticator((String)arguments.getUserpass(), (ComponentFactory)componentFactory);
        FitNesseContext context = builder.createFitNesseContext();
        extraOutput = componentFactory.loadPlugins(context.responderFactory, wikiPageFactory);
        extraOutput = extraOutput + componentFactory.loadWikiPage(wikiPageFactory);
        extraOutput = extraOutput + componentFactory.loadResponders(context.responderFactory);
        extraOutput = extraOutput + componentFactory.loadSymbolTypes();
        extraOutput = extraOutput + componentFactory.loadContentFilter();
        extraOutput = extraOutput + componentFactory.loadSlimTables();
        WikiImportTestEventListener.register();
        return context;
    }

    public static Arguments parseCommandLine(String[] args) {
        CommandLine commandLine = new CommandLine("[-p port][-d dir][-r root][-l logDir][-e days][-o][-i][-a userpass][-c command][-b output]");
        Arguments arguments = null;
        if (commandLine.parse(args)) {
            arguments = new Arguments();
            if (commandLine.hasOption("p")) {
                arguments.setPort(commandLine.getOptionArgument("p", "port"));
            }
            if (commandLine.hasOption("d")) {
                arguments.setRootPath(commandLine.getOptionArgument("d", "dir"));
            }
            if (commandLine.hasOption("r")) {
                arguments.setRootDirectory(commandLine.getOptionArgument("r", "root"));
            }
            if (commandLine.hasOption("l")) {
                arguments.setLogDirectory(commandLine.getOptionArgument("l", "logDir"));
            }
            if (commandLine.hasOption("e")) {
                arguments.setDaysTillVersionsExpire(commandLine.getOptionArgument("e", "days"));
            }
            if (commandLine.hasOption("a")) {
                arguments.setUserpass(commandLine.getOptionArgument("a", "userpass"));
            }
            if (commandLine.hasOption("c")) {
                arguments.setCommand(commandLine.getOptionArgument("c", "command"));
            }
            if (commandLine.hasOption("b")) {
                arguments.setOutput(commandLine.getOptionArgument("b", "output"));
            }
            arguments.setOmitUpdates(commandLine.hasOption("o"));
            arguments.setInstallOnly(commandLine.hasOption("i"));
        }
        return arguments;
    }

    private static Logger makeLogger(Arguments arguments) {
        String logDirectory = arguments.getLogDirectory();
        return logDirectory != null ? new Logger(logDirectory) : null;
    }

    public static Authenticator makeAuthenticator(String authenticationParameter, ComponentFactory componentFactory) throws Exception {
        PromiscuousAuthenticator authenticator = new PromiscuousAuthenticator();
        if (authenticationParameter != null) {
            if (new File(authenticationParameter).exists()) {
                authenticator = new MultiUserAuthenticator(authenticationParameter);
            } else {
                String[] values = authenticationParameter.split(":");
                authenticator = new OneUserAuthenticator(values[0], values[1]);
            }
        }
        return componentFactory.getAuthenticator((Authenticator)authenticator);
    }

    private static void printUsage() {
        System.err.println("Usage: java -jar fitnesse.jar [-pdrleoab]");
        System.err.println("\t-p <port number> {80}");
        System.err.println("\t-d <working directory> {.}");
        System.err.println("\t-r <page root directory> {FitNesseRoot}");
        System.err.println("\t-l <log directory> {no logging}");
        System.err.println("\t-e <days> {14} Number of days before page versions expire");
        System.err.println("\t-o omit updates");
        System.err.println("\t-a {user:pwd | user-file-name} enable authentication.");
        System.err.println("\t-i Install only, then quit.");
        System.err.println("\t-c <command> execute single command.");
        System.err.println("\t-b <filename> redirect command output.");
    }

    private static void printStartMessage(Arguments args, FitNesseContext context) {
        System.out.println("FitNesse (" + FitNesse.VERSION + ") Started...");
        System.out.print(context.toString());
        System.out.println("\tpage version expiration set to " + args.getDaysTillVersionsExpire() + " days.");
        if (extraOutput != null) {
            System.out.print(extraOutput);
        }
    }
}

