/*
 * Decompiled with CFR 0.152.
 */
package fitnesseMain;

import fitnesse.Arguments;
import fitnesse.ComponentFactory;
import fitnesse.FitNesse;
import fitnesse.FitNesseContext;
import fitnesse.authentication.Authenticator;
import fitnesse.authentication.MultiUserAuthenticator;
import fitnesse.authentication.OneUserAuthenticator;
import fitnesse.authentication.PromiscuousAuthenticator;
import fitnesse.testutil.FitNesseUtil;
import fitnesseMain.FitNesseMain;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import util.FileUtil;

public class FitNesseMainTest {
    private FitNesseContext context;

    @Before
    public void setUp() throws Exception {
        this.context = FitNesseUtil.makeTestContext(null, null, (String)"testFitnesseRoot", (int)80);
    }

    @After
    public void tearDown() throws Exception {
        FileUtil.deleteFileSystemDirectory((String)"testFitnesseRoot");
    }

    @Test
    public void testInstallOnly() throws Exception {
        Arguments args = new Arguments();
        args.setInstallOnly(true);
        FitNesse fitnesse = (FitNesse)Mockito.mock(FitNesse.class);
        FitNesseMain.update((Arguments)args, (FitNesse)fitnesse);
        FitNesseMain.launch((Arguments)args, (FitNesseContext)this.context, (FitNesse)fitnesse);
        ((FitNesse)Mockito.verify((Object)fitnesse, (VerificationMode)Mockito.never())).start();
        ((FitNesse)Mockito.verify((Object)fitnesse, (VerificationMode)Mockito.times((int)1))).applyUpdates();
    }

    @Test
    public void commandArgCallsExecuteSingleCommand() throws Exception {
        FitNesseMain.dontExitAfterSingleCommand = true;
        Arguments args = new Arguments();
        args.setCommand("command");
        FitNesse fitnesse = (FitNesse)Mockito.mock(FitNesse.class);
        Mockito.when((Object)fitnesse.start()).thenReturn((Object)true);
        FitNesseMain.update((Arguments)args, (FitNesse)fitnesse);
        FitNesseMain.launch((Arguments)args, (FitNesseContext)this.context, (FitNesse)fitnesse);
        ((FitNesse)Mockito.verify((Object)fitnesse, (VerificationMode)Mockito.times((int)1))).applyUpdates();
        ((FitNesse)Mockito.verify((Object)fitnesse, (VerificationMode)Mockito.times((int)1))).start();
        ((FitNesse)Mockito.verify((Object)fitnesse, (VerificationMode)Mockito.times((int)1))).executeSingleCommand("command", (OutputStream)System.out);
        ((FitNesse)Mockito.verify((Object)fitnesse, (VerificationMode)Mockito.times((int)1))).stop();
    }

    @Test
    public void testDirCreations() throws Exception {
        new FitNesse(this.context);
        Assert.assertTrue((boolean)new File("testFitnesseRoot").exists());
        Assert.assertTrue((boolean)new File("testFitnesseRoot/files").exists());
    }

    @Test
    public void testMakeNullAuthenticator() throws Exception {
        Authenticator a = FitNesseMain.makeAuthenticator(null, (ComponentFactory)new ComponentFactory("blah"));
        Assert.assertTrue((boolean)(a instanceof PromiscuousAuthenticator));
    }

    @Test
    public void testMakeOneUserAuthenticator() throws Exception {
        Authenticator a = FitNesseMain.makeAuthenticator((String)"bob:uncle", (ComponentFactory)new ComponentFactory("blah"));
        Assert.assertTrue((boolean)(a instanceof OneUserAuthenticator));
        OneUserAuthenticator oua = (OneUserAuthenticator)a;
        Assert.assertEquals((Object)"bob", (Object)oua.getUser());
        Assert.assertEquals((Object)"uncle", (Object)oua.getPassword());
    }

    @Test
    public void testMakeMultiUserAuthenticator() throws Exception {
        String passwordFilename = "testpasswd";
        File passwd = new File("testpasswd");
        passwd.createNewFile();
        Authenticator a = FitNesseMain.makeAuthenticator((String)"testpasswd", (ComponentFactory)new ComponentFactory("blah"));
        Assert.assertTrue((boolean)(a instanceof MultiUserAuthenticator));
        passwd.delete();
    }

    @Test
    public void testIsRunning() throws Exception {
        this.context = FitNesseUtil.makeTestContext(null, null, null, (int)1999);
        FitNesse fitnesse = new FitNesse(this.context, false);
        Assert.assertFalse((boolean)fitnesse.isRunning());
        fitnesse.start();
        Assert.assertTrue((boolean)fitnesse.isRunning());
        fitnesse.stop();
        Assert.assertFalse((boolean)fitnesse.isRunning());
    }

    @Test
    public void testShouldInitializeFitNesseContext() {
        this.context = FitNesseUtil.makeTestContext(null, null, null, (int)1999);
        new FitNesse(this.context, false);
        Assert.assertNotNull((Object)FitNesse.FITNESSE_INSTANCE.getContext());
    }

    @Test
    public void canRunSingleCommand() throws Exception {
        String response = this.runFitnesseMainWith(new String[]{"-o", "-c", "/root"});
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Command Output"));
    }

    @Test
    public void canRunSingleCommandWithAuthentication() throws Exception {
        String response = this.runFitnesseMainWith(new String[]{"-o", "-a", "user:pwd", "-c", "user:pwd:/FitNesse.ReadProtectedPage"});
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"fitnesse.authentication.OneUserAuthenticator"));
    }

    private String runFitnesseMainWith(String ... args) throws Exception {
        FitNesseMain.dontExitAfterSingleCommand = true;
        PrintStream out = System.out;
        ByteArrayOutputStream outputBytes = new ByteArrayOutputStream();
        System.setOut(new PrintStream(outputBytes));
        FitNesseMain.main((String[])args);
        System.setOut(out);
        String response = outputBytes.toString();
        return response;
    }
}

