/*
 * Decompiled with CFR 0.152.
 */
package org.junit.experimental.categories;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.junit.experimental.categories.Categories;
import org.junit.experimental.categories.Category;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class Categories
extends Suite {
    public Categories(Class<?> klass, RunnerBuilder builder) throws InitializationError {
        super(klass, builder);
        try {
            Set included = Categories.getIncludedCategory(klass);
            Set excluded = Categories.getExcludedCategory(klass);
            boolean isAnyIncluded = Categories.isAnyIncluded(klass);
            boolean isAnyExcluded = Categories.isAnyExcluded(klass);
            this.filter((Filter)CategoryFilter.categoryFilter((boolean)isAnyIncluded, (Set)included, (boolean)isAnyExcluded, (Set)excluded));
        }
        catch (NoTestsRemainException e) {
            throw new InitializationError((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new InitializationError((Throwable)e);
        }
        Categories.assertNoCategorizedDescendentsOfUncategorizeableParents((Description)this.getDescription());
    }

    private static Set<Class<?>> getIncludedCategory(Class<?> klass) throws ClassNotFoundException {
        IncludeCategory annotation = klass.getAnnotation(IncludeCategory.class);
        return Categories.createSet((Class[])(annotation == null ? null : annotation.value()));
    }

    private static boolean isAnyIncluded(Class<?> klass) {
        IncludeCategory annotation = klass.getAnnotation(IncludeCategory.class);
        return annotation == null || annotation.matchAny();
    }

    private static Set<Class<?>> getExcludedCategory(Class<?> klass) throws ClassNotFoundException {
        ExcludeCategory annotation = klass.getAnnotation(ExcludeCategory.class);
        return Categories.createSet((Class[])(annotation == null ? null : annotation.value()));
    }

    private static boolean isAnyExcluded(Class<?> klass) {
        ExcludeCategory annotation = klass.getAnnotation(ExcludeCategory.class);
        return annotation == null || annotation.matchAny();
    }

    private static void assertNoCategorizedDescendentsOfUncategorizeableParents(Description description) throws InitializationError {
        if (!Categories.canHaveCategorizedChildren((Description)description)) {
            Categories.assertNoDescendantsHaveCategoryAnnotations((Description)description);
        }
        for (Description each : description.getChildren()) {
            Categories.assertNoCategorizedDescendentsOfUncategorizeableParents((Description)each);
        }
    }

    private static void assertNoDescendantsHaveCategoryAnnotations(Description description) throws InitializationError {
        for (Description each : description.getChildren()) {
            if (each.getAnnotation(Category.class) != null) {
                throw new InitializationError("Category annotations on Parameterized classes are not supported on individual methods.");
            }
            Categories.assertNoDescendantsHaveCategoryAnnotations((Description)each);
        }
    }

    private static boolean canHaveCategorizedChildren(Description description) {
        for (Description each : description.getChildren()) {
            if (each.getTestClass() != null) continue;
            return false;
        }
        return true;
    }

    private static boolean hasAssignableTo(Set<Class<?>> assigns, Class<?> to) {
        for (Class<?> from : assigns) {
            if (!to.isAssignableFrom(from)) continue;
            return true;
        }
        return false;
    }

    private static Set<Class<?>> createSet(Class<?> ... t) {
        HashSet set = new HashSet();
        if (t != null) {
            Collections.addAll(set, t);
        }
        return set;
    }

    static /* synthetic */ Set access$000(Class[] x0) {
        return Categories.createSet((Class[])x0);
    }

    static /* synthetic */ boolean access$100(Set x0, Class x1) {
        return Categories.hasAssignableTo((Set)x0, (Class)x1);
    }
}

