/*
 * Decompiled with CFR 0.152.
 */
package util;

import org.junit.Assert;
import org.junit.Test;
import util.StringUtil;

public class StringUtilTest {
    @Test
    public void testCombineArraysBothEmpty() {
        Assert.assertEquals((long)0L, (long)StringUtil.combineArrays((String[][])new String[][]{new String[0], new String[0]}).length);
    }

    @Test
    public void testCombineArraysWithOneItemInFirst() {
        String[] first = new String[]{"a"};
        String[] result = StringUtil.combineArrays((String[][])new String[][]{first, new String[0]});
        Assert.assertEquals((long)1L, (long)result.length);
        Assert.assertEquals((Object)"a", (Object)result[0]);
    }

    @Test
    public void testCombineArraysWithOneItemInEach() {
        String[] first = new String[]{"a"};
        String[] second = new String[]{"b"};
        String[] result = StringUtil.combineArrays((String[][])new String[][]{first, second});
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((Object)"a", (Object)result[0]);
        Assert.assertEquals((Object)"b", (Object)result[1]);
    }

    @Test
    public void testCombineArraysWithMixedNumbers() {
        String[] first = new String[]{"a", "b", "c"};
        String[] second = new String[]{"d", "e"};
        String[] third = new String[]{"f", "g", "h"};
        String[] result = StringUtil.combineArrays((String[][])new String[][]{first, second, third});
        Assert.assertEquals((long)8L, (long)result.length);
        Assert.assertEquals((Object)"a", (Object)result[0]);
        Assert.assertEquals((Object)"b", (Object)result[1]);
        Assert.assertEquals((Object)"c", (Object)result[2]);
        Assert.assertEquals((Object)"d", (Object)result[3]);
        Assert.assertEquals((Object)"e", (Object)result[4]);
        Assert.assertEquals((Object)"f", (Object)result[5]);
        Assert.assertEquals((Object)"g", (Object)result[6]);
        Assert.assertEquals((Object)"h", (Object)result[7]);
    }

    @Test
    public void testTrimNullStringReturnsNull() {
        Assert.assertEquals(null, (Object)StringUtil.trimNonNullString(null));
    }

    @Test
    public void testTrimAllSpacesStringResultsInEmptyString() {
        Assert.assertEquals((Object)"", (Object)StringUtil.trimNonNullString((String)"   "));
    }

    @Test
    public void testTrimStringWithLeadingAndTrailingSpaces() {
        Assert.assertEquals((Object)"FitNesse", (Object)StringUtil.trimNonNullString((String)" FitNesse "));
    }

    @Test
    public void replaceAll() throws Exception {
        Assert.assertEquals((Object)"my name is Bob, Bob is my name", (Object)StringUtil.replaceAll((String)"my name is $name, $name is my name", (String)"$name", (String)"Bob"));
        Assert.assertEquals((Object)"_$namex_", (Object)StringUtil.replaceAll((String)"_$name_", (String)"$name", (String)"$namex"));
    }

    @Test
    public void shouldStripCarriageReturns() throws Exception {
        Assert.assertEquals((Object)"\n", (Object)StringUtil.stripCarriageReturns((String)"\n"));
        Assert.assertEquals((Object)"\n", (Object)StringUtil.stripCarriageReturns((String)"\n\r"));
        Assert.assertEquals((Object)"\n", (Object)StringUtil.stripCarriageReturns((String)"\n\r\r\r\r\r"));
        Assert.assertEquals((Object)"\n", (Object)StringUtil.stripCarriageReturns((String)"\r\n"));
        Assert.assertEquals((Object)"\n\n", (Object)StringUtil.stripCarriageReturns((String)"\r\n\r\n\r\r\r"));
        Assert.assertEquals((Object)"This\nis\na\nset\nof\nlines.\n", (Object)StringUtil.stripCarriageReturns((String)"This\n\ris\r\na\nset\r\n\rof\nlines.\n\r"));
    }
}

