/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.maven.plugin.dependency.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.scijava.maven.plugin.dependency.tree.DependencyNode;

public class DependencyTree {
    private final DependencyNode rootNode;
    private final Collection<DependencyNode> nodes;

    public DependencyTree(DependencyNode rootNode, Collection<DependencyNode> nodes) {
        this.rootNode = rootNode;
        this.nodes = nodes;
    }

    public DependencyNode getRootNode() {
        return this.rootNode;
    }

    public Collection<DependencyNode> getNodes() {
        return this.nodes;
    }

    public List<Artifact> getArtifacts() {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        for (DependencyNode node : this.getNodes()) {
            artifacts.add(node.getArtifact());
        }
        return artifacts;
    }

    public String toString() {
        return this.getRootNode().toString();
    }

    public Iterator<DependencyNode> iterator() {
        return this.getRootNode().iterator();
    }

    public Iterator<DependencyNode> preorderIterator() {
        return this.getRootNode().preorderIterator();
    }

    public Iterator<DependencyNode> inverseIterator() {
        return this.getRootNode().inverseIterator();
    }
}

