/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.maven.plugin.enforcer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import jdepend.framework.JavaClass;
import jdepend.framework.JavaPackage;
import org.scijava.maven.plugin.enforcer.CollectionOutput;
import org.scijava.maven.plugin.enforcer.JavaClassNameComparator;
import org.scijava.maven.plugin.enforcer.JavaPackageNameComparator;

public class SubpackageDependenceOutput {
    private Map<JavaPackage, List<JavaPackage>> packages;
    private StringBuilder output;

    public SubpackageDependenceOutput(Map<JavaPackage, List<JavaPackage>> packages) {
        this.packages = packages;
    }

    public String getOutput() {
        this.output = new StringBuilder();
        for (Map.Entry<JavaPackage, List<JavaPackage>> e : this.collectAndSortCycles()) {
            if (e.getValue().isEmpty()) continue;
            this.appendOutputForSubpackageDependence(e);
        }
        return this.output.toString();
    }

    private List<Map.Entry<JavaPackage, List<JavaPackage>>> collectAndSortCycles() {
        ArrayList<Map.Entry<JavaPackage, List<JavaPackage>>> orderedList = new ArrayList<Map.Entry<JavaPackage, List<JavaPackage>>>();
        for (Map.Entry<JavaPackage, List<JavaPackage>> e : this.packages.entrySet()) {
            Collections.sort(e.getValue(), JavaPackageNameComparator.INSTANCE);
            orderedList.add(e);
        }
        Collections.sort(orderedList, (e1, e2) -> JavaPackageNameComparator.INSTANCE.compare((JavaPackage)e1.getKey(), (JavaPackage)e2.getKey()));
        return orderedList;
    }

    private void appendOutputForSubpackageDependence(Map.Entry<JavaPackage, List<JavaPackage>> subpackageDependence) {
        JavaPackage p = subpackageDependence.getKey();
        this.packages.remove(p);
        this.appendHeaderForSubpackageDependence(subpackageDependence);
        for (JavaPackage cyclicPackage : subpackageDependence.getValue()) {
            this.appendOutputForSubPackage(p, cyclicPackage);
        }
    }

    private void appendHeaderForSubpackageDependence(Map.Entry<JavaPackage, List<JavaPackage>> entry) {
        this.output.append("\n\n").append("Package " + entry.getKey().getName() + " depends on subpackages: ");
    }

    private void appendOutputForSubPackage(JavaPackage javaPackage, JavaPackage subpackage) {
        if (javaPackage.equals((Object)subpackage)) {
            return;
        }
        List<JavaClass> dependentClasses = this.getOrderedDependentClasses(javaPackage, subpackage);
        if (!dependentClasses.isEmpty()) {
            this.appendOutputForDependentCyclicPackage(subpackage, dependentClasses);
        }
    }

    private List<JavaClass> getOrderedDependentClasses(JavaPackage javaPackage, JavaPackage cyclicPackage) {
        ArrayList<JavaClass> dependentClasses = new ArrayList<JavaClass>();
        Collection allClasses = javaPackage.getClasses();
        for (JavaClass javaClass : allClasses) {
            if (!javaClass.getImportedPackages().contains(cyclicPackage)) continue;
            dependentClasses.add(javaClass);
        }
        Collections.sort(dependentClasses, JavaClassNameComparator.INSTANCE);
        return dependentClasses;
    }

    private void appendOutputForDependentCyclicPackage(JavaPackage cyclicPackage, List<JavaClass> dependentClasses) {
        this.output.append("\n        ").append(cyclicPackage.getName()).append(" (");
        this.appendOutputForCyclicPackageClasses(dependentClasses);
        this.output.append(")");
    }

    private void appendOutputForCyclicPackageClasses(List<JavaClass> dependentClasses) {
        CollectionOutput.joinCollection(dependentClasses, this.output, new CollectionOutput.Appender<JavaClass>(){

            @Override
            public void append(JavaClass packageClass) {
                SubpackageDependenceOutput.this.output.append(packageClass.getName().substring(packageClass.getPackageName().length() + 1));
            }
        }, ", ");
    }
}

