/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealPoint;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayCursor;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.mesh.Mesh;
import net.imglib2.mesh.impl.naive.NaiveDoubleMesh;
import net.imglib2.roi.EllipseRegionOfInterest;
import net.imglib2.roi.geom.real.DefaultWritablePolygon2D;
import net.imglib2.roi.geom.real.Polygon2D;
import net.imglib2.roi.labeling.ImgLabeling;
import net.imglib2.roi.labeling.LabelRegion;
import net.imglib2.roi.labeling.LabelRegions;
import net.imglib2.roi.labeling.LabelingType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.RandomAccessibleIntervalCursor;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.junit.jupiter.api.BeforeEach;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.util.LongArray;

public class AbstractFeatureTest
extends AbstractOpTest {
    protected static final boolean expensiveTestsEnabled = "enabled".equals(System.getProperty("scijava.ops.image.expensive.tests"));
    protected static final double SMALL_DELTA = 1.0E-7;
    protected static final double MEDIUM_DELTA = 1.0E-5;
    protected static final double BIG_DELTA = 0.001;
    protected static final long SEED = 1234567890L;
    protected Img<UnsignedByteType> empty;
    protected Img<UnsignedByteType> constant;
    protected Img<UnsignedByteType> random;
    protected Img<UnsignedByteType> empty3d;
    protected Img<UnsignedByteType> constant3d;
    protected Img<UnsignedByteType> random3d;
    protected Img<UnsignedByteType> ellipse;
    protected Img<UnsignedByteType> rotatedEllipse;

    @BeforeEach
    public void setup() {
        ImageGenerator dataGenerator = new ImageGenerator(1234567890L);
        long[] dim = new long[]{100L, 100L};
        long[] dim3 = new long[]{100L, 100L, 30L};
        this.empty = dataGenerator.getEmptyUnsignedByteImg(dim);
        this.constant = dataGenerator.getConstantUnsignedByteImg(dim, 15);
        this.random = dataGenerator.getRandomUnsignedByteImg(dim);
        this.empty3d = dataGenerator.getEmptyUnsignedByteImg(dim3);
        this.constant3d = dataGenerator.getConstantUnsignedByteImg(dim3, 15);
        this.random3d = dataGenerator.getRandomUnsignedByteImg(dim3);
        double[] offset = new double[]{0.0, 0.0};
        double[] radii = new double[]{20.0, 40.0};
        this.ellipse = dataGenerator.getEllipsedBitImage(dim, radii, offset);
        offset = new double[]{10.0, -10.0};
        radii = new double[]{40.0, 20.0};
        this.rotatedEllipse = dataGenerator.getEllipsedBitImage(dim, radii, offset);
    }

    protected static Img<FloatType> getTestImage2D() {
        return AbstractFeatureTest.openRelativeFloatImg(AbstractFeatureTest.class, "features/2d_geometric_features_testlabel.tif");
    }

    protected static Polygon2D getPolygon() {
        ArrayList vertices = new ArrayList();
        try {
            Files.lines(Paths.get(AbstractFeatureTest.class.getResource("features/2d_geometric_features_polygon.txt").toURI())).forEach(l -> {
                String[] coord = l.split(" ");
                RealPoint v = new RealPoint(new double[]{Double.parseDouble(coord[0]), Double.parseDouble(coord[1])});
                vertices.add(v);
            });
        }
        catch (IOException | URISyntaxException exc) {
            exc.printStackTrace();
        }
        return new DefaultWritablePolygon2D(vertices);
    }

    protected static Img<FloatType> getTestImage3D() {
        return AbstractFeatureTest.openRelativeFloatImg(AbstractFeatureTest.class, "features/3d_geometric_features_testlabel.tif");
    }

    protected static Mesh getMesh() {
        NaiveDoubleMesh m = new NaiveDoubleMesh();
        HashMap indexMap = new HashMap();
        LongArray indices = new LongArray();
        try {
            Files.lines(Paths.get(AbstractFeatureTest.class.getResource("features/3d_geometric_features_mesh.txt").toURI())).forEach(arg_0 -> AbstractFeatureTest.lambda$getMesh$2(indexMap, (Mesh)m, indices, arg_0));
        }
        catch (IOException | URISyntaxException exc) {
            exc.printStackTrace();
        }
        for (int i = 0; i < indices.size(); i += 3) {
            long v0 = indices.get(i);
            long v1 = indices.get(i + 1);
            long v2 = indices.get(i + 2);
            m.triangles().add(v0, v1, v2);
        }
        return m;
    }

    protected static <T extends RealType<T>> LabelRegion<String> createLabelRegion(RandomAccessibleInterval<T> interval, float min, float max, long ... dims) {
        if (dims == null || dims.length == 0) {
            dims = new long[interval.numDimensions()];
            interval.dimensions(dims);
        }
        ImgLabeling labeling = new ImgLabeling((RandomAccessibleInterval)ArrayImgs.ints((long[])dims));
        RandomAccess ra = labeling.randomAccess();
        RandomAccessibleIntervalCursor c = new RandomAccessibleIntervalCursor(interval);
        long[] pos = new long[labeling.numDimensions()];
        while (c.hasNext()) {
            RealType item = (RealType)c.next();
            float value = item.getRealFloat();
            if (!(value >= min) || !(value <= max)) continue;
            c.localize(pos);
            ra.setPosition(pos);
            ((LabelingType)ra.get()).add((Object)"1");
        }
        LabelRegions labelRegions = new LabelRegions((RandomAccessibleInterval)labeling);
        return labelRegions.getLabelRegion((Object)"1");
    }

    private static /* synthetic */ void lambda$getMesh$2(Map indexMap, Mesh m, LongArray indices, String l) {
        String[] coord = l.split(" ");
        double x = Double.parseDouble(coord[0]);
        double y = Double.parseDouble(coord[1]);
        double z = Double.parseDouble(coord[2]);
        Vector3D vertex = new Vector3D(x, y, z);
        long vIndex = indexMap.computeIfAbsent(vertex, v -> m.vertices().add(x, y, z));
        indices.add((Object)vIndex);
    }

    class ImageGenerator {
        private final Random rand;

        public ImageGenerator(long seed) {
            this.rand = new Random(seed);
        }

        public Img<UnsignedByteType> getEmptyUnsignedByteImg(long[] dim) {
            return ArrayImgs.unsignedBytes((long[])dim);
        }

        public Img<UnsignedByteType> getRandomUnsignedByteImg(long[] dim) {
            ArrayImg img = ArrayImgs.unsignedBytes((long[])dim);
            UnsignedByteType type = (UnsignedByteType)img.firstElement();
            ArrayCursor cursor = img.cursor();
            while (cursor.hasNext()) {
                ((UnsignedByteType)cursor.next()).set(this.rand.nextInt((int)type.getMaxValue()));
            }
            return img;
        }

        public Img<UnsignedByteType> getConstantUnsignedByteImg(long[] dim, int constValue) {
            ArrayImg img = ArrayImgs.unsignedBytes((long[])dim);
            UnsignedByteType type = (UnsignedByteType)img.firstElement();
            if ((double)constValue < type.getMinValue() || (double)constValue >= type.getMaxValue()) {
                throw new IllegalArgumentException("Can't create image for constant [" + constValue + "]");
            }
            ArrayCursor cursor = img.cursor();
            while (cursor.hasNext()) {
                ((UnsignedByteType)cursor.next()).set(constValue);
            }
            return img;
        }

        public Img<UnsignedByteType> getEllipsedBitImage(long[] dim, double[] radii, double[] offset) {
            ArrayImg img = ArrayImgs.unsignedBytes((long[])dim);
            EllipseRegionOfInterest ellipse = new EllipseRegionOfInterest();
            ellipse.setRadii(radii);
            double[] origin = new double[dim.length];
            for (int i = 0; i < dim.length; ++i) {
                origin[i] = dim[i] / 2L;
            }
            ellipse.setOrigin(origin);
            IterableInterval ii = ellipse.getIterableIntervalOverROI((RandomAccessible)img);
            Cursor cursor = ii.cursor();
            while (cursor.hasNext()) {
                cursor.next();
                ((UnsignedByteType)cursor.get()).set(255);
            }
            return img;
        }
    }
}

