/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image;

import io.scif.img.IO;
import java.net.URL;
import java.util.stream.StreamSupport;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.Views;
import org.scijava.ops.api.Hints;
import org.scijava.ops.api.OpEnvironment;

public abstract class AbstractOpTest {
    protected static final OpEnvironment ops = OpEnvironment.build();
    private int seed;

    private int pseudoRandom() {
        this.seed = 3170425 * this.seed + 132102;
        return this.seed;
    }

    public Img<FloatType> openFloatImg(String resourcePath) {
        return AbstractOpTest.openRelativeFloatImg(this.getClass(), resourcePath);
    }

    public Img<DoubleType> openDoubleImg(String resourcePath) {
        return AbstractOpTest.openRelativeDoubleImg(this.getClass(), resourcePath);
    }

    public Img<UnsignedByteType> openUnsignedByteImg(String resourcePath) {
        return AbstractOpTest.openRelativeUnsignedByteImg(this.getClass(), resourcePath);
    }

    public static Img<FloatType> openRelativeFloatImg(Class<?> base, String resourcePath) {
        URL url = base.getResource(resourcePath);
        return IO.openFloat((String)url.getPath()).getImg();
    }

    public static Img<DoubleType> openRelativeDoubleImg(Class<?> base, String resourcePath) {
        URL url = base.getResource(resourcePath);
        return IO.openDouble((String)url.getPath()).getImg();
    }

    public static Img<UnsignedByteType> openRelativeUnsignedByteImg(Class<?> base, String resourcePath) {
        URL url = base.getResource(resourcePath);
        return IO.openUnsignedByte((String)url.getPath()).getImg();
    }

    public static <T> RandomAccessible<T> deinterval(RandomAccessibleInterval<T> input) {
        return Views.extendBorder(input);
    }

    public <T extends RealType<T>> boolean areCongruent(IterableInterval<T> in, RandomAccessible<T> out, double epsilon) {
        Cursor cin = in.localizingCursor();
        RandomAccess raOut = out.randomAccess();
        while (cin.hasNext()) {
            cin.fwd();
            raOut.setPosition((Localizable)cin);
            if (!(Math.abs(((RealType)cin.get()).getRealDouble() - ((RealType)raOut.get()).getRealDouble()) > epsilon)) continue;
            return false;
        }
        return true;
    }

    public <T extends RealType<T>> double[] asArray(Iterable<T> image) {
        return StreamSupport.stream(image.spliterator(), false).mapToDouble(ComplexType::getRealDouble).toArray();
    }

    static {
        ops.setDefaultHints(new Hints(new String[]{"progress.TRACK"}));
    }
}

