/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.coloc.icq;

import java.util.function.BiFunction;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.real.FloatType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.api.OpBuilder;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.image.AbstractColocalisationTest;
import org.scijava.ops.image.coloc.pValue.PValueResult;
import org.scijava.ops.image.util.TestImgGeneration;
import org.scijava.types.Nil;

public class LiICQTest
extends AbstractColocalisationTest {
    @Test
    public void testICQ() {
        ArrayImg<ByteType, ByteArray> img1 = TestImgGeneration.byteArray(true, 10L, 15L, 20L);
        ArrayImg<ByteType, ByteArray> img2 = TestImgGeneration.byteArray(true, 10L, 15L, 20L);
        Double icqValue = (Double)ops.op("coloc.icq").input(img1, img2).outType(Double.class).apply();
        Assertions.assertEquals((double)0.5, (double)icqValue, (double)0.0);
    }

    @Test
    public void testLiPositiveCorr() {
        Double icqValue = (Double)ops.op("coloc.icq").input(LiICQTest.getPositiveCorrelationImageCh1(), LiICQTest.getPositiveCorrelationImageCh2()).outType(Double.class).apply();
        Assertions.assertTrue((icqValue > 0.34 && icqValue < 0.35 ? 1 : 0) != 0);
    }

    @Test
    public void testLiZeroCorr() {
        Object icqValue = ops.op("coloc.icq").input(LiICQTest.getZeroCorrelationImageCh1(), LiICQTest.getZeroCorrelationImageCh2()).apply();
        Assertions.assertTrue((boolean)(icqValue instanceof Double));
        double icq = (Double)icqValue;
        Assertions.assertTrue((Math.abs(icq) < 0.01 ? 1 : 0) != 0);
    }

    @Test
    public void testPValue() {
        double mean = 0.2;
        double spread = 0.1;
        double[] sigma = new double[]{3.0, 3.0};
        Img<FloatType> ch1 = AbstractColocalisationTest.produceMeanBasedNoiseImage(new FloatType(), 24, 24, 0.2, 0.1, sigma, 19088743L);
        Img<FloatType> ch2 = AbstractColocalisationTest.produceMeanBasedNoiseImage(new FloatType(), 24, 24, 0.2, 0.1, sigma, -1737075662L);
        BiFunction op = OpBuilder.matchFunction((OpEnvironment)ops, (String)"coloc.icq", (Nil)new Nil<RandomAccessibleInterval<FloatType>>(){}, (Nil)new Nil<RandomAccessibleInterval<FloatType>>(){}, (Nil)new Nil<Double>(){});
        PValueResult value = new PValueResult();
        ops.op("coloc.pValue").input(ch1, ch2, (Object)op).output((Object)value).compute();
        Assertions.assertEquals((double)0.72, (double)value.getPValue(), (double)0.0);
    }
}

