/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.convert;

import java.math.BigInteger;
import net.imglib2.Cursor;
import net.imglib2.FinalDimensions;
import net.imglib2.IterableInterval;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.complex.ComplexDoubleType;
import net.imglib2.type.numeric.complex.ComplexFloatType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.Unsigned128BitType;
import net.imglib2.type.numeric.integer.Unsigned12BitType;
import net.imglib2.type.numeric.integer.Unsigned2BitType;
import net.imglib2.type.numeric.integer.Unsigned4BitType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedLongType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.ops.image.convert.Types;

public class TestConvertImages
extends AbstractOpTest {
    private final BigInteger p64 = new BigInteger("AEF234567ABCD123", 16);
    private final BigInteger n64 = new BigInteger("-1399890AB", 16);
    private final BigInteger beef = BigInteger.valueOf(48879L);
    private final BigInteger biZero = BigInteger.ZERO;
    private final BigInteger p128 = new BigInteger("2CAFE0321BEEF0717BABE0929DEAD0311", 16);
    private final BigInteger n128 = new BigInteger("-482301498A285BFD0982EE7DE02398BC9080459284CCDE90E9F0D00C043981210481AAADEF2", 16);

    @Test
    public void testBitToBit() {
        BitType b = new BitType(true);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.bit").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.bit((long)1L), (Object)((BitType)cursor.next()).get());
        }
        b.set(false);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.bit").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.bit((long)0L), (Object)((BitType)cursor.next()).get());
        }
    }

    @Test
    public void testUint2ToBit() {
        Unsigned2BitType b = new Unsigned2BitType(2L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.bit").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.bit((long)2L), (Object)((BitType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.bit").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.bit((long)0L), (Object)((BitType)cursor.next()).get());
        }
    }

    @Test
    public void testUint4ToBit() {
        Unsigned4BitType b = new Unsigned4BitType(15L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.bit").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.bit((long)15L), (Object)((BitType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.bit").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.bit((long)0L), (Object)((BitType)cursor.next()).get());
        }
    }

    @Test
    public void testInt8ToBit() {
        ByteType b = new ByteType(8);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.bit").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.bit((long)8L), (Object)((BitType)cursor.next()).get());
        }
        b.set((byte)0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.bit").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.bit((long)0L), (Object)((BitType)cursor.next()).get());
        }
        b.set((byte)-12);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.bit").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.bit((long)-12L), (Object)((BitType)cursor.next()).get());
        }
    }

    @Test
    public void testUint8ToBit() {
        UnsignedByteType b = new UnsignedByteType(100);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.bit").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.bit((long)100L), (Object)((BitType)cursor.next()).get());
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.bit").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.bit((long)0L), (Object)((BitType)cursor.next()).get());
        }
    }

    @Test
    public void testUint12ToBit() {
        Unsigned12BitType b = new Unsigned12BitType(212L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.bit").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.bit((long)212L), (Object)((BitType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.bit").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.bit((long)0L), (Object)((BitType)cursor.next()).get());
        }
    }

    @Test
    public void testInt16ToBit() {
        ShortType b = new ShortType(52);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.bit").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.bit((long)52L), (Object)((BitType)cursor.next()).get());
        }
        b.set((short)0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.bit").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.bit((long)0L), (Object)((BitType)cursor.next()).get());
        }
        b.set((short)-154);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.bit").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.bit((long)-154L), (Object)((BitType)cursor.next()).get());
        }
    }

    @Test
    public void testUint16ToBit() {
        UnsignedShortType b = new UnsignedShortType(480);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.bit").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.bit((long)480L), (Object)((BitType)cursor.next()).get());
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.bit").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.bit((long)0L), (Object)((BitType)cursor.next()).get());
        }
    }

    @Test
    public void testInt32ToBit() {
        IntType b = new IntType(301);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.bit").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.bit((long)301L), (Object)((BitType)cursor.next()).get());
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.bit").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.bit((long)0L), (Object)((BitType)cursor.next()).get());
        }
        b.set(-89);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.bit").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.bit((long)-89L), (Object)((BitType)cursor.next()).get());
        }
    }

    @Test
    public void testUint32ToBit() {
        UnsignedIntType b = new UnsignedIntType(20L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.bit").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.bit((long)20L), (Object)((BitType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.bit").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.bit((long)0L), (Object)((BitType)cursor.next()).get());
        }
    }

    @Test
    public void testInt64ToBit() {
        LongType b = new LongType(891L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.bit").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.bit((long)891L), (Object)((BitType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.bit").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.bit((long)0L), (Object)((BitType)cursor.next()).get());
        }
        b.set(-1024L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.bit").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.bit((long)-1024L), (Object)((BitType)cursor.next()).get());
        }
    }

    @Test
    public void testUint64ToBit() {
        UnsignedLongType b = new UnsignedLongType(1049L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.bit").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.bit((long)1049L), (Object)((BitType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.bit").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.bit((long)0L), (Object)((BitType)cursor.next()).get());
        }
        b.set(this.p64);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.bit").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.bit((BigInteger)this.p64), (Object)((BitType)cursor.next()).get());
        }
    }

    @Test
    public void testUint128ToBit() {
        Unsigned128BitType b = new Unsigned128BitType(this.beef);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.bit").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.bit((BigInteger)this.beef), (Object)((BitType)cursor.next()).get());
        }
        b.set(this.biZero);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.bit").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.bit((BigInteger)this.biZero), (Object)((BitType)cursor.next()).get());
        }
        b.set(this.p128);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.bit").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.bit((BigInteger)this.p128), (Object)((BitType)cursor.next()).get());
        }
    }

    @Test
    public void testFloat32ToBit() {
        FloatType b = new FloatType(123453.125f);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.bit").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.bit((double)123453.125), (Object)((BitType)cursor.next()).get());
        }
        b.set(0.0f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.bit").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.bit((double)0.0), (Object)((BitType)cursor.next()).get());
        }
        b.set(-2.5234854E12f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.bit").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.bit((double)-2.523485437952E12), (Object)((BitType)cursor.next()).get());
        }
    }

    @Test
    public void testCfloat32ToBit() {
        ComplexFloatType b = new ComplexFloatType(5839.25f, 120.0f);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.bit").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.bit((double)5839.25), (Object)((BitType)cursor.next()).get());
        }
        b.set(0.0f, 0.0f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.bit").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.bit((double)0.0), (Object)((BitType)cursor.next()).get());
        }
        b.set(-4.25f, -123.0625f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.bit").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.bit((double)-4.25), (Object)((BitType)cursor.next()).get());
        }
    }

    @Test
    public void testFloat64ToBit() {
        DoubleType b = new DoubleType(4098.0);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.bit").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.bit((double)4098.0), (Object)((BitType)cursor.next()).get());
        }
        b.set(0.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.bit").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.bit((double)0.0), (Object)((BitType)cursor.next()).get());
        }
        b.set(-10948.015625);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.bit").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.bit((double)-10948.015625), (Object)((BitType)cursor.next()).get());
        }
        b.set(1.0000152587890626E20);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.bit").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.bit((double)1.0000152587890626E20), (Object)((BitType)cursor.next()).get());
        }
    }

    @Test
    public void testCfloat64ToBit() {
        ComplexDoubleType b = new ComplexDoubleType(9087.0, 879542.125);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.bit").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.bit((double)9087.0), (Object)((BitType)cursor.next()).get());
        }
        b.set(0.0, 0.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.bit").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.bit((double)0.0), (Object)((BitType)cursor.next()).get());
        }
        b.set(-234.25, -9.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.bit").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.bit((double)-234.25), (Object)((BitType)cursor.next()).get());
        }
    }

    @Test
    public void testBitToUint2() {
        BitType b = new BitType(true);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint2").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint2((long)1L), (long)((Unsigned2BitType)cursor.next()).get());
        }
        b.set(false);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint2").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint2((long)0L), (long)((Unsigned2BitType)cursor.next()).get());
        }
    }

    @Test
    public void testUint2ToUint2() {
        Unsigned2BitType b = new Unsigned2BitType(2L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint2").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint2((long)2L), (long)((Unsigned2BitType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint2").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint2((long)0L), (long)((Unsigned2BitType)cursor.next()).get());
        }
    }

    @Test
    public void testUint4ToUint2() {
        Unsigned4BitType b = new Unsigned4BitType(15L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint2").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint2((long)15L), (long)((Unsigned2BitType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint2").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint2((long)0L), (long)((Unsigned2BitType)cursor.next()).get());
        }
    }

    @Test
    public void testInt8ToUint2() {
        ByteType b = new ByteType(8);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint2").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint2((long)8L), (long)((Unsigned2BitType)cursor.next()).get());
        }
        b.set((byte)0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint2").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint2((long)0L), (long)((Unsigned2BitType)cursor.next()).get());
        }
        b.set((byte)-12);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint2").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint2((long)-12L), (long)((Unsigned2BitType)cursor.next()).get());
        }
    }

    @Test
    public void testUint8ToUint2() {
        UnsignedByteType b = new UnsignedByteType(100);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint2").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint2((long)100L), (long)((Unsigned2BitType)cursor.next()).get());
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint2").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint2((long)0L), (long)((Unsigned2BitType)cursor.next()).get());
        }
    }

    @Test
    public void testUint12ToUint2() {
        Unsigned12BitType b = new Unsigned12BitType(212L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint2").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint2((long)212L), (long)((Unsigned2BitType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint2").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint2((long)0L), (long)((Unsigned2BitType)cursor.next()).get());
        }
    }

    @Test
    public void testInt16ToUint2() {
        ShortType b = new ShortType(52);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint2").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint2((long)52L), (long)((Unsigned2BitType)cursor.next()).get());
        }
        b.set((short)0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint2").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint2((long)0L), (long)((Unsigned2BitType)cursor.next()).get());
        }
        b.set((short)-154);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint2").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint2((long)-154L), (long)((Unsigned2BitType)cursor.next()).get());
        }
    }

    @Test
    public void testUint16ToUint2() {
        UnsignedShortType b = new UnsignedShortType(480);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint2").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint2((long)480L), (long)((Unsigned2BitType)cursor.next()).get());
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint2").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint2((long)0L), (long)((Unsigned2BitType)cursor.next()).get());
        }
    }

    @Test
    public void testInt32ToUint2() {
        IntType b = new IntType(301);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint2").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint2((long)301L), (long)((Unsigned2BitType)cursor.next()).get());
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint2").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint2((long)0L), (long)((Unsigned2BitType)cursor.next()).get());
        }
        b.set(-89);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint2").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint2((long)-89L), (long)((Unsigned2BitType)cursor.next()).get());
        }
    }

    @Test
    public void testUint32ToUint2() {
        UnsignedIntType b = new UnsignedIntType(20L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint2").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint2((long)20L), (long)((Unsigned2BitType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint2").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint2((long)0L), (long)((Unsigned2BitType)cursor.next()).get());
        }
    }

    @Test
    public void testInt64ToUint2() {
        LongType b = new LongType(891L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint2").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint2((long)891L), (long)((Unsigned2BitType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint2").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint2((long)0L), (long)((Unsigned2BitType)cursor.next()).get());
        }
        b.set(-1024L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint2").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint2((long)-1024L), (long)((Unsigned2BitType)cursor.next()).get());
        }
    }

    @Test
    public void testUint64ToUint2() {
        UnsignedLongType b = new UnsignedLongType(1049L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint2").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint2((long)1049L), (long)((Unsigned2BitType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint2").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint2((long)0L), (long)((Unsigned2BitType)cursor.next()).get());
        }
        b.set(this.p64);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint2").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint2((Number)this.p64), (long)((Unsigned2BitType)cursor.next()).get());
        }
    }

    @Test
    public void testUint128ToUint2() {
        Unsigned128BitType b = new Unsigned128BitType(this.beef);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint2").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint2((Number)this.beef), (long)((Unsigned2BitType)cursor.next()).get());
        }
        b.set(this.biZero);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint2").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint2((Number)this.biZero), (long)((Unsigned2BitType)cursor.next()).get());
        }
        b.set(this.p128);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint2").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint2((Number)this.p128), (long)((Unsigned2BitType)cursor.next()).get());
        }
    }

    @Test
    public void testFloat32ToUint2() {
        FloatType b = new FloatType(123453.125f);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint2").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint2((double)123453.125), (long)((Unsigned2BitType)cursor.next()).get());
        }
        b.set(0.0f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint2").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint2((double)0.0), (long)((Unsigned2BitType)cursor.next()).get());
        }
        b.set(-2.5234854E12f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint2").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint2((double)-2.523485437952E12), (long)((Unsigned2BitType)cursor.next()).get());
        }
    }

    @Test
    public void testCfloat32ToUint2() {
        ComplexFloatType b = new ComplexFloatType(5839.25f, 120.0f);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint2").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint2((double)5839.25), (long)((Unsigned2BitType)cursor.next()).get());
        }
        b.set(0.0f, 0.0f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint2").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint2((double)0.0), (long)((Unsigned2BitType)cursor.next()).get());
        }
        b.set(-4.25f, -123.0625f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint2").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint2((double)-4.25), (long)((Unsigned2BitType)cursor.next()).get());
        }
    }

    @Test
    public void testFloat64ToUint2() {
        DoubleType b = new DoubleType(4098.0);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint2").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint2((double)4098.0), (long)((Unsigned2BitType)cursor.next()).get());
        }
        b.set(0.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint2").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint2((double)0.0), (long)((Unsigned2BitType)cursor.next()).get());
        }
        b.set(-10948.015625);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint2").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint2((double)-10948.015625), (long)((Unsigned2BitType)cursor.next()).get());
        }
        b.set(1.0000152587890626E20);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint2").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint2((double)1.0000152587890626E20), (long)((Unsigned2BitType)cursor.next()).get());
        }
    }

    @Test
    public void testCfloat64ToUint2() {
        ComplexDoubleType b = new ComplexDoubleType(9087.0, 879542.125);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint2").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint2((double)9087.0), (long)((Unsigned2BitType)cursor.next()).get());
        }
        b.set(0.0, 0.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint2").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint2((double)0.0), (long)((Unsigned2BitType)cursor.next()).get());
        }
        b.set(-234.25, -9.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint2").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint2((double)-234.25), (long)((Unsigned2BitType)cursor.next()).get());
        }
    }

    @Test
    public void testBitToUint4() {
        BitType b = new BitType(true);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint4").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint4((long)1L), (long)((Unsigned4BitType)cursor.next()).get());
        }
        b.set(false);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint4").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint4((long)0L), (long)((Unsigned4BitType)cursor.next()).get());
        }
    }

    @Test
    public void testUint2ToUint4() {
        Unsigned2BitType b = new Unsigned2BitType(2L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint4").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint4((long)2L), (long)((Unsigned4BitType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint4").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint4((long)0L), (long)((Unsigned4BitType)cursor.next()).get());
        }
    }

    @Test
    public void testUint4ToUint4() {
        Unsigned4BitType b = new Unsigned4BitType(15L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint4").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint4((long)15L), (long)((Unsigned4BitType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint4").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint4((long)0L), (long)((Unsigned4BitType)cursor.next()).get());
        }
    }

    @Test
    public void testInt8ToUint4() {
        ByteType b = new ByteType(8);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint4").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint4((long)8L), (long)((Unsigned4BitType)cursor.next()).get());
        }
        b.set((byte)0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint4").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint4((long)0L), (long)((Unsigned4BitType)cursor.next()).get());
        }
        b.set((byte)-12);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint4").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint4((long)-12L), (long)((Unsigned4BitType)cursor.next()).get());
        }
    }

    @Test
    public void testUint8ToUint4() {
        UnsignedByteType b = new UnsignedByteType(100);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint4").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint4((long)100L), (long)((Unsigned4BitType)cursor.next()).get());
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint4").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint4((long)0L), (long)((Unsigned4BitType)cursor.next()).get());
        }
    }

    @Test
    public void testUint12ToUint4() {
        Unsigned12BitType b = new Unsigned12BitType(212L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint4").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint4((long)212L), (long)((Unsigned4BitType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint4").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint4((long)0L), (long)((Unsigned4BitType)cursor.next()).get());
        }
    }

    @Test
    public void testInt16ToUint4() {
        ShortType b = new ShortType(52);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint4").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint4((long)52L), (long)((Unsigned4BitType)cursor.next()).get());
        }
        b.set((short)0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint4").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint4((long)0L), (long)((Unsigned4BitType)cursor.next()).get());
        }
        b.set((short)-154);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint4").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint4((long)-154L), (long)((Unsigned4BitType)cursor.next()).get());
        }
    }

    @Test
    public void testUint16ToUint4() {
        UnsignedShortType b = new UnsignedShortType(480);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint4").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint4((long)480L), (long)((Unsigned4BitType)cursor.next()).get());
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint4").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint4((long)0L), (long)((Unsigned4BitType)cursor.next()).get());
        }
    }

    @Test
    public void testInt32ToUint4() {
        IntType b = new IntType(301);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint4").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint4((long)301L), (long)((Unsigned4BitType)cursor.next()).get());
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint4").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint4((long)0L), (long)((Unsigned4BitType)cursor.next()).get());
        }
        b.set(-89);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint4").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint4((long)-89L), (long)((Unsigned4BitType)cursor.next()).get());
        }
    }

    @Test
    public void testUint32ToUint4() {
        UnsignedIntType b = new UnsignedIntType(20L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint4").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint4((long)20L), (long)((Unsigned4BitType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint4").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint4((long)0L), (long)((Unsigned4BitType)cursor.next()).get());
        }
    }

    @Test
    public void testInt64ToUint4() {
        LongType b = new LongType(891L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint4").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint4((long)891L), (long)((Unsigned4BitType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint4").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint4((long)0L), (long)((Unsigned4BitType)cursor.next()).get());
        }
        b.set(-1024L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint4").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint4((long)-1024L), (long)((Unsigned4BitType)cursor.next()).get());
        }
    }

    @Test
    public void testUint64ToUint4() {
        UnsignedLongType b = new UnsignedLongType(1049L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint4").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint4((long)1049L), (long)((Unsigned4BitType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint4").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint4((long)0L), (long)((Unsigned4BitType)cursor.next()).get());
        }
        b.set(this.p64);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint4").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint4((Number)this.p64), (long)((Unsigned4BitType)cursor.next()).get());
        }
    }

    @Test
    public void testUint128ToUint4() {
        Unsigned128BitType b = new Unsigned128BitType(this.beef);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint4").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint4((Number)this.beef), (long)((Unsigned4BitType)cursor.next()).get());
        }
        b.set(this.biZero);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint4").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint4((Number)this.biZero), (long)((Unsigned4BitType)cursor.next()).get());
        }
        b.set(this.p128);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint4").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint4((Number)this.p128), (long)((Unsigned4BitType)cursor.next()).get());
        }
    }

    @Test
    public void testFloat32ToUint4() {
        FloatType b = new FloatType(123453.125f);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint4").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint4((double)123453.125), (long)((Unsigned4BitType)cursor.next()).get());
        }
        b.set(0.0f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint4").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint4((double)0.0), (long)((Unsigned4BitType)cursor.next()).get());
        }
        b.set(-2.5234854E12f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint4").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint4((double)-2.523485437952E12), (long)((Unsigned4BitType)cursor.next()).get());
        }
    }

    @Test
    public void testCfloat32ToUint4() {
        ComplexFloatType b = new ComplexFloatType(5839.25f, 120.0f);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint4").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint4((double)5839.25), (long)((Unsigned4BitType)cursor.next()).get());
        }
        b.set(0.0f, 0.0f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint4").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint4((double)0.0), (long)((Unsigned4BitType)cursor.next()).get());
        }
        b.set(-4.25f, -123.0625f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint4").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint4((double)-4.25), (long)((Unsigned4BitType)cursor.next()).get());
        }
    }

    @Test
    public void testFloat64ToUint4() {
        DoubleType b = new DoubleType(4098.0);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint4").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint4((double)4098.0), (long)((Unsigned4BitType)cursor.next()).get());
        }
        b.set(0.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint4").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint4((double)0.0), (long)((Unsigned4BitType)cursor.next()).get());
        }
        b.set(-10948.015625);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint4").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint4((double)-10948.015625), (long)((Unsigned4BitType)cursor.next()).get());
        }
        b.set(1.0000152587890626E20);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint4").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint4((double)1.0000152587890626E20), (long)((Unsigned4BitType)cursor.next()).get());
        }
    }

    @Test
    public void testCfloat64ToUint4() {
        ComplexDoubleType b = new ComplexDoubleType(9087.0, 879542.125);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint4").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint4((double)9087.0), (long)((Unsigned4BitType)cursor.next()).get());
        }
        b.set(0.0, 0.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint4").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint4((double)0.0), (long)((Unsigned4BitType)cursor.next()).get());
        }
        b.set(-234.25, -9.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint4").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint4((double)-234.25), (long)((Unsigned4BitType)cursor.next()).get());
        }
    }

    @Test
    public void testBitToInt8() {
        BitType b = new BitType(true);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int8").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((byte)Types.int8((long)1L), (byte)((ByteType)cursor.next()).get());
        }
        b.set(false);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((byte)Types.int8((long)0L), (byte)((ByteType)cursor.next()).get());
        }
    }

    @Test
    public void testUint2ToInt8() {
        Unsigned2BitType b = new Unsigned2BitType(2L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int8").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((byte)Types.int8((long)2L), (byte)((ByteType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((byte)Types.int8((long)0L), (byte)((ByteType)cursor.next()).get());
        }
    }

    @Test
    public void testUint4ToInt8() {
        Unsigned4BitType b = new Unsigned4BitType(15L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int8").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((byte)Types.int8((long)15L), (byte)((ByteType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((byte)Types.int8((long)0L), (byte)((ByteType)cursor.next()).get());
        }
    }

    @Test
    public void testInt8ToInt8() {
        ByteType b = new ByteType(8);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int8").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((byte)Types.int8((long)8L), (byte)((ByteType)cursor.next()).get());
        }
        b.set((byte)0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((byte)Types.int8((long)0L), (byte)((ByteType)cursor.next()).get());
        }
        b.set((byte)-12);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((byte)Types.int8((long)-12L), (byte)((ByteType)cursor.next()).get());
        }
    }

    @Test
    public void testUint8ToInt8() {
        UnsignedByteType b = new UnsignedByteType(100);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int8").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((byte)Types.int8((long)100L), (byte)((ByteType)cursor.next()).get());
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((byte)Types.int8((long)0L), (byte)((ByteType)cursor.next()).get());
        }
    }

    @Test
    public void testUint12ToInt8() {
        Unsigned12BitType b = new Unsigned12BitType(212L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int8").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((byte)Types.int8((long)212L), (byte)((ByteType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((byte)Types.int8((long)0L), (byte)((ByteType)cursor.next()).get());
        }
    }

    @Test
    public void testInt16ToInt8() {
        ShortType b = new ShortType(52);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int8").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((byte)Types.int8((long)52L), (byte)((ByteType)cursor.next()).get());
        }
        b.set((short)0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((byte)Types.int8((long)0L), (byte)((ByteType)cursor.next()).get());
        }
        b.set((short)-154);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((byte)Types.int8((long)-154L), (byte)((ByteType)cursor.next()).get());
        }
    }

    @Test
    public void testUint16ToInt8() {
        UnsignedShortType b = new UnsignedShortType(480);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int8").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((byte)Types.int8((long)480L), (byte)((ByteType)cursor.next()).get());
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((byte)Types.int8((long)0L), (byte)((ByteType)cursor.next()).get());
        }
    }

    @Test
    public void testInt32ToInt8() {
        IntType b = new IntType(301);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int8").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((byte)Types.int8((long)301L), (byte)((ByteType)cursor.next()).get());
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((byte)Types.int8((long)0L), (byte)((ByteType)cursor.next()).get());
        }
        b.set(-89);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((byte)Types.int8((long)-89L), (byte)((ByteType)cursor.next()).get());
        }
    }

    @Test
    public void testUint32ToInt8() {
        UnsignedIntType b = new UnsignedIntType(20L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int8").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((byte)Types.int8((long)20L), (byte)((ByteType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((byte)Types.int8((long)0L), (byte)((ByteType)cursor.next()).get());
        }
    }

    @Test
    public void testInt64ToInt8() {
        LongType b = new LongType(891L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int8").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((byte)Types.int8((long)891L), (byte)((ByteType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((byte)Types.int8((long)0L), (byte)((ByteType)cursor.next()).get());
        }
        b.set(-1024L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((byte)Types.int8((long)-1024L), (byte)((ByteType)cursor.next()).get());
        }
    }

    @Test
    public void testUint64ToInt8() {
        UnsignedLongType b = new UnsignedLongType(1049L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int8").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((byte)Types.int8((long)1049L), (byte)((ByteType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((byte)Types.int8((long)0L), (byte)((ByteType)cursor.next()).get());
        }
        b.set(this.p64);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((byte)Types.int8((BigInteger)this.p64), (byte)((ByteType)cursor.next()).get());
        }
    }

    @Test
    public void testUint128ToInt8() {
        Unsigned128BitType b = new Unsigned128BitType(this.beef);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int8").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((byte)Types.int8((BigInteger)this.beef), (byte)((ByteType)cursor.next()).get());
        }
        b.set(this.biZero);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((byte)Types.int8((BigInteger)this.biZero), (byte)((ByteType)cursor.next()).get());
        }
        b.set(this.p128);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((byte)Types.int8((BigInteger)this.p128), (byte)((ByteType)cursor.next()).get());
        }
    }

    @Test
    public void testFloat32ToInt8() {
        FloatType b = new FloatType(123453.125f);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int8").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((byte)Types.int8((double)123453.125), (byte)((ByteType)cursor.next()).get());
        }
        b.set(0.0f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((byte)Types.int8((double)0.0), (byte)((ByteType)cursor.next()).get());
        }
        b.set(-2.5234854E12f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((byte)Types.int8((double)-2.523485437952E12), (byte)((ByteType)cursor.next()).get());
        }
    }

    @Test
    public void testCfloat32ToInt8() {
        ComplexFloatType b = new ComplexFloatType(5839.25f, 120.0f);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int8").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((byte)Types.int8((double)5839.25), (byte)((ByteType)cursor.next()).get());
        }
        b.set(0.0f, 0.0f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((byte)Types.int8((double)0.0), (byte)((ByteType)cursor.next()).get());
        }
        b.set(-4.25f, -123.0625f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((byte)Types.int8((double)-4.25), (byte)((ByteType)cursor.next()).get());
        }
    }

    @Test
    public void testFloat64ToInt8() {
        DoubleType b = new DoubleType(4098.0);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int8").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((byte)Types.int8((double)4098.0), (byte)((ByteType)cursor.next()).get());
        }
        b.set(0.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((byte)Types.int8((double)0.0), (byte)((ByteType)cursor.next()).get());
        }
        b.set(-10948.015625);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((byte)Types.int8((double)-10948.015625), (byte)((ByteType)cursor.next()).get());
        }
        b.set(1.0000152587890626E20);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((byte)Types.int8((double)1.0000152587890626E20), (byte)((ByteType)cursor.next()).get());
        }
    }

    @Test
    public void testCfloat64ToInt8() {
        ComplexDoubleType b = new ComplexDoubleType(9087.0, 879542.125);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int8").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((byte)Types.int8((double)9087.0), (byte)((ByteType)cursor.next()).get());
        }
        b.set(0.0, 0.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((byte)Types.int8((double)0.0), (byte)((ByteType)cursor.next()).get());
        }
        b.set(-234.25, -9.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((byte)Types.int8((double)-234.25), (byte)((ByteType)cursor.next()).get());
        }
    }

    @Test
    public void testBitToUint8() {
        BitType b = new BitType(true);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint8").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint8((long)1L), (int)((UnsignedByteType)cursor.next()).get());
        }
        b.set(false);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint8((long)0L), (int)((UnsignedByteType)cursor.next()).get());
        }
    }

    @Test
    public void testUint2ToUint8() {
        Unsigned2BitType b = new Unsigned2BitType(2L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint8").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint8((long)2L), (int)((UnsignedByteType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint8((long)0L), (int)((UnsignedByteType)cursor.next()).get());
        }
    }

    @Test
    public void testUint4ToUint8() {
        Unsigned4BitType b = new Unsigned4BitType(15L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint8").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint8((long)15L), (int)((UnsignedByteType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint8((long)0L), (int)((UnsignedByteType)cursor.next()).get());
        }
    }

    @Test
    public void testInt8ToUint8() {
        ByteType b = new ByteType(8);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint8").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint8((long)8L), (int)((UnsignedByteType)cursor.next()).get());
        }
        b.set((byte)0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint8((long)0L), (int)((UnsignedByteType)cursor.next()).get());
        }
        b.set((byte)-12);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint8((long)-12L), (int)((UnsignedByteType)cursor.next()).get());
        }
    }

    @Test
    public void testUint8ToUint8() {
        UnsignedByteType b = new UnsignedByteType(100);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint8").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint8((long)100L), (int)((UnsignedByteType)cursor.next()).get());
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint8((long)0L), (int)((UnsignedByteType)cursor.next()).get());
        }
    }

    @Test
    public void testUint12ToUint8() {
        Unsigned12BitType b = new Unsigned12BitType(212L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint8").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint8((long)212L), (int)((UnsignedByteType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint8((long)0L), (int)((UnsignedByteType)cursor.next()).get());
        }
    }

    @Test
    public void testInt16ToUint8() {
        ShortType b = new ShortType(52);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint8").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint8((long)52L), (int)((UnsignedByteType)cursor.next()).get());
        }
        b.set((short)0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint8((long)0L), (int)((UnsignedByteType)cursor.next()).get());
        }
        b.set((short)-154);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint8((long)-154L), (int)((UnsignedByteType)cursor.next()).get());
        }
    }

    @Test
    public void testUint16ToUint8() {
        UnsignedShortType b = new UnsignedShortType(480);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint8").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint8((long)480L), (int)((UnsignedByteType)cursor.next()).get());
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint8((long)0L), (int)((UnsignedByteType)cursor.next()).get());
        }
    }

    @Test
    public void testInt32ToUint8() {
        IntType b = new IntType(301);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint8").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint8((long)301L), (int)((UnsignedByteType)cursor.next()).get());
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint8((long)0L), (int)((UnsignedByteType)cursor.next()).get());
        }
        b.set(-89);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint8((long)-89L), (int)((UnsignedByteType)cursor.next()).get());
        }
    }

    @Test
    public void testUint32ToUint8() {
        UnsignedIntType b = new UnsignedIntType(20L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint8").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint8((long)20L), (int)((UnsignedByteType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint8((long)0L), (int)((UnsignedByteType)cursor.next()).get());
        }
    }

    @Test
    public void testInt64ToUint8() {
        LongType b = new LongType(891L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint8").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint8((long)891L), (int)((UnsignedByteType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint8((long)0L), (int)((UnsignedByteType)cursor.next()).get());
        }
        b.set(-1024L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint8((long)-1024L), (int)((UnsignedByteType)cursor.next()).get());
        }
    }

    @Test
    public void testUint64ToUint8() {
        UnsignedLongType b = new UnsignedLongType(1049L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint8").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint8((long)1049L), (int)((UnsignedByteType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint8((long)0L), (int)((UnsignedByteType)cursor.next()).get());
        }
        b.set(this.p64);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint8((Number)this.p64), (int)((UnsignedByteType)cursor.next()).get());
        }
    }

    @Test
    public void testUint128ToUint8() {
        Unsigned128BitType b = new Unsigned128BitType(this.beef);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint8").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint8((Number)this.beef), (int)((UnsignedByteType)cursor.next()).get());
        }
        b.set(this.biZero);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint8((Number)this.biZero), (int)((UnsignedByteType)cursor.next()).get());
        }
        b.set(this.p128);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint8((Number)this.p128), (int)((UnsignedByteType)cursor.next()).get());
        }
    }

    @Test
    public void testFloat32ToUint8() {
        FloatType b = new FloatType(123453.125f);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint8").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint8((double)123453.125), (int)((UnsignedByteType)cursor.next()).get());
        }
        b.set(0.0f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint8((double)0.0), (int)((UnsignedByteType)cursor.next()).get());
        }
        b.set(-2.5234854E12f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint8((double)-2.523485437952E12), (int)((UnsignedByteType)cursor.next()).get());
        }
    }

    @Test
    public void testCfloat32ToUint8() {
        ComplexFloatType b = new ComplexFloatType(5839.25f, 120.0f);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint8").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint8((double)5839.25), (int)((UnsignedByteType)cursor.next()).get());
        }
        b.set(0.0f, 0.0f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint8((double)0.0), (int)((UnsignedByteType)cursor.next()).get());
        }
        b.set(-4.25f, -123.0625f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint8((double)-4.25), (int)((UnsignedByteType)cursor.next()).get());
        }
    }

    @Test
    public void testFloat64ToUint8() {
        DoubleType b = new DoubleType(4098.0);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint8").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint8((double)4098.0), (int)((UnsignedByteType)cursor.next()).get());
        }
        b.set(0.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint8((double)0.0), (int)((UnsignedByteType)cursor.next()).get());
        }
        b.set(-10948.015625);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint8((double)-10948.015625), (int)((UnsignedByteType)cursor.next()).get());
        }
        b.set(1.0000152587890626E20);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint8((double)1.0000152587890626E20), (int)((UnsignedByteType)cursor.next()).get());
        }
    }

    @Test
    public void testCfloat64ToUint8() {
        ComplexDoubleType b = new ComplexDoubleType(9087.0, 879542.125);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint8").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint8((double)9087.0), (int)((UnsignedByteType)cursor.next()).get());
        }
        b.set(0.0, 0.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint8((double)0.0), (int)((UnsignedByteType)cursor.next()).get());
        }
        b.set(-234.25, -9.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint8").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint8((double)-234.25), (int)((UnsignedByteType)cursor.next()).get());
        }
    }

    @Test
    public void testBitToUint12() {
        BitType b = new BitType(true);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint12").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint12((long)1L), (long)((Unsigned12BitType)cursor.next()).get());
        }
        b.set(false);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint12").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint12((long)0L), (long)((Unsigned12BitType)cursor.next()).get());
        }
    }

    @Test
    public void testUint2ToUint12() {
        Unsigned2BitType b = new Unsigned2BitType(2L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint12").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint12((long)2L), (long)((Unsigned12BitType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint12").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint12((long)0L), (long)((Unsigned12BitType)cursor.next()).get());
        }
    }

    @Test
    public void testUint4ToUint12() {
        Unsigned4BitType b = new Unsigned4BitType(15L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint12").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint12((long)15L), (long)((Unsigned12BitType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint12").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint12((long)0L), (long)((Unsigned12BitType)cursor.next()).get());
        }
    }

    @Test
    public void testInt8ToUint12() {
        ByteType b = new ByteType(8);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint12").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint12((long)8L), (long)((Unsigned12BitType)cursor.next()).get());
        }
        b.set((byte)0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint12").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint12((long)0L), (long)((Unsigned12BitType)cursor.next()).get());
        }
        b.set((byte)-12);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint12").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint12((long)-12L), (long)((Unsigned12BitType)cursor.next()).get());
        }
    }

    @Test
    public void testUint8ToUint12() {
        UnsignedByteType b = new UnsignedByteType(100);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint12").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint12((long)100L), (long)((Unsigned12BitType)cursor.next()).get());
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint12").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint12((long)0L), (long)((Unsigned12BitType)cursor.next()).get());
        }
    }

    @Test
    public void testUint12ToUint12() {
        Unsigned12BitType b = new Unsigned12BitType(212L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint12").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint12((long)212L), (long)((Unsigned12BitType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint12").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint12((long)0L), (long)((Unsigned12BitType)cursor.next()).get());
        }
    }

    @Test
    public void testInt16ToUint12() {
        ShortType b = new ShortType(52);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint12").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint12((long)52L), (long)((Unsigned12BitType)cursor.next()).get());
        }
        b.set((short)0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint12").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint12((long)0L), (long)((Unsigned12BitType)cursor.next()).get());
        }
        b.set((short)-154);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint12").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint12((long)-154L), (long)((Unsigned12BitType)cursor.next()).get());
        }
    }

    @Test
    public void testUint16ToUint12() {
        UnsignedShortType b = new UnsignedShortType(480);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint12").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint12((long)480L), (long)((Unsigned12BitType)cursor.next()).get());
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint12").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint12((long)0L), (long)((Unsigned12BitType)cursor.next()).get());
        }
    }

    @Test
    public void testInt32ToUint12() {
        IntType b = new IntType(301);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint12").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint12((long)301L), (long)((Unsigned12BitType)cursor.next()).get());
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint12").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint12((long)0L), (long)((Unsigned12BitType)cursor.next()).get());
        }
        b.set(-89);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint12").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint12((long)-89L), (long)((Unsigned12BitType)cursor.next()).get());
        }
    }

    @Test
    public void testUint32ToUint12() {
        UnsignedIntType b = new UnsignedIntType(20L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint12").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint12((long)20L), (long)((Unsigned12BitType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint12").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint12((long)0L), (long)((Unsigned12BitType)cursor.next()).get());
        }
    }

    @Test
    public void testInt64ToUint12() {
        LongType b = new LongType(891L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint12").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint12((long)891L), (long)((Unsigned12BitType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint12").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint12((long)0L), (long)((Unsigned12BitType)cursor.next()).get());
        }
        b.set(-1024L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint12").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint12((long)-1024L), (long)((Unsigned12BitType)cursor.next()).get());
        }
    }

    @Test
    public void testUint64ToUint12() {
        UnsignedLongType b = new UnsignedLongType(1049L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint12").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint12((long)1049L), (long)((Unsigned12BitType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint12").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint12((long)0L), (long)((Unsigned12BitType)cursor.next()).get());
        }
        b.set(this.p64);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint12").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint12((Number)this.p64), (long)((Unsigned12BitType)cursor.next()).get());
        }
    }

    @Test
    public void testUint128ToUint12() {
        Unsigned128BitType b = new Unsigned128BitType(this.beef);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint12").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint12((Number)this.beef), (long)((Unsigned12BitType)cursor.next()).get());
        }
        b.set(this.biZero);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint12").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint12((Number)this.biZero), (long)((Unsigned12BitType)cursor.next()).get());
        }
        b.set(this.p128);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint12").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint12((Number)this.p128), (long)((Unsigned12BitType)cursor.next()).get());
        }
    }

    @Test
    public void testFloat32ToUint12() {
        FloatType b = new FloatType(123453.125f);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint12").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint12((double)123453.125), (long)((Unsigned12BitType)cursor.next()).get());
        }
        b.set(0.0f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint12").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint12((double)0.0), (long)((Unsigned12BitType)cursor.next()).get());
        }
        b.set(-2.5234854E12f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint12").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint12((double)-2.523485437952E12), (long)((Unsigned12BitType)cursor.next()).get());
        }
    }

    @Test
    public void testCfloat32ToUint12() {
        ComplexFloatType b = new ComplexFloatType(5839.25f, 120.0f);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint12").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint12((double)5839.25), (long)((Unsigned12BitType)cursor.next()).get());
        }
        b.set(0.0f, 0.0f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint12").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint12((double)0.0), (long)((Unsigned12BitType)cursor.next()).get());
        }
        b.set(-4.25f, -123.0625f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint12").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint12((double)-4.25), (long)((Unsigned12BitType)cursor.next()).get());
        }
    }

    @Test
    public void testFloat64ToUint12() {
        DoubleType b = new DoubleType(4098.0);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint12").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint12((double)4098.0), (long)((Unsigned12BitType)cursor.next()).get());
        }
        b.set(0.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint12").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint12((double)0.0), (long)((Unsigned12BitType)cursor.next()).get());
        }
        b.set(-10948.015625);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint12").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint12((double)-10948.015625), (long)((Unsigned12BitType)cursor.next()).get());
        }
        b.set(1.0000152587890626E20);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint12").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint12((double)1.0000152587890626E20), (long)((Unsigned12BitType)cursor.next()).get());
        }
    }

    @Test
    public void testCfloat64ToUint12() {
        ComplexDoubleType b = new ComplexDoubleType(9087.0, 879542.125);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint12").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint12((double)9087.0), (long)((Unsigned12BitType)cursor.next()).get());
        }
        b.set(0.0, 0.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint12").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint12((double)0.0), (long)((Unsigned12BitType)cursor.next()).get());
        }
        b.set(-234.25, -9.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint12").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint12((double)-234.25), (long)((Unsigned12BitType)cursor.next()).get());
        }
    }

    @Test
    public void testBitToInt16() {
        BitType b = new BitType(true);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int16").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((short)Types.int16((long)1L), (short)((ShortType)cursor.next()).get());
        }
        b.set(false);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((short)Types.int16((long)0L), (short)((ShortType)cursor.next()).get());
        }
    }

    @Test
    public void testUint2ToInt16() {
        Unsigned2BitType b = new Unsigned2BitType(2L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int16").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((short)Types.int16((long)2L), (short)((ShortType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((short)Types.int16((long)0L), (short)((ShortType)cursor.next()).get());
        }
    }

    @Test
    public void testUint4ToInt16() {
        Unsigned4BitType b = new Unsigned4BitType(15L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int16").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((short)Types.int16((long)15L), (short)((ShortType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((short)Types.int16((long)0L), (short)((ShortType)cursor.next()).get());
        }
    }

    @Test
    public void testInt8ToInt16() {
        ByteType b = new ByteType(8);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int16").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((short)Types.int16((long)8L), (short)((ShortType)cursor.next()).get());
        }
        b.set((byte)0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((short)Types.int16((long)0L), (short)((ShortType)cursor.next()).get());
        }
        b.set((byte)-12);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((short)Types.int16((long)-12L), (short)((ShortType)cursor.next()).get());
        }
    }

    @Test
    public void testUint8ToInt16() {
        UnsignedByteType b = new UnsignedByteType(100);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int16").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((short)Types.int16((long)100L), (short)((ShortType)cursor.next()).get());
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((short)Types.int16((long)0L), (short)((ShortType)cursor.next()).get());
        }
    }

    @Test
    public void testUint12ToInt16() {
        Unsigned12BitType b = new Unsigned12BitType(212L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int16").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((short)Types.int16((long)212L), (short)((ShortType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((short)Types.int16((long)0L), (short)((ShortType)cursor.next()).get());
        }
    }

    @Test
    public void testInt16ToInt16() {
        ShortType b = new ShortType(52);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int16").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((short)Types.int16((long)52L), (short)((ShortType)cursor.next()).get());
        }
        b.set((short)0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((short)Types.int16((long)0L), (short)((ShortType)cursor.next()).get());
        }
        b.set((short)-154);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((short)Types.int16((long)-154L), (short)((ShortType)cursor.next()).get());
        }
    }

    @Test
    public void testUint16ToInt16() {
        UnsignedShortType b = new UnsignedShortType(480);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int16").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((short)Types.int16((long)480L), (short)((ShortType)cursor.next()).get());
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((short)Types.int16((long)0L), (short)((ShortType)cursor.next()).get());
        }
    }

    @Test
    public void testInt32ToInt16() {
        IntType b = new IntType(301);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int16").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((short)Types.int16((long)301L), (short)((ShortType)cursor.next()).get());
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((short)Types.int16((long)0L), (short)((ShortType)cursor.next()).get());
        }
        b.set(-89);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((short)Types.int16((long)-89L), (short)((ShortType)cursor.next()).get());
        }
    }

    @Test
    public void testUint32ToInt16() {
        UnsignedIntType b = new UnsignedIntType(20L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int16").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((short)Types.int16((long)20L), (short)((ShortType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((short)Types.int16((long)0L), (short)((ShortType)cursor.next()).get());
        }
    }

    @Test
    public void testInt64ToInt16() {
        LongType b = new LongType(891L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int16").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((short)Types.int16((long)891L), (short)((ShortType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((short)Types.int16((long)0L), (short)((ShortType)cursor.next()).get());
        }
        b.set(-1024L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((short)Types.int16((long)-1024L), (short)((ShortType)cursor.next()).get());
        }
    }

    @Test
    public void testUint64ToInt16() {
        UnsignedLongType b = new UnsignedLongType(1049L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int16").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((short)Types.int16((long)1049L), (short)((ShortType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((short)Types.int16((long)0L), (short)((ShortType)cursor.next()).get());
        }
        b.set(this.p64);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((short)Types.int16((BigInteger)this.p64), (short)((ShortType)cursor.next()).get());
        }
    }

    @Test
    public void testUint128ToInt16() {
        Unsigned128BitType b = new Unsigned128BitType(this.beef);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int16").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((short)Types.int16((BigInteger)this.beef), (short)((ShortType)cursor.next()).get());
        }
        b.set(this.biZero);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((short)Types.int16((BigInteger)this.biZero), (short)((ShortType)cursor.next()).get());
        }
        b.set(this.p128);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((short)Types.int16((BigInteger)this.p128), (short)((ShortType)cursor.next()).get());
        }
    }

    @Test
    public void testFloat32ToInt16() {
        FloatType b = new FloatType(123453.125f);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int16").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((short)Types.int16((double)123453.125), (short)((ShortType)cursor.next()).get());
        }
        b.set(0.0f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((short)Types.int16((double)0.0), (short)((ShortType)cursor.next()).get());
        }
        b.set(-2.5234854E12f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((short)Types.int16((double)-2.523485437952E12), (short)((ShortType)cursor.next()).get());
        }
    }

    @Test
    public void testCfloat32ToInt16() {
        ComplexFloatType b = new ComplexFloatType(5839.25f, 120.0f);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int16").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((short)Types.int16((double)5839.25), (short)((ShortType)cursor.next()).get());
        }
        b.set(0.0f, 0.0f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((short)Types.int16((double)0.0), (short)((ShortType)cursor.next()).get());
        }
        b.set(-4.25f, -123.0625f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((short)Types.int16((double)-4.25), (short)((ShortType)cursor.next()).get());
        }
    }

    @Test
    public void testFloat64ToInt16() {
        DoubleType b = new DoubleType(4098.0);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int16").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((short)Types.int16((double)4098.0), (short)((ShortType)cursor.next()).get());
        }
        b.set(0.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((short)Types.int16((double)0.0), (short)((ShortType)cursor.next()).get());
        }
        b.set(-10948.015625);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((short)Types.int16((double)-10948.015625), (short)((ShortType)cursor.next()).get());
        }
        b.set(1.0000152587890626E20);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((short)Types.int16((double)1.0000152587890626E20), (short)((ShortType)cursor.next()).get());
        }
    }

    @Test
    public void testCfloat64ToInt16() {
        ComplexDoubleType b = new ComplexDoubleType(9087.0, 879542.125);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int16").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((short)Types.int16((double)9087.0), (short)((ShortType)cursor.next()).get());
        }
        b.set(0.0, 0.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((short)Types.int16((double)0.0), (short)((ShortType)cursor.next()).get());
        }
        b.set(-234.25, -9.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((short)Types.int16((double)-234.25), (short)((ShortType)cursor.next()).get());
        }
    }

    @Test
    public void testBitToUint16() {
        BitType b = new BitType(true);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint16").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint16((long)1L), (int)((UnsignedShortType)cursor.next()).get());
        }
        b.set(false);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint16((long)0L), (int)((UnsignedShortType)cursor.next()).get());
        }
    }

    @Test
    public void testUint2ToUint16() {
        Unsigned2BitType b = new Unsigned2BitType(2L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint16").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint16((long)2L), (int)((UnsignedShortType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint16((long)0L), (int)((UnsignedShortType)cursor.next()).get());
        }
    }

    @Test
    public void testUint4ToUint16() {
        Unsigned4BitType b = new Unsigned4BitType(15L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint16").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint16((long)15L), (int)((UnsignedShortType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint16((long)0L), (int)((UnsignedShortType)cursor.next()).get());
        }
    }

    @Test
    public void testInt8ToUint16() {
        ByteType b = new ByteType(8);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint16").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint16((long)8L), (int)((UnsignedShortType)cursor.next()).get());
        }
        b.set((byte)0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint16((long)0L), (int)((UnsignedShortType)cursor.next()).get());
        }
        b.set((byte)-12);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint16((long)-12L), (int)((UnsignedShortType)cursor.next()).get());
        }
    }

    @Test
    public void testUint8ToUint16() {
        UnsignedByteType b = new UnsignedByteType(100);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint16").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint16((long)100L), (int)((UnsignedShortType)cursor.next()).get());
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint16((long)0L), (int)((UnsignedShortType)cursor.next()).get());
        }
    }

    @Test
    public void testUint12ToUint16() {
        Unsigned12BitType b = new Unsigned12BitType(212L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint16").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint16((long)212L), (int)((UnsignedShortType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint16((long)0L), (int)((UnsignedShortType)cursor.next()).get());
        }
    }

    @Test
    public void testInt16ToUint16() {
        ShortType b = new ShortType(52);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint16").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint16((long)52L), (int)((UnsignedShortType)cursor.next()).get());
        }
        b.set((short)0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint16((long)0L), (int)((UnsignedShortType)cursor.next()).get());
        }
        b.set((short)-154);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint16((long)-154L), (int)((UnsignedShortType)cursor.next()).get());
        }
    }

    @Test
    public void testUint16ToUint16() {
        UnsignedShortType b = new UnsignedShortType(480);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint16").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint16((long)480L), (int)((UnsignedShortType)cursor.next()).get());
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint16((long)0L), (int)((UnsignedShortType)cursor.next()).get());
        }
    }

    @Test
    public void testInt32ToUint16() {
        IntType b = new IntType(301);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint16").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint16((long)301L), (int)((UnsignedShortType)cursor.next()).get());
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint16((long)0L), (int)((UnsignedShortType)cursor.next()).get());
        }
        b.set(-89);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint16((long)-89L), (int)((UnsignedShortType)cursor.next()).get());
        }
    }

    @Test
    public void testUint32ToUint16() {
        UnsignedIntType b = new UnsignedIntType(20L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint16").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint16((long)20L), (int)((UnsignedShortType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint16((long)0L), (int)((UnsignedShortType)cursor.next()).get());
        }
    }

    @Test
    public void testInt64ToUint16() {
        LongType b = new LongType(891L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint16").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint16((long)891L), (int)((UnsignedShortType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint16((long)0L), (int)((UnsignedShortType)cursor.next()).get());
        }
        b.set(-1024L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint16((long)-1024L), (int)((UnsignedShortType)cursor.next()).get());
        }
    }

    @Test
    public void testUint64ToUint16() {
        UnsignedLongType b = new UnsignedLongType(1049L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint16").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint16((long)1049L), (int)((UnsignedShortType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint16((long)0L), (int)((UnsignedShortType)cursor.next()).get());
        }
        b.set(this.p64);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint16((Number)this.p64), (int)((UnsignedShortType)cursor.next()).get());
        }
    }

    @Test
    public void testUint128ToUint16() {
        Unsigned128BitType b = new Unsigned128BitType(this.beef);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint16").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint16((Number)this.beef), (int)((UnsignedShortType)cursor.next()).get());
        }
        b.set(this.biZero);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint16((Number)this.biZero), (int)((UnsignedShortType)cursor.next()).get());
        }
        b.set(this.p128);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint16((Number)this.p128), (int)((UnsignedShortType)cursor.next()).get());
        }
    }

    @Test
    public void testFloat32ToUint16() {
        FloatType b = new FloatType(123453.125f);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint16").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint16((double)123453.125), (int)((UnsignedShortType)cursor.next()).get());
        }
        b.set(0.0f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint16((double)0.0), (int)((UnsignedShortType)cursor.next()).get());
        }
        b.set(-2.5234854E12f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint16((double)-2.523485437952E12), (int)((UnsignedShortType)cursor.next()).get());
        }
    }

    @Test
    public void testCfloat32ToUint16() {
        ComplexFloatType b = new ComplexFloatType(5839.25f, 120.0f);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint16").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint16((double)5839.25), (int)((UnsignedShortType)cursor.next()).get());
        }
        b.set(0.0f, 0.0f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint16((double)0.0), (int)((UnsignedShortType)cursor.next()).get());
        }
        b.set(-4.25f, -123.0625f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint16((double)-4.25), (int)((UnsignedShortType)cursor.next()).get());
        }
    }

    @Test
    public void testFloat64ToUint16() {
        DoubleType b = new DoubleType(4098.0);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint16").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint16((double)4098.0), (int)((UnsignedShortType)cursor.next()).get());
        }
        b.set(0.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint16((double)0.0), (int)((UnsignedShortType)cursor.next()).get());
        }
        b.set(-10948.015625);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint16((double)-10948.015625), (int)((UnsignedShortType)cursor.next()).get());
        }
        b.set(1.0000152587890626E20);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint16((double)1.0000152587890626E20), (int)((UnsignedShortType)cursor.next()).get());
        }
    }

    @Test
    public void testCfloat64ToUint16() {
        ComplexDoubleType b = new ComplexDoubleType(9087.0, 879542.125);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint16").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint16((double)9087.0), (int)((UnsignedShortType)cursor.next()).get());
        }
        b.set(0.0, 0.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint16((double)0.0), (int)((UnsignedShortType)cursor.next()).get());
        }
        b.set(-234.25, -9.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint16").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.uint16((double)-234.25), (int)((UnsignedShortType)cursor.next()).get());
        }
    }

    @Test
    public void testBitToInt32() {
        BitType b = new BitType(true);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.int32((long)1L), (int)((IntType)cursor.next()).get());
        }
        b.set(false);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.int32((long)0L), (int)((IntType)cursor.next()).get());
        }
    }

    @Test
    public void testUint2ToInt32() {
        Unsigned2BitType b = new Unsigned2BitType(2L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.int32((long)2L), (int)((IntType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.int32((long)0L), (int)((IntType)cursor.next()).get());
        }
    }

    @Test
    public void testUint4ToInt32() {
        Unsigned4BitType b = new Unsigned4BitType(15L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.int32((long)15L), (int)((IntType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.int32((long)0L), (int)((IntType)cursor.next()).get());
        }
    }

    @Test
    public void testInt8ToInt32() {
        ByteType b = new ByteType(8);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.int32((long)8L), (int)((IntType)cursor.next()).get());
        }
        b.set((byte)0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.int32((long)0L), (int)((IntType)cursor.next()).get());
        }
        b.set((byte)-12);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.int32((long)-12L), (int)((IntType)cursor.next()).get());
        }
    }

    @Test
    public void testUint8ToInt32() {
        UnsignedByteType b = new UnsignedByteType(100);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.int32((long)100L), (int)((IntType)cursor.next()).get());
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.int32((long)0L), (int)((IntType)cursor.next()).get());
        }
    }

    @Test
    public void testUint12ToInt32() {
        Unsigned12BitType b = new Unsigned12BitType(212L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.int32((long)212L), (int)((IntType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.int32((long)0L), (int)((IntType)cursor.next()).get());
        }
    }

    @Test
    public void testInt16ToInt32() {
        ShortType b = new ShortType(52);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.int32((long)52L), (int)((IntType)cursor.next()).get());
        }
        b.set((short)0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.int32((long)0L), (int)((IntType)cursor.next()).get());
        }
        b.set((short)-154);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.int32((long)-154L), (int)((IntType)cursor.next()).get());
        }
    }

    @Test
    public void testUint16ToInt32() {
        UnsignedShortType b = new UnsignedShortType(480);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.int32((long)480L), (int)((IntType)cursor.next()).get());
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.int32((long)0L), (int)((IntType)cursor.next()).get());
        }
    }

    @Test
    public void testInt32ToInt32() {
        IntType b = new IntType(301);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.int32((long)301L), (int)((IntType)cursor.next()).get());
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.int32((long)0L), (int)((IntType)cursor.next()).get());
        }
        b.set(-89);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.int32((long)-89L), (int)((IntType)cursor.next()).get());
        }
    }

    @Test
    public void testUint32ToInt32() {
        UnsignedIntType b = new UnsignedIntType(20L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.int32((long)20L), (int)((IntType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.int32((long)0L), (int)((IntType)cursor.next()).get());
        }
    }

    @Test
    public void testInt64ToInt32() {
        LongType b = new LongType(891L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.int32((long)891L), (int)((IntType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.int32((long)0L), (int)((IntType)cursor.next()).get());
        }
        b.set(-1024L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.int32((long)-1024L), (int)((IntType)cursor.next()).get());
        }
    }

    @Test
    public void testUint64ToInt32() {
        UnsignedLongType b = new UnsignedLongType(1049L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.int32((long)1049L), (int)((IntType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.int32((long)0L), (int)((IntType)cursor.next()).get());
        }
        b.set(this.p64);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.int32((Number)this.p64), (int)((IntType)cursor.next()).get());
        }
    }

    @Test
    public void testUint128ToInt32() {
        Unsigned128BitType b = new Unsigned128BitType(this.beef);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.int32((Number)this.beef), (int)((IntType)cursor.next()).get());
        }
        b.set(this.biZero);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.int32((Number)this.biZero), (int)((IntType)cursor.next()).get());
        }
        b.set(this.p128);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.int32((Number)this.p128), (int)((IntType)cursor.next()).get());
        }
    }

    @Test
    public void testFloat32ToInt32() {
        FloatType b = new FloatType(123453.125f);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.int32((double)123453.125), (int)((IntType)cursor.next()).get());
        }
        b.set(0.0f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.int32((double)0.0), (int)((IntType)cursor.next()).get());
        }
        b.set(-2.5234854E12f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.int32((double)-2.523485437952E12), (int)((IntType)cursor.next()).get());
        }
    }

    @Test
    public void testCfloat32ToInt32() {
        ComplexFloatType b = new ComplexFloatType(5839.25f, 120.0f);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.int32((double)5839.25), (int)((IntType)cursor.next()).get());
        }
        b.set(0.0f, 0.0f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.int32((double)0.0), (int)((IntType)cursor.next()).get());
        }
        b.set(-4.25f, -123.0625f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.int32((double)-4.25), (int)((IntType)cursor.next()).get());
        }
    }

    @Test
    public void testFloat64ToInt32() {
        DoubleType b = new DoubleType(4098.0);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.int32((double)4098.0), (int)((IntType)cursor.next()).get());
        }
        b.set(0.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.int32((double)0.0), (int)((IntType)cursor.next()).get());
        }
        b.set(-10948.015625);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.int32((double)-10948.015625), (int)((IntType)cursor.next()).get());
        }
        b.set(1.0000152587890626E20);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.int32((double)1.0000152587890626E20), (int)((IntType)cursor.next()).get());
        }
    }

    @Test
    public void testCfloat64ToInt32() {
        ComplexDoubleType b = new ComplexDoubleType(9087.0, 879542.125);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.int32((double)9087.0), (int)((IntType)cursor.next()).get());
        }
        b.set(0.0, 0.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.int32((double)0.0), (int)((IntType)cursor.next()).get());
        }
        b.set(-234.25, -9.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((int)Types.int32((double)-234.25), (int)((IntType)cursor.next()).get());
        }
    }

    @Test
    public void testBitToUint32() {
        BitType b = new BitType(true);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint32((long)1L), (long)((UnsignedIntType)cursor.next()).get());
        }
        b.set(false);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint32((long)0L), (long)((UnsignedIntType)cursor.next()).get());
        }
    }

    @Test
    public void testUint2ToUint32() {
        Unsigned2BitType b = new Unsigned2BitType(2L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint32((long)2L), (long)((UnsignedIntType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint32((long)0L), (long)((UnsignedIntType)cursor.next()).get());
        }
    }

    @Test
    public void testUint4ToUint32() {
        Unsigned4BitType b = new Unsigned4BitType(15L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint32((long)15L), (long)((UnsignedIntType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint32((long)0L), (long)((UnsignedIntType)cursor.next()).get());
        }
    }

    @Test
    public void testInt8ToUint32() {
        ByteType b = new ByteType(8);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint32((long)8L), (long)((UnsignedIntType)cursor.next()).get());
        }
        b.set((byte)0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint32((long)0L), (long)((UnsignedIntType)cursor.next()).get());
        }
        b.set((byte)-12);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint32((long)-12L), (long)((UnsignedIntType)cursor.next()).get());
        }
    }

    @Test
    public void testUint8ToUint32() {
        UnsignedByteType b = new UnsignedByteType(100);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint32((long)100L), (long)((UnsignedIntType)cursor.next()).get());
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint32((long)0L), (long)((UnsignedIntType)cursor.next()).get());
        }
    }

    @Test
    public void testUint12ToUint32() {
        Unsigned12BitType b = new Unsigned12BitType(212L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint32((long)212L), (long)((UnsignedIntType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint32((long)0L), (long)((UnsignedIntType)cursor.next()).get());
        }
    }

    @Test
    public void testInt16ToUint32() {
        ShortType b = new ShortType(52);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint32((long)52L), (long)((UnsignedIntType)cursor.next()).get());
        }
        b.set((short)0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint32((long)0L), (long)((UnsignedIntType)cursor.next()).get());
        }
        b.set((short)-154);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint32((long)-154L), (long)((UnsignedIntType)cursor.next()).get());
        }
    }

    @Test
    public void testUint16ToUint32() {
        UnsignedShortType b = new UnsignedShortType(480);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint32((long)480L), (long)((UnsignedIntType)cursor.next()).get());
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint32((long)0L), (long)((UnsignedIntType)cursor.next()).get());
        }
    }

    @Test
    public void testInt32ToUint32() {
        IntType b = new IntType(301);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint32((long)301L), (long)((UnsignedIntType)cursor.next()).get());
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint32((long)0L), (long)((UnsignedIntType)cursor.next()).get());
        }
        b.set(-89);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint32((long)-89L), (long)((UnsignedIntType)cursor.next()).get());
        }
    }

    @Test
    public void testUint32ToUint32() {
        UnsignedIntType b = new UnsignedIntType(20L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint32((long)20L), (long)((UnsignedIntType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint32((long)0L), (long)((UnsignedIntType)cursor.next()).get());
        }
    }

    @Test
    public void testInt64ToUint32() {
        LongType b = new LongType(891L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint32((long)891L), (long)((UnsignedIntType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint32((long)0L), (long)((UnsignedIntType)cursor.next()).get());
        }
        b.set(-1024L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint32((long)-1024L), (long)((UnsignedIntType)cursor.next()).get());
        }
    }

    @Test
    public void testUint64ToUint32() {
        UnsignedLongType b = new UnsignedLongType(1049L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint32((long)1049L), (long)((UnsignedIntType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint32((long)0L), (long)((UnsignedIntType)cursor.next()).get());
        }
        b.set(this.p64);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint32((Number)this.p64), (long)((UnsignedIntType)cursor.next()).get());
        }
    }

    @Test
    public void testUint128ToUint32() {
        Unsigned128BitType b = new Unsigned128BitType(this.beef);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint32((Number)this.beef), (long)((UnsignedIntType)cursor.next()).get());
        }
        b.set(this.biZero);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint32((Number)this.biZero), (long)((UnsignedIntType)cursor.next()).get());
        }
        b.set(this.p128);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint32((Number)this.p128), (long)((UnsignedIntType)cursor.next()).get());
        }
    }

    @Test
    public void testFloat32ToUint32() {
        FloatType b = new FloatType(123453.125f);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint32((double)123453.125), (long)((UnsignedIntType)cursor.next()).get());
        }
        b.set(0.0f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint32((double)0.0), (long)((UnsignedIntType)cursor.next()).get());
        }
        b.set(-2.5234854E12f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint32((double)-2.523485437952E12), (long)((UnsignedIntType)cursor.next()).get());
        }
    }

    @Test
    public void testCfloat32ToUint32() {
        ComplexFloatType b = new ComplexFloatType(5839.25f, 120.0f);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint32((double)5839.25), (long)((UnsignedIntType)cursor.next()).get());
        }
        b.set(0.0f, 0.0f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint32((double)0.0), (long)((UnsignedIntType)cursor.next()).get());
        }
        b.set(-4.25f, -123.0625f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint32((double)-4.25), (long)((UnsignedIntType)cursor.next()).get());
        }
    }

    @Test
    public void testFloat64ToUint32() {
        DoubleType b = new DoubleType(4098.0);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint32((double)4098.0), (long)((UnsignedIntType)cursor.next()).get());
        }
        b.set(0.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint32((double)0.0), (long)((UnsignedIntType)cursor.next()).get());
        }
        b.set(-10948.015625);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint32((double)-10948.015625), (long)((UnsignedIntType)cursor.next()).get());
        }
        b.set(1.0000152587890626E20);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint32((double)1.0000152587890626E20), (long)((UnsignedIntType)cursor.next()).get());
        }
    }

    @Test
    public void testCfloat64ToUint32() {
        ComplexDoubleType b = new ComplexDoubleType(9087.0, 879542.125);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint32((double)9087.0), (long)((UnsignedIntType)cursor.next()).get());
        }
        b.set(0.0, 0.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint32((double)0.0), (long)((UnsignedIntType)cursor.next()).get());
        }
        b.set(-234.25, -9.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.uint32((double)-234.25), (long)((UnsignedIntType)cursor.next()).get());
        }
    }

    @Test
    public void testBitToInt64() {
        BitType b = new BitType(true);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.int64((long)1L), (long)((LongType)cursor.next()).get());
        }
        b.set(false);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.int64((long)0L), (long)((LongType)cursor.next()).get());
        }
    }

    @Test
    public void testUint2ToInt64() {
        Unsigned2BitType b = new Unsigned2BitType(2L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.int64((long)2L), (long)((LongType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.int64((long)0L), (long)((LongType)cursor.next()).get());
        }
    }

    @Test
    public void testUint4ToInt64() {
        Unsigned4BitType b = new Unsigned4BitType(15L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.int64((long)15L), (long)((LongType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.int64((long)0L), (long)((LongType)cursor.next()).get());
        }
    }

    @Test
    public void testInt8ToInt64() {
        ByteType b = new ByteType(8);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.int64((long)8L), (long)((LongType)cursor.next()).get());
        }
        b.set((byte)0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.int64((long)0L), (long)((LongType)cursor.next()).get());
        }
        b.set((byte)-12);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.int64((long)-12L), (long)((LongType)cursor.next()).get());
        }
    }

    @Test
    public void testUint8ToInt64() {
        UnsignedByteType b = new UnsignedByteType(100);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.int64((long)100L), (long)((LongType)cursor.next()).get());
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.int64((long)0L), (long)((LongType)cursor.next()).get());
        }
    }

    @Test
    public void testUint12ToInt64() {
        Unsigned12BitType b = new Unsigned12BitType(212L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.int64((long)212L), (long)((LongType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.int64((long)0L), (long)((LongType)cursor.next()).get());
        }
    }

    @Test
    public void testInt16ToInt64() {
        ShortType b = new ShortType(52);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.int64((long)52L), (long)((LongType)cursor.next()).get());
        }
        b.set((short)0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.int64((long)0L), (long)((LongType)cursor.next()).get());
        }
        b.set((short)-154);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.int64((long)-154L), (long)((LongType)cursor.next()).get());
        }
    }

    @Test
    public void testUint16ToInt64() {
        UnsignedShortType b = new UnsignedShortType(480);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.int64((long)480L), (long)((LongType)cursor.next()).get());
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.int64((long)0L), (long)((LongType)cursor.next()).get());
        }
    }

    @Test
    public void testInt32ToInt64() {
        IntType b = new IntType(301);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.int64((long)301L), (long)((LongType)cursor.next()).get());
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.int64((long)0L), (long)((LongType)cursor.next()).get());
        }
        b.set(-89);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.int64((long)-89L), (long)((LongType)cursor.next()).get());
        }
    }

    @Test
    public void testUint32ToInt64() {
        UnsignedIntType b = new UnsignedIntType(20L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.int64((long)20L), (long)((LongType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.int64((long)0L), (long)((LongType)cursor.next()).get());
        }
    }

    @Test
    public void testInt64ToInt64() {
        LongType b = new LongType(891L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.int64((long)891L), (long)((LongType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.int64((long)0L), (long)((LongType)cursor.next()).get());
        }
        b.set(-1024L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.int64((long)-1024L), (long)((LongType)cursor.next()).get());
        }
    }

    @Test
    public void testUint64ToInt64() {
        UnsignedLongType b = new UnsignedLongType(1049L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.int64((long)1049L), (long)((LongType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.int64((long)0L), (long)((LongType)cursor.next()).get());
        }
        b.set(this.p64);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.int64((BigInteger)this.p64), (long)((LongType)cursor.next()).get());
        }
    }

    @Test
    public void testUint128ToInt64() {
        Unsigned128BitType b = new Unsigned128BitType(this.beef);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.int64((BigInteger)this.beef), (long)((LongType)cursor.next()).get());
        }
        b.set(this.biZero);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.int64((BigInteger)this.biZero), (long)((LongType)cursor.next()).get());
        }
        b.set(this.p128);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.int64((BigInteger)this.p128), (long)((LongType)cursor.next()).get());
        }
    }

    @Test
    public void testFloat32ToInt64() {
        FloatType b = new FloatType(123453.125f);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.int64((double)123453.125), (long)((LongType)cursor.next()).get());
        }
        b.set(0.0f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.int64((double)0.0), (long)((LongType)cursor.next()).get());
        }
        b.set(-2.5234854E12f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.int64((double)-2.523485437952E12), (long)((LongType)cursor.next()).get());
        }
    }

    @Test
    public void testCfloat32ToInt64() {
        ComplexFloatType b = new ComplexFloatType(5839.25f, 120.0f);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.int64((double)5839.25), (long)((LongType)cursor.next()).get());
        }
        b.set(0.0f, 0.0f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.int64((double)0.0), (long)((LongType)cursor.next()).get());
        }
        b.set(-4.25f, -123.0625f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.int64((double)-4.25), (long)((LongType)cursor.next()).get());
        }
    }

    @Test
    public void testFloat64ToInt64() {
        DoubleType b = new DoubleType(4098.0);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.int64((double)4098.0), (long)((LongType)cursor.next()).get());
        }
        b.set(0.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.int64((double)0.0), (long)((LongType)cursor.next()).get());
        }
        b.set(-10948.015625);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.int64((double)-10948.015625), (long)((LongType)cursor.next()).get());
        }
        b.set(1.0000152587890626E20);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.int64((double)1.0000152587890626E20), (long)((LongType)cursor.next()).get());
        }
    }

    @Test
    public void testCfloat64ToInt64() {
        ComplexDoubleType b = new ComplexDoubleType(9087.0, 879542.125);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.int64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.int64((double)9087.0), (long)((LongType)cursor.next()).get());
        }
        b.set(0.0, 0.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.int64((double)0.0), (long)((LongType)cursor.next()).get());
        }
        b.set(-234.25, -9.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.int64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((long)Types.int64((double)-234.25), (long)((LongType)cursor.next()).get());
        }
    }

    @Test
    public void testBitToUint64() {
        BitType b = new BitType(true);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint64((long)1L), (Object)((UnsignedLongType)cursor.next()).getBigInteger());
        }
        b.set(false);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint64((long)0L), (Object)((UnsignedLongType)cursor.next()).getBigInteger());
        }
    }

    @Test
    public void testUint2ToUint64() {
        Unsigned2BitType b = new Unsigned2BitType(2L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint64((long)2L), (Object)((UnsignedLongType)cursor.next()).getBigInteger());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint64((long)0L), (Object)((UnsignedLongType)cursor.next()).getBigInteger());
        }
    }

    @Test
    public void testUint4ToUint64() {
        Unsigned4BitType b = new Unsigned4BitType(15L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint64((long)15L), (Object)((UnsignedLongType)cursor.next()).getBigInteger());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint64((long)0L), (Object)((UnsignedLongType)cursor.next()).getBigInteger());
        }
    }

    @Test
    public void testInt8ToUint64() {
        ByteType b = new ByteType(8);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint64((long)8L), (Object)((UnsignedLongType)cursor.next()).getBigInteger());
        }
        b.set((byte)0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint64((long)0L), (Object)((UnsignedLongType)cursor.next()).getBigInteger());
        }
        b.set((byte)-12);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint64((long)-12L), (Object)((UnsignedLongType)cursor.next()).getBigInteger());
        }
    }

    @Test
    public void testUint8ToUint64() {
        UnsignedByteType b = new UnsignedByteType(100);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint64((long)100L), (Object)((UnsignedLongType)cursor.next()).getBigInteger());
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint64((long)0L), (Object)((UnsignedLongType)cursor.next()).getBigInteger());
        }
    }

    @Test
    public void testUint12ToUint64() {
        Unsigned12BitType b = new Unsigned12BitType(212L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint64((long)212L), (Object)((UnsignedLongType)cursor.next()).getBigInteger());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint64((long)0L), (Object)((UnsignedLongType)cursor.next()).getBigInteger());
        }
    }

    @Test
    public void testInt16ToUint64() {
        ShortType b = new ShortType(52);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint64((long)52L), (Object)((UnsignedLongType)cursor.next()).getBigInteger());
        }
        b.set((short)0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint64((long)0L), (Object)((UnsignedLongType)cursor.next()).getBigInteger());
        }
        b.set((short)-154);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint64((long)-154L), (Object)((UnsignedLongType)cursor.next()).getBigInteger());
        }
    }

    @Test
    public void testUint16ToUint64() {
        UnsignedShortType b = new UnsignedShortType(480);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint64((long)480L), (Object)((UnsignedLongType)cursor.next()).getBigInteger());
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint64((long)0L), (Object)((UnsignedLongType)cursor.next()).getBigInteger());
        }
    }

    @Test
    public void testInt32ToUint64() {
        IntType b = new IntType(301);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint64((long)301L), (Object)((UnsignedLongType)cursor.next()).getBigInteger());
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint64((long)0L), (Object)((UnsignedLongType)cursor.next()).getBigInteger());
        }
        b.set(-89);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint64((long)-89L), (Object)((UnsignedLongType)cursor.next()).getBigInteger());
        }
    }

    @Test
    public void testUint32ToUint64() {
        UnsignedIntType b = new UnsignedIntType(20L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint64((long)20L), (Object)((UnsignedLongType)cursor.next()).getBigInteger());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint64((long)0L), (Object)((UnsignedLongType)cursor.next()).getBigInteger());
        }
    }

    @Test
    public void testInt64ToUint64() {
        LongType b = new LongType(891L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint64((long)891L), (Object)((UnsignedLongType)cursor.next()).getBigInteger());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint64((long)0L), (Object)((UnsignedLongType)cursor.next()).getBigInteger());
        }
        b.set(-1024L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint64((long)-1024L), (Object)((UnsignedLongType)cursor.next()).getBigInteger());
        }
    }

    @Test
    public void testUint64ToUint64() {
        UnsignedLongType b = new UnsignedLongType(1049L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint64((long)1049L), (Object)((UnsignedLongType)cursor.next()).getBigInteger());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint64((long)0L), (Object)((UnsignedLongType)cursor.next()).getBigInteger());
        }
        b.set(this.p64);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint64((Number)this.p64), (Object)((UnsignedLongType)cursor.next()).getBigInteger());
        }
    }

    @Test
    public void testUint128ToUint64() {
        Unsigned128BitType b = new Unsigned128BitType(this.beef);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint64((Number)this.beef), (Object)((UnsignedLongType)cursor.next()).getBigInteger());
        }
        b.set(this.biZero);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint64((Number)this.biZero), (Object)((UnsignedLongType)cursor.next()).getBigInteger());
        }
        b.set(this.p128);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint64((Number)this.p128), (Object)((UnsignedLongType)cursor.next()).getBigInteger());
        }
    }

    @Test
    public void testFloat32ToUint64() {
        FloatType b = new FloatType(123453.125f);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint64((double)123453.125), (Object)((UnsignedLongType)cursor.next()).getBigInteger());
        }
        b.set(0.0f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint64((double)0.0), (Object)((UnsignedLongType)cursor.next()).getBigInteger());
        }
        b.set(-2.5234854E12f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint64((double)-2.523485437952E12), (Object)((UnsignedLongType)cursor.next()).getBigInteger());
        }
    }

    @Test
    public void testCfloat32ToUint64() {
        ComplexFloatType b = new ComplexFloatType(5839.25f, 120.0f);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint64((double)5839.25), (Object)((UnsignedLongType)cursor.next()).getBigInteger());
        }
        b.set(0.0f, 0.0f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint64((double)0.0), (Object)((UnsignedLongType)cursor.next()).getBigInteger());
        }
        b.set(-4.25f, -123.0625f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint64((double)-4.25), (Object)((UnsignedLongType)cursor.next()).getBigInteger());
        }
    }

    @Test
    public void testFloat64ToUint64() {
        DoubleType b = new DoubleType(4098.0);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint64((double)4098.0), (Object)((UnsignedLongType)cursor.next()).getBigInteger());
        }
        b.set(0.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint64((double)0.0), (Object)((UnsignedLongType)cursor.next()).getBigInteger());
        }
        b.set(-10948.015625);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint64((double)-10948.015625), (Object)((UnsignedLongType)cursor.next()).getBigInteger());
        }
        b.set(1.0000152587890626E20);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint64((double)1.0000152587890626E20), (Object)((UnsignedLongType)cursor.next()).getBigInteger());
        }
    }

    @Test
    public void testCfloat64ToUint64() {
        ComplexDoubleType b = new ComplexDoubleType(9087.0, 879542.125);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint64((double)9087.0), (Object)((UnsignedLongType)cursor.next()).getBigInteger());
        }
        b.set(0.0, 0.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint64((double)0.0), (Object)((UnsignedLongType)cursor.next()).getBigInteger());
        }
        b.set(-234.25, -9.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint64((double)-234.25), (Object)((UnsignedLongType)cursor.next()).getBigInteger());
        }
    }

    @Test
    public void testBitToUint128() {
        BitType b = new BitType(true);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint128").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint128((long)1L), (Object)((Unsigned128BitType)cursor.next()).get());
        }
        b.set(false);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint128").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint128((long)0L), (Object)((Unsigned128BitType)cursor.next()).get());
        }
    }

    @Test
    public void testUint2ToUint128() {
        Unsigned2BitType b = new Unsigned2BitType(2L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint128").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint128((long)2L), (Object)((Unsigned128BitType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint128").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint128((long)0L), (Object)((Unsigned128BitType)cursor.next()).get());
        }
    }

    @Test
    public void testUint4ToUint128() {
        Unsigned4BitType b = new Unsigned4BitType(15L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint128").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint128((long)15L), (Object)((Unsigned128BitType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint128").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint128((long)0L), (Object)((Unsigned128BitType)cursor.next()).get());
        }
    }

    @Test
    public void testInt8ToUint128() {
        ByteType b = new ByteType(8);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint128").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint128((long)8L), (Object)((Unsigned128BitType)cursor.next()).get());
        }
        b.set((byte)0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint128").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint128((long)0L), (Object)((Unsigned128BitType)cursor.next()).get());
        }
        b.set((byte)-12);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint128").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint128((long)-12L), (Object)((Unsigned128BitType)cursor.next()).get());
        }
    }

    @Test
    public void testUint8ToUint128() {
        UnsignedByteType b = new UnsignedByteType(100);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint128").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint128((long)100L), (Object)((Unsigned128BitType)cursor.next()).get());
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint128").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint128((long)0L), (Object)((Unsigned128BitType)cursor.next()).get());
        }
    }

    @Test
    public void testUint12ToUint128() {
        Unsigned12BitType b = new Unsigned12BitType(212L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint128").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint128((long)212L), (Object)((Unsigned128BitType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint128").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint128((long)0L), (Object)((Unsigned128BitType)cursor.next()).get());
        }
    }

    @Test
    public void testInt16ToUint128() {
        ShortType b = new ShortType(52);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint128").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint128((long)52L), (Object)((Unsigned128BitType)cursor.next()).get());
        }
        b.set((short)0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint128").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint128((long)0L), (Object)((Unsigned128BitType)cursor.next()).get());
        }
        b.set((short)-154);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint128").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint128((long)-154L), (Object)((Unsigned128BitType)cursor.next()).get());
        }
    }

    @Test
    public void testUint16ToUint128() {
        UnsignedShortType b = new UnsignedShortType(480);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint128").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint128((long)480L), (Object)((Unsigned128BitType)cursor.next()).get());
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint128").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint128((long)0L), (Object)((Unsigned128BitType)cursor.next()).get());
        }
    }

    @Test
    public void testInt32ToUint128() {
        IntType b = new IntType(301);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint128").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint128((long)301L), (Object)((Unsigned128BitType)cursor.next()).get());
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint128").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint128((long)0L), (Object)((Unsigned128BitType)cursor.next()).get());
        }
        b.set(-89);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint128").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint128((long)-89L), (Object)((Unsigned128BitType)cursor.next()).get());
        }
    }

    @Test
    public void testUint32ToUint128() {
        UnsignedIntType b = new UnsignedIntType(20L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint128").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint128((long)20L), (Object)((Unsigned128BitType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint128").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint128((long)0L), (Object)((Unsigned128BitType)cursor.next()).get());
        }
    }

    @Test
    public void testInt64ToUint128() {
        LongType b = new LongType(891L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint128").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint128((long)891L), (Object)((Unsigned128BitType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint128").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint128((long)0L), (Object)((Unsigned128BitType)cursor.next()).get());
        }
        b.set(-1024L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint128").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint128((long)-1024L), (Object)((Unsigned128BitType)cursor.next()).get());
        }
    }

    @Test
    public void testUint64ToUint128() {
        UnsignedLongType b = new UnsignedLongType(1049L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint128").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint128((long)1049L), (Object)((Unsigned128BitType)cursor.next()).get());
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint128").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint128((long)0L), (Object)((Unsigned128BitType)cursor.next()).get());
        }
        b.set(this.p64);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint128").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint64Uint128((BigInteger)this.p64), (Object)((Unsigned128BitType)cursor.next()).getBigInteger());
        }
    }

    @Test
    public void testUint128ToUint128() {
        Unsigned128BitType b = new Unsigned128BitType(this.beef);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint128").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint128((BigInteger)this.beef), (Object)((Unsigned128BitType)cursor.next()).get());
        }
        b.set(this.biZero);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint128").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint128((BigInteger)this.biZero), (Object)((Unsigned128BitType)cursor.next()).get());
        }
        b.set(this.p128);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint128").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint128((BigInteger)this.p128), (Object)((Unsigned128BitType)cursor.next()).get());
        }
    }

    @Test
    public void testFloat32ToUint128() {
        FloatType b = new FloatType(123453.125f);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint128").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint128((double)123453.125), (Object)((Unsigned128BitType)cursor.next()).get());
        }
        b.set(0.0f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint128").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint128((double)0.0), (Object)((Unsigned128BitType)cursor.next()).get());
        }
        b.set(-2.5234854E12f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint128").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint128((double)-2.523485437952E12), (Object)((Unsigned128BitType)cursor.next()).get());
        }
    }

    @Test
    public void testCfloat32ToUint128() {
        ComplexFloatType b = new ComplexFloatType(5839.25f, 120.0f);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint128").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint128((double)5839.25), (Object)((Unsigned128BitType)cursor.next()).get());
        }
        b.set(0.0f, 0.0f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint128").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint128((double)0.0), (Object)((Unsigned128BitType)cursor.next()).get());
        }
        b.set(-4.25f, -123.0625f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint128").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint128((double)-4.25), (Object)((Unsigned128BitType)cursor.next()).get());
        }
    }

    @Test
    public void testFloat64ToUint128() {
        DoubleType b = new DoubleType(4098.0);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint128").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint128((double)4098.0), (Object)((Unsigned128BitType)cursor.next()).get());
        }
        b.set(0.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint128").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint128((double)0.0), (Object)((Unsigned128BitType)cursor.next()).get());
        }
        b.set(-10948.015625);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint128").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint128((double)-10948.015625), (Object)((Unsigned128BitType)cursor.next()).get());
        }
        b.set(1.0000152587890626E20);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint128").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint128((double)1.0000152587890626E20), (Object)((Unsigned128BitType)cursor.next()).get());
        }
    }

    @Test
    public void testCfloat64ToUint128() {
        ComplexDoubleType b = new ComplexDoubleType(9087.0, 879542.125);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.uint128").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint128((double)9087.0), (Object)((Unsigned128BitType)cursor.next()).get());
        }
        b.set(0.0, 0.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint128").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint128((double)0.0), (Object)((Unsigned128BitType)cursor.next()).get());
        }
        b.set(-234.25, -9.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.uint128").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((Object)Types.uint128((double)-234.25), (Object)((Unsigned128BitType)cursor.next()).get());
        }
    }

    @Test
    public void testBitToFloat32() {
        BitType b = new BitType(true);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.float32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)1L), (float)((FloatType)cursor.next()).get(), (float)0.0f);
        }
        b.set(false);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((FloatType)cursor.next()).get(), (float)0.0f);
        }
    }

    @Test
    public void testUint2ToFloat32() {
        Unsigned2BitType b = new Unsigned2BitType(2L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.float32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)2L), (float)((FloatType)cursor.next()).get(), (float)0.0f);
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((FloatType)cursor.next()).get(), (float)0.0f);
        }
    }

    @Test
    public void testUint4ToFloat32() {
        Unsigned4BitType b = new Unsigned4BitType(15L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.float32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)15L), (float)((FloatType)cursor.next()).get(), (float)0.0f);
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((FloatType)cursor.next()).get(), (float)0.0f);
        }
    }

    @Test
    public void testInt8ToFloat32() {
        ByteType b = new ByteType(8);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.float32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)8L), (float)((FloatType)cursor.next()).get(), (float)0.0f);
        }
        b.set((byte)0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((FloatType)cursor.next()).get(), (float)0.0f);
        }
        b.set((byte)-12);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)-12L), (float)((FloatType)cursor.next()).get(), (float)0.0f);
        }
    }

    @Test
    public void testUint8ToFloat32() {
        UnsignedByteType b = new UnsignedByteType(100);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.float32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)100L), (float)((FloatType)cursor.next()).get(), (float)0.0f);
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((FloatType)cursor.next()).get(), (float)0.0f);
        }
    }

    @Test
    public void testUint12ToFloat32() {
        Unsigned12BitType b = new Unsigned12BitType(212L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.float32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)212L), (float)((FloatType)cursor.next()).get(), (float)0.0f);
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((FloatType)cursor.next()).get(), (float)0.0f);
        }
    }

    @Test
    public void testInt16ToFloat32() {
        ShortType b = new ShortType(52);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.float32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)52L), (float)((FloatType)cursor.next()).get(), (float)0.0f);
        }
        b.set((short)0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((FloatType)cursor.next()).get(), (float)0.0f);
        }
        b.set((short)-154);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)-154L), (float)((FloatType)cursor.next()).get(), (float)0.0f);
        }
    }

    @Test
    public void testUint16ToFloat32() {
        UnsignedShortType b = new UnsignedShortType(480);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.float32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)480L), (float)((FloatType)cursor.next()).get(), (float)0.0f);
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((FloatType)cursor.next()).get(), (float)0.0f);
        }
    }

    @Test
    public void testInt32ToFloat32() {
        IntType b = new IntType(301);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.float32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)301L), (float)((FloatType)cursor.next()).get(), (float)0.0f);
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((FloatType)cursor.next()).get(), (float)0.0f);
        }
        b.set(-89);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)-89L), (float)((FloatType)cursor.next()).get(), (float)0.0f);
        }
    }

    @Test
    public void testUint32ToFloat32() {
        UnsignedIntType b = new UnsignedIntType(20L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.float32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)20L), (float)((FloatType)cursor.next()).get(), (float)0.0f);
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((FloatType)cursor.next()).get(), (float)0.0f);
        }
    }

    @Test
    public void testInt64ToFloat32() {
        LongType b = new LongType(891L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.float32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)891L), (float)((FloatType)cursor.next()).get(), (float)0.0f);
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((FloatType)cursor.next()).get(), (float)0.0f);
        }
        b.set(-1024L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)-1024L), (float)((FloatType)cursor.next()).get(), (float)0.0f);
        }
    }

    @Test
    public void testUint64ToFloat32() {
        UnsignedLongType b = new UnsignedLongType(1049L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.float32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)1049L), (float)((FloatType)cursor.next()).get(), (float)0.0f);
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((FloatType)cursor.next()).get(), (float)0.0f);
        }
        b.set(this.p64);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((BigInteger)this.p64), (float)((FloatType)cursor.next()).get(), (float)0.0f);
        }
    }

    @Test
    public void testUint128ToFloat32() {
        Unsigned128BitType b = new Unsigned128BitType(this.beef);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.float32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((BigInteger)this.beef), (float)((FloatType)cursor.next()).get(), (float)0.0f);
        }
        b.set(this.biZero);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((BigInteger)this.biZero), (float)((FloatType)cursor.next()).get(), (float)0.0f);
        }
        b.set(this.p128);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((BigInteger)this.p128), (float)((FloatType)cursor.next()).get(), (float)0.0f);
        }
    }

    @Test
    public void testFloat32ToFloat32() {
        FloatType b = new FloatType(123453.125f);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.float32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((double)123453.125), (float)((FloatType)cursor.next()).get(), (float)0.0f);
        }
        b.set(0.0f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((double)0.0), (float)((FloatType)cursor.next()).get(), (float)0.0f);
        }
        b.set(-2.5234854E12f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((double)-2.523485437952E12), (float)((FloatType)cursor.next()).get(), (float)0.0f);
        }
    }

    @Test
    public void testCfloat32ToFloat32() {
        ComplexFloatType b = new ComplexFloatType(5839.25f, 120.0f);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.float32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((double)5839.25), (float)((FloatType)cursor.next()).get(), (float)0.0f);
        }
        b.set(0.0f, 0.0f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((double)0.0), (float)((FloatType)cursor.next()).get(), (float)0.0f);
        }
        b.set(-4.25f, -123.0625f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((double)-4.25), (float)((FloatType)cursor.next()).get(), (float)0.0f);
        }
    }

    @Test
    public void testFloat64ToFloat32() {
        DoubleType b = new DoubleType(4098.0);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.float32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((double)4098.0), (float)((FloatType)cursor.next()).get(), (float)0.0f);
        }
        b.set(0.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((double)0.0), (float)((FloatType)cursor.next()).get(), (float)0.0f);
        }
        b.set(-10948.015625);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((double)-10948.015625), (float)((FloatType)cursor.next()).get(), (float)0.0f);
        }
        b.set(1.0000152587890626E20);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((double)1.0000152587890626E20), (float)((FloatType)cursor.next()).get(), (float)0.0f);
        }
    }

    @Test
    public void testCfloat64ToFloat32() {
        ComplexDoubleType b = new ComplexDoubleType(9087.0, 879542.125);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.float32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((double)9087.0), (float)((FloatType)cursor.next()).get(), (float)0.0f);
        }
        b.set(0.0, 0.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((double)0.0), (float)((FloatType)cursor.next()).get(), (float)0.0f);
        }
        b.set(-234.25, -9.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((double)-234.25), (float)((FloatType)cursor.next()).get(), (float)0.0f);
        }
    }

    @Test
    public void testBitToCfloat32() {
        BitType b = new BitType(true);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.cfloat32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)1L), (float)((ComplexFloatType)cursor.next()).getRealFloat(), (float)0.0f);
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)cursor.next()).getImaginaryFloat(), (float)0.0f);
        }
        b.set(false);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)cursor.next()).getRealFloat(), (float)0.0f);
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)cursor.next()).getImaginaryFloat(), (float)0.0f);
        }
    }

    @Test
    public void testUint2ToCfloat32() {
        Unsigned2BitType b = new Unsigned2BitType(2L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.cfloat32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)2L), (float)((ComplexFloatType)cursor.next()).getRealFloat(), (float)0.0f);
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)cursor.next()).getImaginaryFloat(), (float)0.0f);
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)cursor.next()).getRealFloat(), (float)0.0f);
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)cursor.next()).getImaginaryFloat(), (float)0.0f);
        }
    }

    @Test
    public void testUint4ToCfloat32() {
        Unsigned4BitType b = new Unsigned4BitType(15L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.cfloat32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)15L), (float)((ComplexFloatType)cursor.next()).getRealFloat(), (float)0.0f);
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)cursor.next()).getImaginaryFloat(), (float)0.0f);
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)cursor.next()).getRealFloat(), (float)0.0f);
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)cursor.next()).getImaginaryFloat(), (float)0.0f);
        }
    }

    @Test
    public void testInt8ToCfloat32() {
        ByteType b = new ByteType(8);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.cfloat32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)8L), (float)((ComplexFloatType)cursor.next()).getRealFloat(), (float)0.0f);
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)cursor.next()).getImaginaryFloat(), (float)0.0f);
        }
        b.set((byte)0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)cursor.next()).getRealFloat(), (float)0.0f);
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)cursor.next()).getImaginaryFloat(), (float)0.0f);
        }
        b.set((byte)-12);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)-12L), (float)((ComplexFloatType)cursor.next()).getRealFloat(), (float)0.0f);
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)cursor.next()).getImaginaryFloat(), (float)0.0f);
        }
    }

    @Test
    public void testUint8ToCfloat32() {
        UnsignedByteType b = new UnsignedByteType(100);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.cfloat32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)100L), (float)((ComplexFloatType)cursor.next()).getRealFloat(), (float)0.0f);
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)cursor.next()).getImaginaryFloat(), (float)0.0f);
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)cursor.next()).getRealFloat(), (float)0.0f);
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)cursor.next()).getImaginaryFloat(), (float)0.0f);
        }
    }

    @Test
    public void testUint12ToCfloat32() {
        Unsigned12BitType b = new Unsigned12BitType(212L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.cfloat32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)212L), (float)((ComplexFloatType)cursor.next()).getRealFloat(), (float)0.0f);
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)cursor.next()).getImaginaryFloat(), (float)0.0f);
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)cursor.next()).getRealFloat(), (float)0.0f);
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)cursor.next()).getImaginaryFloat(), (float)0.0f);
        }
    }

    @Test
    public void testInt16ToCfloat32() {
        ShortType b = new ShortType(52);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.cfloat32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)52L), (float)((ComplexFloatType)cursor.next()).getRealFloat(), (float)0.0f);
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)cursor.next()).getImaginaryFloat(), (float)0.0f);
        }
        b.set((short)0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)cursor.next()).getRealFloat(), (float)0.0f);
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)cursor.next()).getImaginaryFloat(), (float)0.0f);
        }
        b.set((short)-154);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)-154L), (float)((ComplexFloatType)cursor.next()).getRealFloat(), (float)0.0f);
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)cursor.next()).getImaginaryFloat(), (float)0.0f);
        }
    }

    @Test
    public void testUint16ToCfloat32() {
        UnsignedShortType b = new UnsignedShortType(480);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.cfloat32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)480L), (float)((ComplexFloatType)cursor.next()).getRealFloat(), (float)0.0f);
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)cursor.next()).getImaginaryFloat(), (float)0.0f);
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)cursor.next()).getRealFloat(), (float)0.0f);
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)cursor.next()).getImaginaryFloat(), (float)0.0f);
        }
    }

    @Test
    public void testInt32ToCfloat32() {
        IntType b = new IntType(301);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.cfloat32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)301L), (float)((ComplexFloatType)cursor.next()).getRealFloat(), (float)0.0f);
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)cursor.next()).getImaginaryFloat(), (float)0.0f);
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)cursor.next()).getRealFloat(), (float)0.0f);
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)cursor.next()).getImaginaryFloat(), (float)0.0f);
        }
        b.set(-89);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)-89L), (float)((ComplexFloatType)cursor.next()).getRealFloat(), (float)0.0f);
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)cursor.next()).getImaginaryFloat(), (float)0.0f);
        }
    }

    @Test
    public void testUint32ToCfloat32() {
        UnsignedIntType b = new UnsignedIntType(20L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.cfloat32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)20L), (float)((ComplexFloatType)cursor.next()).getRealFloat(), (float)0.0f);
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)cursor.next()).getImaginaryFloat(), (float)0.0f);
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)cursor.next()).getRealFloat(), (float)0.0f);
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)cursor.next()).getImaginaryFloat(), (float)0.0f);
        }
    }

    @Test
    public void testInt64ToCfloat32() {
        LongType b = new LongType(891L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.cfloat32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)891L), (float)((ComplexFloatType)cursor.next()).getRealFloat(), (float)0.0f);
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)cursor.next()).getImaginaryFloat(), (float)0.0f);
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)cursor.next()).getRealFloat(), (float)0.0f);
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)cursor.next()).getImaginaryFloat(), (float)0.0f);
        }
        b.set(-1024L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)-1024L), (float)((ComplexFloatType)cursor.next()).getRealFloat(), (float)0.0f);
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)cursor.next()).getImaginaryFloat(), (float)0.0f);
        }
    }

    @Test
    public void testUint64ToCfloat32() {
        UnsignedLongType b = new UnsignedLongType(1049L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.cfloat32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)1049L), (float)((ComplexFloatType)cursor.next()).getRealFloat(), (float)0.0f);
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)cursor.next()).getImaginaryFloat(), (float)0.0f);
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)cursor.next()).getRealFloat(), (float)0.0f);
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)cursor.next()).getImaginaryFloat(), (float)0.0f);
        }
        b.set(this.p64);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((BigInteger)this.p64), (float)((ComplexFloatType)cursor.next()).getRealFloat(), (float)0.0f);
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)cursor.next()).getImaginaryFloat(), (float)0.0f);
        }
    }

    @Test
    public void testUint128ToCfloat32() {
        Unsigned128BitType b = new Unsigned128BitType(this.beef);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.cfloat32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((BigInteger)this.beef), (float)((ComplexFloatType)cursor.next()).getRealFloat(), (float)0.0f);
            Assertions.assertEquals((float)Types.float32((BigInteger)this.biZero), (float)((ComplexFloatType)cursor.next()).getImaginaryFloat(), (float)0.0f);
        }
        b.set(this.biZero);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((BigInteger)this.biZero), (float)((ComplexFloatType)cursor.next()).getRealFloat(), (float)0.0f);
            Assertions.assertEquals((float)Types.float32((BigInteger)this.biZero), (float)((ComplexFloatType)cursor.next()).getImaginaryFloat(), (float)0.0f);
        }
        b.set(this.p128);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((BigInteger)this.p128), (float)((ComplexFloatType)cursor.next()).getRealFloat(), (float)0.0f);
            Assertions.assertEquals((float)Types.float32((BigInteger)this.biZero), (float)((ComplexFloatType)cursor.next()).getImaginaryFloat(), (float)0.0f);
        }
    }

    @Test
    public void testFloat32ToCfloat32() {
        FloatType b = new FloatType(123453.125f);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.cfloat32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((double)123453.125), (float)((ComplexFloatType)cursor.next()).getRealFloat(), (float)0.0f);
            Assertions.assertEquals((float)Types.float32((double)0.0), (float)((ComplexFloatType)cursor.next()).getImaginaryFloat(), (float)0.0f);
        }
        b.set(0.0f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((double)0.0), (float)((ComplexFloatType)cursor.next()).getRealFloat(), (float)0.0f);
            Assertions.assertEquals((float)Types.float32((double)0.0), (float)((ComplexFloatType)cursor.next()).getImaginaryFloat(), (float)0.0f);
        }
        b.set(-2.5234854E12f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((double)-2.523485437952E12), (float)((ComplexFloatType)cursor.next()).getRealFloat(), (float)0.0f);
            Assertions.assertEquals((float)Types.float32((double)0.0), (float)((ComplexFloatType)cursor.next()).getImaginaryFloat(), (float)0.0f);
        }
    }

    @Test
    public void testCfloat32ToCfloat32() {
        ComplexFloatType b = new ComplexFloatType(5839.25f, 120.0f);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.cfloat32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((double)5839.25), (float)((ComplexFloatType)cursor.next()).getRealFloat(), (float)0.0f);
            Assertions.assertEquals((float)Types.float32((double)120.0), (float)((ComplexFloatType)cursor.next()).getImaginaryFloat(), (float)0.0f);
        }
        b.set(0.0f, 0.0f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((double)0.0), (float)((ComplexFloatType)cursor.next()).getRealFloat(), (float)0.0f);
            Assertions.assertEquals((float)Types.float32((double)0.0), (float)((ComplexFloatType)cursor.next()).getImaginaryFloat(), (float)0.0f);
        }
        b.set(-4.25f, -123.0625f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((double)-4.25), (float)((ComplexFloatType)cursor.next()).getRealFloat(), (float)0.0f);
            Assertions.assertEquals((float)Types.float32((double)-123.0625), (float)((ComplexFloatType)cursor.next()).getImaginaryFloat(), (float)0.0f);
        }
    }

    @Test
    public void testFloat64ToCfloat32() {
        DoubleType b = new DoubleType(4098.0);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.cfloat32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((double)4098.0), (float)((ComplexFloatType)cursor.next()).getRealFloat(), (float)0.0f);
            Assertions.assertEquals((float)Types.float32((double)0.0), (float)((ComplexFloatType)cursor.next()).getImaginaryFloat(), (float)0.0f);
        }
        b.set(0.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((double)0.0), (float)((ComplexFloatType)cursor.next()).getRealFloat(), (float)0.0f);
            Assertions.assertEquals((float)Types.float32((double)0.0), (float)((ComplexFloatType)cursor.next()).getImaginaryFloat(), (float)0.0f);
        }
        b.set(-10948.015625);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((double)-10948.015625), (float)((ComplexFloatType)cursor.next()).getRealFloat(), (float)0.0f);
            Assertions.assertEquals((float)Types.float32((double)0.0), (float)((ComplexFloatType)cursor.next()).getImaginaryFloat(), (float)0.0f);
        }
        b.set(1.0000152587890626E20);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((double)1.0000152587890626E20), (float)((ComplexFloatType)cursor.next()).getRealFloat(), (float)0.0f);
            Assertions.assertEquals((float)Types.float32((long)0L), (float)((ComplexFloatType)cursor.next()).getImaginaryFloat(), (float)0.0f);
        }
    }

    @Test
    public void testCfloat64ToCfloat32() {
        ComplexDoubleType b = new ComplexDoubleType(9087.0, 879542.125);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.cfloat32").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((double)9087.0), (float)((ComplexFloatType)cursor.next()).getRealFloat(), (float)0.0f);
            Assertions.assertEquals((float)Types.float32((double)879542.125), (float)((ComplexFloatType)cursor.next()).getImaginaryFloat(), (float)0.0f);
        }
        b.set(0.0, 0.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((double)0.0), (float)((ComplexFloatType)cursor.next()).getRealFloat(), (float)0.0f);
            Assertions.assertEquals((float)Types.float32((double)0.0), (float)((ComplexFloatType)cursor.next()).getImaginaryFloat(), (float)0.0f);
        }
        b.set(-234.25, -9.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat32").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((float)Types.float32((double)-234.25), (float)((ComplexFloatType)cursor.next()).getRealFloat(), (float)0.0f);
            Assertions.assertEquals((float)Types.float32((double)-9.0), (float)((ComplexFloatType)cursor.next()).getImaginaryFloat(), (float)0.0f);
        }
    }

    @Test
    public void testBitToFloat64() {
        BitType b = new BitType(true);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.float64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)1L), (double)((DoubleType)cursor.next()).get(), (double)0.0);
        }
        b.set(false);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((DoubleType)cursor.next()).get(), (double)0.0);
        }
    }

    @Test
    public void testUint2ToFloat64() {
        Unsigned2BitType b = new Unsigned2BitType(2L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.float64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)2L), (double)((DoubleType)cursor.next()).get(), (double)0.0);
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((DoubleType)cursor.next()).get(), (double)0.0);
        }
    }

    @Test
    public void testUint4ToFloat64() {
        Unsigned4BitType b = new Unsigned4BitType(15L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.float64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)15L), (double)((DoubleType)cursor.next()).get(), (double)0.0);
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((DoubleType)cursor.next()).get(), (double)0.0);
        }
    }

    @Test
    public void testInt8ToFloat64() {
        ByteType b = new ByteType(8);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.float64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)8L), (double)((DoubleType)cursor.next()).get(), (double)0.0);
        }
        b.set((byte)0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((DoubleType)cursor.next()).get(), (double)0.0);
        }
        b.set((byte)-12);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)-12L), (double)((DoubleType)cursor.next()).get(), (double)0.0);
        }
    }

    @Test
    public void testUint8ToFloat64() {
        UnsignedByteType b = new UnsignedByteType(100);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.float64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)100L), (double)((DoubleType)cursor.next()).get(), (double)0.0);
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((DoubleType)cursor.next()).get(), (double)0.0);
        }
    }

    @Test
    public void testUint12ToFloat64() {
        Unsigned12BitType b = new Unsigned12BitType(212L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.float64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)212L), (double)((DoubleType)cursor.next()).get(), (double)0.0);
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((DoubleType)cursor.next()).get(), (double)0.0);
        }
    }

    @Test
    public void testInt16ToFloat64() {
        ShortType b = new ShortType(52);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.float64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)52L), (double)((DoubleType)cursor.next()).get(), (double)0.0);
        }
        b.set((short)0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((DoubleType)cursor.next()).get(), (double)0.0);
        }
        b.set((short)-154);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)-154L), (double)((DoubleType)cursor.next()).get(), (double)0.0);
        }
    }

    @Test
    public void testUint16ToFloat64() {
        UnsignedShortType b = new UnsignedShortType(480);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.float64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)480L), (double)((DoubleType)cursor.next()).get(), (double)0.0);
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((DoubleType)cursor.next()).get(), (double)0.0);
        }
    }

    @Test
    public void testInt32ToFloat64() {
        IntType b = new IntType(301);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.float64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)301L), (double)((DoubleType)cursor.next()).get(), (double)0.0);
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((DoubleType)cursor.next()).get(), (double)0.0);
        }
        b.set(-89);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)-89L), (double)((DoubleType)cursor.next()).get(), (double)0.0);
        }
    }

    @Test
    public void testUint32ToFloat64() {
        UnsignedIntType b = new UnsignedIntType(20L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.float64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)20L), (double)((DoubleType)cursor.next()).get(), (double)0.0);
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((DoubleType)cursor.next()).get(), (double)0.0);
        }
    }

    @Test
    public void testInt64ToFloat64() {
        LongType b = new LongType(891L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.float64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)891L), (double)((DoubleType)cursor.next()).get(), (double)0.0);
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((DoubleType)cursor.next()).get(), (double)0.0);
        }
        b.set(-1024L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)-1024L), (double)((DoubleType)cursor.next()).get(), (double)0.0);
        }
    }

    @Test
    public void testUint64ToFloat64() {
        UnsignedLongType b = new UnsignedLongType(1049L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.float64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)1049L), (double)((DoubleType)cursor.next()).get(), (double)0.0);
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((DoubleType)cursor.next()).get(), (double)0.0);
        }
        b.set(this.p64);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((BigInteger)this.p64), (double)((DoubleType)cursor.next()).get(), (double)0.0);
        }
    }

    @Test
    public void testUint128ToFloat64() {
        Unsigned128BitType b = new Unsigned128BitType(this.beef);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.float64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((BigInteger)this.beef), (double)((DoubleType)cursor.next()).get(), (double)0.0);
        }
        b.set(this.biZero);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((BigInteger)this.biZero), (double)((DoubleType)cursor.next()).get(), (double)0.0);
        }
        b.set(this.p128);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((BigInteger)this.p128), (double)((DoubleType)cursor.next()).get(), (double)0.0);
        }
    }

    @Test
    public void testFloat32ToFloat64() {
        FloatType b = new FloatType(123453.125f);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.float64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((double)123453.125), (double)((DoubleType)cursor.next()).get(), (double)0.0);
        }
        b.set(0.0f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((double)0.0), (double)((DoubleType)cursor.next()).get(), (double)0.0);
        }
        b.set(-2.5234854E12f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((double)-2.523485437952E12), (double)((DoubleType)cursor.next()).get(), (double)0.0);
        }
    }

    @Test
    public void testCfloat32ToFloat64() {
        ComplexFloatType b = new ComplexFloatType(5839.25f, 120.0f);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.float64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((double)5839.25), (double)((DoubleType)cursor.next()).get(), (double)0.0);
        }
        b.set(0.0f, 0.0f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((double)0.0), (double)((DoubleType)cursor.next()).get(), (double)0.0);
        }
        b.set(-4.25f, -123.0625f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((double)-4.25), (double)((DoubleType)cursor.next()).get(), (double)0.0);
        }
    }

    @Test
    public void testFloat64ToFloat64() {
        DoubleType b = new DoubleType(4098.0);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.float64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((double)4098.0), (double)((DoubleType)cursor.next()).get(), (double)0.0);
        }
        b.set(0.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((double)0.0), (double)((DoubleType)cursor.next()).get(), (double)0.0);
        }
        b.set(-10948.015625);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((double)-10948.015625), (double)((DoubleType)cursor.next()).get(), (double)0.0);
        }
        b.set(1.0000152587890626E20);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((double)1.0000152587890626E20), (double)((DoubleType)cursor.next()).get(), (double)0.0);
        }
    }

    @Test
    public void testCfloat64ToFloat64() {
        ComplexDoubleType b = new ComplexDoubleType(9087.0, 879542.125);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.float64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((double)9087.0), (double)((DoubleType)cursor.next()).get(), (double)0.0);
        }
        b.set(0.0, 0.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((double)0.0), (double)((DoubleType)cursor.next()).get(), (double)0.0);
        }
        b.set(-234.25, -9.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.float64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((double)-234.25), (double)((DoubleType)cursor.next()).get(), (double)0.0);
        }
    }

    @Test
    public void testBitToCfloat64() {
        BitType b = new BitType(true);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.cfloat64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)1L), (double)((ComplexDoubleType)cursor.next()).getRealDouble(), (double)0.0);
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)cursor.next()).getImaginaryDouble(), (double)0.0);
        }
        b.set(false);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)cursor.next()).getRealDouble(), (double)0.0);
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)cursor.next()).getImaginaryDouble(), (double)0.0);
        }
    }

    @Test
    public void testUint2ToCfloat64() {
        Unsigned2BitType b = new Unsigned2BitType(2L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.cfloat64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)2L), (double)((ComplexDoubleType)cursor.next()).getRealDouble(), (double)0.0);
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)cursor.next()).getImaginaryDouble(), (double)0.0);
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)cursor.next()).getRealDouble(), (double)0.0);
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)cursor.next()).getImaginaryDouble(), (double)0.0);
        }
    }

    @Test
    public void testUint4ToCfloat64() {
        Unsigned4BitType b = new Unsigned4BitType(15L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.cfloat64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)15L), (double)((ComplexDoubleType)cursor.next()).getRealDouble(), (double)0.0);
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)cursor.next()).getImaginaryDouble(), (double)0.0);
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)cursor.next()).getRealDouble(), (double)0.0);
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)cursor.next()).getImaginaryDouble(), (double)0.0);
        }
    }

    @Test
    public void testInt8ToCfloat64() {
        ByteType b = new ByteType(8);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.cfloat64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)8L), (double)((ComplexDoubleType)cursor.next()).getRealDouble(), (double)0.0);
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)cursor.next()).getImaginaryDouble(), (double)0.0);
        }
        b.set((byte)0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)cursor.next()).getRealDouble(), (double)0.0);
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)cursor.next()).getImaginaryDouble(), (double)0.0);
        }
        b.set((byte)-12);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)-12L), (double)((ComplexDoubleType)cursor.next()).getRealDouble(), (double)0.0);
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)cursor.next()).getImaginaryDouble(), (double)0.0);
        }
    }

    @Test
    public void testUint8ToCfloat64() {
        UnsignedByteType b = new UnsignedByteType(100);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.cfloat64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)100L), (double)((ComplexDoubleType)cursor.next()).getRealDouble(), (double)0.0);
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)cursor.next()).getImaginaryDouble(), (double)0.0);
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)cursor.next()).getRealDouble(), (double)0.0);
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)cursor.next()).getImaginaryDouble(), (double)0.0);
        }
    }

    @Test
    public void testUint12ToCfloat64() {
        Unsigned12BitType b = new Unsigned12BitType(212L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.cfloat64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)212L), (double)((ComplexDoubleType)cursor.next()).getRealDouble(), (double)0.0);
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)cursor.next()).getImaginaryDouble(), (double)0.0);
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)cursor.next()).getRealDouble(), (double)0.0);
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)cursor.next()).getImaginaryDouble(), (double)0.0);
        }
    }

    @Test
    public void testInt16ToCfloat64() {
        ShortType b = new ShortType(52);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.cfloat64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)52L), (double)((ComplexDoubleType)cursor.next()).getRealDouble(), (double)0.0);
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)cursor.next()).getImaginaryDouble(), (double)0.0);
        }
        b.set((short)0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)cursor.next()).getRealDouble(), (double)0.0);
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)cursor.next()).getImaginaryDouble(), (double)0.0);
        }
        b.set((short)-154);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)-154L), (double)((ComplexDoubleType)cursor.next()).getRealDouble(), (double)0.0);
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)cursor.next()).getImaginaryDouble(), (double)0.0);
        }
    }

    @Test
    public void testUint16ToCfloat64() {
        UnsignedShortType b = new UnsignedShortType(480);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.cfloat64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)480L), (double)((ComplexDoubleType)cursor.next()).getRealDouble(), (double)0.0);
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)cursor.next()).getImaginaryDouble(), (double)0.0);
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)cursor.next()).getRealDouble(), (double)0.0);
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)cursor.next()).getImaginaryDouble(), (double)0.0);
        }
    }

    @Test
    public void testInt32ToCfloat64() {
        IntType b = new IntType(301);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.cfloat64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)301L), (double)((ComplexDoubleType)cursor.next()).getRealDouble(), (double)0.0);
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)cursor.next()).getImaginaryDouble(), (double)0.0);
        }
        b.set(0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)cursor.next()).getRealDouble(), (double)0.0);
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)cursor.next()).getImaginaryDouble(), (double)0.0);
        }
        b.set(-89);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)-89L), (double)((ComplexDoubleType)cursor.next()).getRealDouble(), (double)0.0);
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)cursor.next()).getImaginaryDouble(), (double)0.0);
        }
    }

    @Test
    public void testUint32ToCfloat64() {
        UnsignedIntType b = new UnsignedIntType(20L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.cfloat64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)20L), (double)((ComplexDoubleType)cursor.next()).getRealDouble(), (double)0.0);
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)cursor.next()).getImaginaryDouble(), (double)0.0);
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)cursor.next()).getRealDouble(), (double)0.0);
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)cursor.next()).getImaginaryDouble(), (double)0.0);
        }
    }

    @Test
    public void testInt64ToCfloat64() {
        LongType b = new LongType(891L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.cfloat64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)891L), (double)((ComplexDoubleType)cursor.next()).getRealDouble(), (double)0.0);
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)cursor.next()).getImaginaryDouble(), (double)0.0);
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)cursor.next()).getRealDouble(), (double)0.0);
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)cursor.next()).getImaginaryDouble(), (double)0.0);
        }
        b.set(-1024L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)-1024L), (double)((ComplexDoubleType)cursor.next()).getRealDouble(), (double)0.0);
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)cursor.next()).getImaginaryDouble(), (double)0.0);
        }
    }

    @Test
    public void testUint64ToCfloat64() {
        UnsignedLongType b = new UnsignedLongType(1049L);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.cfloat64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)1049L), (double)((ComplexDoubleType)cursor.next()).getRealDouble(), (double)0.0);
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)cursor.next()).getImaginaryDouble(), (double)0.0);
        }
        b.set(0L);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)cursor.next()).getRealDouble(), (double)0.0);
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)cursor.next()).getImaginaryDouble(), (double)0.0);
        }
        b.set(this.p64);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((BigInteger)this.p64), (double)((ComplexDoubleType)cursor.next()).getRealDouble(), (double)0.0);
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)cursor.next()).getImaginaryDouble(), (double)0.0);
        }
    }

    @Test
    public void testUint128ToCfloat64() {
        Unsigned128BitType b = new Unsigned128BitType(this.beef);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.cfloat64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((BigInteger)this.beef), (double)((ComplexDoubleType)cursor.next()).getRealDouble(), (double)0.0);
            Assertions.assertEquals((double)Types.float64((BigInteger)this.biZero), (double)((ComplexDoubleType)cursor.next()).getImaginaryDouble(), (double)0.0);
        }
        b.set(this.biZero);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((BigInteger)this.biZero), (double)((ComplexDoubleType)cursor.next()).getRealDouble(), (double)0.0);
            Assertions.assertEquals((double)Types.float64((BigInteger)this.biZero), (double)((ComplexDoubleType)cursor.next()).getImaginaryDouble(), (double)0.0);
        }
        b.set(this.p128);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((BigInteger)this.p128), (double)((ComplexDoubleType)cursor.next()).getRealDouble(), (double)0.0);
            Assertions.assertEquals((double)Types.float64((BigInteger)this.biZero), (double)((ComplexDoubleType)cursor.next()).getImaginaryDouble(), (double)0.0);
        }
    }

    @Test
    public void testFloat32ToCfloat64() {
        FloatType b = new FloatType(123453.125f);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.cfloat64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((double)123453.125), (double)((ComplexDoubleType)cursor.next()).getRealDouble(), (double)0.0);
            Assertions.assertEquals((double)Types.float64((double)0.0), (double)((ComplexDoubleType)cursor.next()).getImaginaryDouble(), (double)0.0);
        }
        b.set(0.0f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((double)0.0), (double)((ComplexDoubleType)cursor.next()).getRealDouble(), (double)0.0);
            Assertions.assertEquals((double)Types.float64((double)0.0), (double)((ComplexDoubleType)cursor.next()).getImaginaryDouble(), (double)0.0);
        }
        b.set(-2.5234854E12f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((double)-2.523485437952E12), (double)((ComplexDoubleType)cursor.next()).getRealDouble(), (double)0.0);
            Assertions.assertEquals((double)Types.float64((double)0.0), (double)((ComplexDoubleType)cursor.next()).getImaginaryDouble(), (double)0.0);
        }
    }

    @Test
    public void testCfloat32ToCfloat64() {
        ComplexFloatType b = new ComplexFloatType(5839.25f, 120.0f);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.cfloat64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((double)5839.25), (double)((ComplexDoubleType)cursor.next()).getRealDouble(), (double)0.0);
            Assertions.assertEquals((double)Types.float64((double)120.0), (double)((ComplexDoubleType)cursor.next()).getImaginaryDouble(), (double)0.0);
        }
        b.set(0.0f, 0.0f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((double)0.0), (double)((ComplexDoubleType)cursor.next()).getRealDouble(), (double)0.0);
            Assertions.assertEquals((double)Types.float64((double)0.0), (double)((ComplexDoubleType)cursor.next()).getImaginaryDouble(), (double)0.0);
        }
        b.set(-4.25f, -123.0625f);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((double)-4.25), (double)((ComplexDoubleType)cursor.next()).getRealDouble(), (double)0.0);
            Assertions.assertEquals((double)Types.float64((double)-123.0625), (double)((ComplexDoubleType)cursor.next()).getImaginaryDouble(), (double)0.0);
        }
    }

    @Test
    public void testFloat64ToCfloat64() {
        DoubleType b = new DoubleType(4098.0);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.cfloat64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((double)4098.0), (double)((ComplexDoubleType)cursor.next()).getRealDouble(), (double)0.0);
            Assertions.assertEquals((double)Types.float64((double)0.0), (double)((ComplexDoubleType)cursor.next()).getImaginaryDouble(), (double)0.0);
        }
        b.set(0.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((double)0.0), (double)((ComplexDoubleType)cursor.next()).getRealDouble(), (double)0.0);
            Assertions.assertEquals((double)Types.float64((double)0.0), (double)((ComplexDoubleType)cursor.next()).getImaginaryDouble(), (double)0.0);
        }
        b.set(-10948.015625);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((double)-10948.015625), (double)((ComplexDoubleType)cursor.next()).getRealDouble(), (double)0.0);
            Assertions.assertEquals((double)Types.float64((double)0.0), (double)((ComplexDoubleType)cursor.next()).getImaginaryDouble(), (double)0.0);
        }
        b.set(1.0000152587890626E20);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((double)1.0000152587890626E20), (double)((ComplexDoubleType)cursor.next()).getRealDouble(), (double)0.0);
            Assertions.assertEquals((double)Types.float64((long)0L), (double)((ComplexDoubleType)cursor.next()).getImaginaryDouble(), (double)0.0);
        }
    }

    @Test
    public void testCfloat64ToCfloat64() {
        ComplexDoubleType b = new ComplexDoubleType(9087.0, 879542.125);
        Object img = ops.op("create.img").input((Object)new FinalDimensions(new int[]{2, 2}), (Object)b).apply();
        ops.op("image.fill").input((Object)b).output(img).compute();
        Object converted = ops.op("convert.cfloat64").input(img).apply();
        Cursor cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((double)9087.0), (double)((ComplexDoubleType)cursor.next()).getRealDouble(), (double)0.0);
            Assertions.assertEquals((double)Types.float64((double)879542.125), (double)((ComplexDoubleType)cursor.next()).getImaginaryDouble(), (double)0.0);
        }
        b.set(0.0, 0.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((double)0.0), (double)((ComplexDoubleType)cursor.next()).getRealDouble(), (double)0.0);
            Assertions.assertEquals((double)Types.float64((double)0.0), (double)((ComplexDoubleType)cursor.next()).getImaginaryDouble(), (double)0.0);
        }
        b.set(-234.25, -9.0);
        ops.op("image.fill").input((Object)b).output(img).compute();
        converted = ops.op("convert.cfloat64").input(img).apply();
        cursor = ((IterableInterval)converted).cursor();
        while (cursor.hasNext()) {
            Assertions.assertEquals((double)Types.float64((double)-234.25), (double)((ComplexDoubleType)cursor.next()).getRealDouble(), (double)0.0);
            Assertions.assertEquals((double)Types.float64((double)-9.0), (double)((ComplexDoubleType)cursor.next()).getImaginaryDouble(), (double)0.0);
        }
    }
}

