/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.copy;

import java.util.function.Function;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.img.planar.PlanarImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.types.Nil;
import org.scijava.util.MersenneTwisterFast;

public class CopyIITest
extends AbstractOpTest {
    private Img<DoubleType> input;

    @BeforeEach
    public void createData() {
        this.input = new PlanarImgFactory((NativeType)new DoubleType()).create(new int[]{120, 100});
        MersenneTwisterFast r = new MersenneTwisterFast(System.currentTimeMillis());
        Cursor inc = this.input.cursor();
        while (inc.hasNext()) {
            ((DoubleType)inc.next()).set(r.nextDouble());
        }
    }

    @Test
    public void testCopyIINoOutput() {
        Nil<IterableInterval<DoubleType>> nil = new Nil<IterableInterval<DoubleType>>(){};
        Function op = ops.op("copy.img").inType((Nil)nil).outType((Nil)nil).function();
        IterableInterval output = (IterableInterval)op.apply(this.input);
        Cursor inc = this.input.localizingCursor();
        Cursor out = output.cursor();
        while (inc.hasNext()) {
            inc.fwd();
            out.fwd();
            Assertions.assertEquals((double)((DoubleType)inc.get()).get(), (double)((DoubleType)out.get()).get(), (double)0.0);
        }
    }

    @Test
    public void testCopyType() {
        ArrayImg inputFloat = new ArrayImgFactory((NativeType)new FloatType()).create(new int[]{120, 100});
        Img output = (Img)ops.op("copy.img").input((Object)inputFloat).outType((Nil)new Nil<Img<FloatType>>(){}).apply();
        Assertions.assertTrue((boolean)(output.firstElement() instanceof FloatType), (String)"Should be FloatType.");
    }

    @Test
    public void testCopyIIWithOutput() {
        Img output = this.input.factory().create(this.input, (Object)((DoubleType)this.input.firstElement()));
        ops.op("copy.img").input(this.input).output((Object)output).compute();
        Cursor inc = this.input.cursor();
        Cursor outc = output.cursor();
        while (inc.hasNext()) {
            Assertions.assertEquals((double)((DoubleType)inc.next()).get(), (double)((DoubleType)outc.next()).get(), (double)0.0);
        }
        ArrayImg bar = CopyIITest.foo();
    }

    private static <N extends NativeType<N>, A extends ArrayDataAccess<A>> ArrayImg<N, A> foo() {
        return null;
    }
}

