/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.copy;

import java.util.Iterator;
import net.imglib2.Cursor;
import net.imglib2.FinalDimensions;
import net.imglib2.roi.labeling.ImgLabeling;
import net.imglib2.roi.labeling.LabelingMapping;
import net.imglib2.roi.labeling.LabelingType;
import net.imglib2.type.numeric.integer.IntType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.types.Nil;

public class CopyLabelingMappingTest
extends AbstractOpTest {
    private LabelingMapping<String> input;

    @BeforeEach
    public void createData() {
        ImgLabeling imgL = (ImgLabeling)ops.op("create.imgLabeling").input((Object)new FinalDimensions(new int[]{10, 10}), (Object)new IntType()).outType((Nil)new Nil<ImgLabeling<String, IntType>>(){}).apply();
        Cursor inc = imgL.cursor();
        while (inc.hasNext()) {
            ((LabelingType)inc.next()).add((Object)(Math.random() > 0.5 ? "A" : "B"));
        }
        while (inc.hasNext()) {
            ((LabelingType)inc.next()).add((Object)(Math.random() > 0.5 ? "A" : "B"));
        }
        this.input = imgL.getMapping();
    }

    @Test
    public void testCopyLabelingWithoutOutput() {
        LabelingMapping out = (LabelingMapping)ops.op("copy.labelingMapping").input(this.input).outType((Nil)new Nil<LabelingMapping<String>>(){}).apply();
        Iterator outIt = out.getLabels().iterator();
        for (String l : this.input.getLabels()) {
            Assertions.assertEquals((Object)l, outIt.next());
        }
    }

    @Test
    public void testCopyLabelingWithOutput() {
        LabelingMapping out = (LabelingMapping)ops.op("create.labelingMapping").outType((Nil)new Nil<LabelingMapping<String>>(){}).create();
        ops.op("copy.labelingMapping").input(this.input).output((Object)out).compute();
        Iterator outIt = out.getLabels().iterator();
        for (String l : this.input.getLabels()) {
            Assertions.assertEquals((Object)l, outIt.next());
        }
    }
}

