/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.copy;

import net.imglib2.Cursor;
import net.imglib2.FinalDimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.planar.PlanarImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.scijava.function.Computers;
import org.scijava.ops.api.OpBuilder;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.types.Nil;
import org.scijava.util.MersenneTwisterFast;

public class CopyRAITest
extends AbstractOpTest {
    private Img<UnsignedByteType> input;
    Img<UnsignedByteType> input2;
    Img<UnsignedByteType> inputPlanar;
    IntervalView<UnsignedByteType> view;
    IntervalView<UnsignedByteType> viewPlanar;
    int[] size1 = new int[]{64, 64, 64};
    int[] size2 = new int[]{32, 32, 32};
    double delta = 1.0E-7;

    @BeforeEach
    public void createData() {
        this.input = new ArrayImgFactory((NativeType)new UnsignedByteType()).create(new int[]{120, 100});
        MersenneTwisterFast r = new MersenneTwisterFast(System.currentTimeMillis());
        Cursor inc = this.input.cursor();
        while (inc.hasNext()) {
            ((UnsignedByteType)inc.next()).setReal(r.nextDouble() * 255.0);
        }
        long[] start = new long[]{16L, 16L, 16L};
        long[] end = new long[]{47L, 47L, 47L};
        this.input2 = (Img)ops.op("create.img").input((Object)new FinalDimensions(this.size1), (Object)new UnsignedByteType()).outType((Nil)new Nil<Img<UnsignedByteType>>(){}).apply();
        this.inputPlanar = (Img)ops.op("create.img").input((Object)new FinalDimensions(this.size1), (Object)new UnsignedByteType(), (Object)new PlanarImgFactory((NativeType)new UnsignedByteType())).outType((Nil)new Nil<Img<UnsignedByteType>>(){}).apply();
        this.view = Views.interval(this.input2, (Interval)new FinalInterval(start, end));
        this.viewPlanar = Views.interval(this.inputPlanar, (Interval)new FinalInterval(start, end));
        Cursor cursor = this.view.cursor();
        Cursor cursorPlanar = this.viewPlanar.cursor();
        while (cursor.hasNext()) {
            cursor.fwd();
            cursorPlanar.fwd();
            ((UnsignedByteType)cursor.get()).setReal(100.0);
            ((UnsignedByteType)cursorPlanar.get()).setReal(100.0);
        }
    }

    @Test
    public void testCopyRAINoOutput() {
        RandomAccessibleInterval output = (RandomAccessibleInterval)ops.op("copy.rai").input(this.input).outType((Nil)new Nil<RandomAccessibleInterval<UnsignedByteType>>(){}).apply();
        Cursor inc = this.input.localizingCursor();
        RandomAccess outRA = output.randomAccess();
        while (inc.hasNext()) {
            inc.fwd();
            outRA.setPosition((Localizable)inc);
            Assertions.assertEquals((int)((UnsignedByteType)inc.get()).get(), (int)((UnsignedByteType)outRA.get()).get());
        }
    }

    @Test
    public void testCopyRAIWithOutput() {
        Img output = this.input.factory().create(this.input, (Object)((UnsignedByteType)this.input.firstElement()));
        ops.op("copy.rai").input(this.input).output((Object)output).compute();
        Cursor inc = this.input.cursor();
        Cursor outc = output.cursor();
        while (inc.hasNext()) {
            Assertions.assertEquals((int)((UnsignedByteType)inc.next()).get(), (int)((UnsignedByteType)outc.next()).get());
        }
    }

    @Test
    public void testCopyRAIDifferentSize() {
        Computers.Arity1 copy = OpBuilder.matchComputer((OpEnvironment)ops, (String)"copy.rai", (Nil)new Nil<IntervalView<UnsignedByteType>>(){}, (Nil)new Nil<RandomAccessibleInterval<UnsignedByteType>>(){});
        Assertions.assertNotNull((Object)copy);
        Img out = (Img)ops.op("create.img").input((Object)new FinalDimensions(this.size2), (Object)new UnsignedByteType()).outType((Nil)new Nil<Img<UnsignedByteType>>(){}).apply();
        copy.compute(this.view, (Object)out);
        DoubleType sum = new DoubleType();
        ops.op("stats.mean").input((Object)out).output((Object)sum).compute();
        Assertions.assertEquals((double)sum.getRealDouble(), (double)100.0, (double)this.delta);
        Img outFromPlanar = (Img)ops.op("create.img").input((Object)new FinalDimensions(this.size2), (Object)new UnsignedByteType()).outType((Nil)new Nil<Img<UnsignedByteType>>(){}).apply();
        copy.compute(this.viewPlanar, (Object)outFromPlanar);
        DoubleType sumFromPlanar = new DoubleType();
        ops.op("stats.mean").input((Object)outFromPlanar).output((Object)sumFromPlanar).compute();
        Assertions.assertEquals((double)sumFromPlanar.getRealDouble(), (double)100.0, (double)this.delta);
    }
}

