/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.create;

import java.util.function.BiFunction;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.complex.ComplexDoubleType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.function.Functions;
import org.scijava.ops.api.OpBuilder;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.types.Nil;

public class CreateKernelGaborTest
extends AbstractOpTest {
    @Test
    public <C extends ComplexType<C>> void testKernelGabor() {
        double sigma = 3.0;
        double[] sigmas = new double[]{6.0, 3.0};
        double[] period = new double[]{4.0, 1.0};
        Functions.Arity3 createFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"create.kernelGabor", (Nil)new Nil<double[]>(){}, (Nil)new Nil<double[]>(){}, (Nil)new Nil<C>(){}, (Nil)new Nil<RandomAccessibleInterval<C>>(){});
        BiFunction createFuncSingleSigma = OpBuilder.matchFunction((OpEnvironment)ops, (String)"create.kernelGabor", (Nil)new Nil<Double>(){}, (Nil)new Nil<double[]>(){}, (Nil)new Nil<RandomAccessibleInterval<DoubleType>>(){});
        BiFunction createFuncDouble = OpBuilder.matchFunction((OpEnvironment)ops, (String)"create.kernelGabor", (Nil)new Nil<double[]>(){}, (Nil)new Nil<double[]>(){}, (Nil)new Nil<RandomAccessibleInterval<DoubleType>>(){});
        BiFunction createFuncFloat = OpBuilder.matchFunction((OpEnvironment)ops, (String)"create.kernelGabor", (Nil)new Nil<double[]>(){}, (Nil)new Nil<double[]>(){}, (Nil)new Nil<RandomAccessibleInterval<FloatType>>(){});
        BiFunction createFuncComplexDouble = OpBuilder.matchFunction((OpEnvironment)ops, (String)"create.kernelGabor", (Nil)new Nil<double[]>(){}, (Nil)new Nil<double[]>(){}, (Nil)new Nil<RandomAccessibleInterval<ComplexDoubleType>>(){});
        RandomAccessibleInterval kernelD = (RandomAccessibleInterval)createFuncDouble.apply(sigmas, period);
        Assertions.assertEquals((long)kernelD.dimension(0), (long)37L);
        Assertions.assertEquals((long)kernelD.dimension(1), (long)19L);
        long[] position = new long[]{kernelD.dimension(0) / 2L, kernelD.dimension(1) / 2L};
        RandomAccess samplerD = kernelD.randomAccess();
        samplerD.setPosition(position);
        Assertions.assertEquals((double)1.0, (double)((DoubleType)samplerD.get()).getRealDouble(), (double)1.0E-5);
        int wasCaught = 0;
        double[] shortSigmas = new double[]{6.0};
        try {
            kernelD = (RandomAccessibleInterval)createFuncDouble.apply(shortSigmas, period);
        }
        catch (IllegalArgumentException e) {
            ++wasCaught;
        }
        try {
            kernelD = (RandomAccessibleInterval)createFuncSingleSigma.apply(-3.0, period);
        }
        catch (IllegalArgumentException e) {
            ++wasCaught;
        }
        Assertions.assertEquals((int)2, (int)wasCaught);
        RandomAccessibleInterval kernelCD = (RandomAccessibleInterval)createFuncComplexDouble.apply(sigmas, period);
        RandomAccess samplerCD = kernelCD.randomAccess();
        samplerCD.setPosition(position);
        Assertions.assertEquals((double)((DoubleType)samplerD.get()).getRealDouble(), (double)((ComplexDoubleType)samplerCD.get()).getRealDouble(), (double)1.0E-5);
        Assertions.assertEquals((double)0.0, (double)((ComplexDoubleType)samplerCD.get()).getImaginaryDouble(), (double)0.001);
        position[0] = (long)((double)position[0] + period[0]);
        position[1] = (long)((double)position[1] + period[1]);
        samplerCD.setPosition(position);
        Assertions.assertEquals((double)0.0, (double)((ComplexDoubleType)samplerCD.get()).getImaginaryDouble(), (double)0.001);
        kernelCD = (RandomAccessibleInterval)createFunc.apply((Object)sigmas, (Object)period, (Object)new ComplexDoubleType());
        samplerCD = kernelCD.randomAccess();
        samplerCD.setPosition(position);
        Assertions.assertEquals((double)0.0, (double)((ComplexDoubleType)samplerCD.get()).getImaginaryDouble(), (double)0.001);
        double[] sigmas3D = new double[]{0.0, 5.0, 0.0};
        double[] period3D = new double[]{0.0, 2.0, 0.0};
        RandomAccessibleInterval kernelF = (RandomAccessibleInterval)createFuncFloat.apply(sigmas3D, period3D);
        RandomAccess samplerF = kernelF.randomAccess();
        Assertions.assertEquals((long)3L, (long)kernelF.dimension(0));
        Assertions.assertEquals((long)3L, (long)kernelF.dimension(2));
        position = new long[]{0L, kernelF.dimension(1) / 2L, 1L};
        samplerF.setPosition(position);
        Assertions.assertEquals((float)0.0f, (float)((FloatType)samplerF.get()).getRealFloat(), (float)0.001f);
        position[0] = 1L;
        position[2] = 0L;
        samplerF.setPosition(position);
        Assertions.assertEquals((float)0.0f, (float)((FloatType)samplerF.get()).getRealFloat(), (float)0.001f);
        position[2] = 1L;
        samplerF.setPosition(position);
        Assertions.assertEquals((float)10.0f, (float)((FloatType)samplerF.get()).getRealFloat(), (float)9.99f);
    }
}

