/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.filter;

import java.util.ArrayList;
import java.util.Collections;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.neighborhood.RectangleShape;
import net.imglib2.img.Img;
import net.imglib2.outofbounds.OutOfBoundsMirrorFactory;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.util.Util;
import net.imglib2.view.Views;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.ops.image.util.TestImgGeneration;

public class NonLinearFiltersTest
extends AbstractOpTest {
    Img<ByteType> in;
    Img<ByteType> out;
    RectangleShape shape;
    OutOfBoundsMirrorFactory<ByteType, Img<ByteType>> oobFactory = new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE);

    @BeforeEach
    public void before() throws Exception {
        this.in = TestImgGeneration.byteArray(true, 10L, 10L);
        this.out = TestImgGeneration.byteArray(false, 10L, 10L);
        this.shape = new RectangleShape(1, false);
    }

    @Test
    public void testMaxFilter() {
        ops.op("filter.max").input(this.in, (Object)this.shape, this.oobFactory).output(this.out).compute();
        byte max = -128;
        RectangleShape.NeighborhoodsIterableInterval neighborhoods = this.shape.neighborhoods((RandomAccessibleInterval)Views.interval((RandomAccessible)Views.extendMirrorSingle(this.in), this.in));
        for (ByteType t : neighborhoods.firstElement()) {
            max = (byte)Math.max(t.getInteger(), max);
        }
        Assertions.assertEquals((byte)((ByteType)this.out.firstElement()).get(), (byte)max);
    }

    @Test
    public void testMaxFilterNullable() {
        ops.op("filter.max").input(this.in, (Object)this.shape).output(this.out).compute();
    }

    @Test
    public void testMeanFilter() {
        ops.op("filter.mean").input(this.in, (Object)this.shape, this.oobFactory).output(this.out).compute();
        double sum = 0.0;
        RectangleShape.NeighborhoodsIterableInterval neighborhoods = this.shape.neighborhoods((RandomAccessibleInterval)Views.interval((RandomAccessible)Views.extendMirrorSingle(this.in), this.in));
        for (ByteType t : neighborhoods.firstElement()) {
            sum += t.getRealDouble();
        }
        Assertions.assertEquals((long)Util.round((double)(sum / 9.0)), (long)((ByteType)this.out.firstElement()).get());
    }

    @Test
    public void testMeanFilterNullable() {
        ops.op("filter.mean").input(this.in, (Object)this.shape).output(this.out).compute();
    }

    @Test
    public void testMedianFilter() {
        ops.op("filter.median").input(this.in, (Object)this.shape, this.oobFactory).output(this.out).compute();
        ArrayList<ByteType> items = new ArrayList<ByteType>();
        RectangleShape.NeighborhoodsIterableInterval neighborhoods = this.shape.neighborhoods((RandomAccessibleInterval)Views.interval((RandomAccessible)Views.extendMirrorSingle(this.in), this.in));
        for (ByteType t : neighborhoods.firstElement()) {
            items.add(t.copy());
        }
        Collections.sort(items);
        Assertions.assertEquals((byte)((ByteType)items.get(5)).get(), (byte)((ByteType)this.out.firstElement()).get());
    }

    @Test
    public void testMedianFilterNullable() {
        ops.op("filter.median").input(this.in, (Object)this.shape).output(this.out).compute();
    }

    @Test
    public void testMinFilter() {
        ops.op("filter.min").input(this.in, (Object)this.shape, this.oobFactory).output(this.out).compute();
        byte min = 127;
        RectangleShape.NeighborhoodsIterableInterval neighborhoods = this.shape.neighborhoods((RandomAccessibleInterval)Views.interval((RandomAccessible)Views.extendMirrorSingle(this.in), this.in));
        for (ByteType t : neighborhoods.firstElement()) {
            min = (byte)Math.min(t.getInteger(), min);
        }
        Assertions.assertEquals((byte)min, (byte)((ByteType)this.out.firstElement()).get());
    }

    @Test
    public void testMinFilterNullable() {
        ops.op("filter.min").input(this.in, (Object)this.shape).output(this.out).compute();
    }

    @Test
    public void testSigmaFilter() {
        ops.op("filter.sigma").input(this.in, (Object)this.shape, (Object)1.0, (Object)0.0, this.oobFactory).output(this.out).compute();
    }

    @Test
    public void testSigmaFilterNullable() {
        ops.op("filter.sigma").input(this.in, (Object)this.shape, (Object)1.0, (Object)0.0).output(this.out).compute();
    }

    @Test
    public void testVarianceFilter() {
        ops.op("filter.variance").input(this.in, (Object)this.shape, this.oobFactory).output(this.out).compute();
        double sum = 0.0;
        double sumSq = 0.0;
        RectangleShape.NeighborhoodsIterableInterval neighborhoods = this.shape.neighborhoods((RandomAccessibleInterval)Views.interval((RandomAccessible)Views.extendMirrorSingle(this.in), this.in));
        for (ByteType t : neighborhoods.firstElement()) {
            sum += t.getRealDouble();
            sumSq += t.getRealDouble() * t.getRealDouble();
        }
        Assertions.assertEquals((byte)((byte)Util.round((double)((sumSq - sum * sum / 9.0) / 8.0))), (byte)((ByteType)this.out.firstElement()).get());
    }

    @Test
    public void testVarianceFilterNullable() {
        ops.op("filter.variance").input(this.in, (Object)this.shape).output(this.out).compute();
    }
}

