/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.filter.sobel;

import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Util;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.ops.image.util.TestImgGeneration;
import org.scijava.types.Nil;

public class SobelFilterTest
extends AbstractOpTest {
    @Test
    public void test() {
        ArrayImg<FloatType, FloatArray> img = TestImgGeneration.floatArray(false, 20L, 20L);
        Cursor cursorImg = img.cursor();
        int counterX = 0;
        int counterY = 0;
        while (cursorImg.hasNext()) {
            if (counterX > 8 && counterX < 12 || counterY > 8 && counterY < 12) {
                ((FloatType)cursorImg.next()).setOne();
            } else {
                ((FloatType)cursorImg.next()).setZero();
            }
            if (++counterX % 20 == 0) {
                ++counterY;
            }
            if (counterX == 20) {
                counterX = 0;
            }
            if (counterY != 20) continue;
            counterY = 0;
        }
        RandomAccessibleInterval out = (RandomAccessibleInterval)ops.op("filter.sobel").input(img).outType((Nil)new Nil<RandomAccessibleInterval<FloatType>>(){}).apply();
        RandomAccess outRA = out.randomAccess();
        outRA.setPosition(new int[]{0, 8});
        FloatType type = ((FloatType)Util.getTypeFromInterval((Interval)out)).createVariable();
        type.set(4.0f);
        Assertions.assertEquals((Object)type, (Object)outRA.get());
        type.setZero();
        outRA.setPosition(new int[]{0, 10});
        Assertions.assertEquals((Object)type, (Object)outRA.get());
        outRA.setPosition(new int[]{10, 8});
        Assertions.assertEquals((Object)type, (Object)outRA.get());
        outRA.setPosition(new int[]{10, 10});
        Assertions.assertEquals((Object)type, (Object)outRA.get());
        outRA.setPosition(new int[]{10, 12});
        type.set(0.0f);
        Assertions.assertEquals((Object)type, (Object)outRA.get());
        outRA.setPosition(new int[]{12, 10});
        Assertions.assertEquals((Object)type, (Object)outRA.get());
    }
}

