/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.filter.vesselness;

import net.imglib2.Cursor;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.Views;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;

public class FrangiVesselnessTest
extends AbstractOpTest {
    @Test
    public void testFrangiVesselness() {
        ArrayImg inputImg = ArrayImgs.doubles((long[])new long[]{8L, 8L});
        this.setVesselPosValues((Img)inputImg, (RealType)new DoubleType(1.0), (RealType)new DoubleType(0.0));
        ArrayImg expectedOutput = ArrayImgs.floats((long[])new long[]{8L, 8L});
        this.setVesselPosValues((Img)expectedOutput, (RealType)new FloatType(0.0031375182f), (RealType)new FloatType(0.0f));
        long[] dims = new long[inputImg.numDimensions()];
        inputImg.dimensions(dims);
        ArrayImg actualOutput = ArrayImgs.floats((long[])dims);
        boolean scale = true;
        double[] spacing = new double[]{1.0, 1.0};
        ops.op("filter.frangiVesselness").input((Object)inputImg, (Object)1, (Object)spacing).output((Object)actualOutput).compute();
        Cursor cursor = Views.iterable((RandomAccessibleInterval)actualOutput).localizingCursor();
        RandomAccess actualRA = actualOutput.randomAccess();
        RandomAccess expectedRA = expectedOutput.randomAccess();
        while (cursor.hasNext()) {
            cursor.fwd();
            actualRA.setPosition((Localizable)cursor);
            expectedRA.setPosition((Localizable)cursor);
            Assertions.assertEquals((float)((FloatType)expectedRA.get()).get(), (float)((FloatType)actualRA.get()).get(), (float)0.0f);
        }
    }

    private <T extends RealType<T>> void setVesselPosValues(Img<T> img, T vesselVal, T otherVal) {
        Cursor inputCursor = img.localizingCursor();
        int vesselPos = 4;
        while (inputCursor.hasNext()) {
            inputCursor.fwd();
            double[] pos = inputCursor.positionAsDoubleArray();
            ((RealType)inputCursor.get()).set(pos[1] == (double)vesselPos ? vesselVal : otherVal);
        }
    }
}

