/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.geom.geom2d;

import java.util.List;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.roi.geom.real.Polygon2D;
import net.imglib2.roi.labeling.LabelRegion;
import net.imglib2.type.numeric.real.DoubleType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractFeatureTest;
import org.scijava.ops.image.geom.GeomUtils;

public class PolygonFeatureTests
extends AbstractFeatureTest {
    private static final double EPSILON = 1.0E-11;
    private static LabelRegion<String> ROI;
    private static Polygon2D contour;

    @BeforeAll
    public static void setupBefore() {
        ROI = PolygonFeatureTests.createLabelRegion(PolygonFeatureTests.getTestImage2D(), 1.0f, 255.0f, new long[0]);
        contour = PolygonFeatureTests.getPolygon();
    }

    @Test
    public void testBoundarySizeConvexHull() {
        Assertions.assertEquals((double)272.1520849298494, (double)((DoubleType)ops.op("geom.boundarySizeConvexHull").input((Object)contour).outType(DoubleType.class).apply()).get(), (double)1.0E-11, (String)"geom.boundarySizeConvexHull");
    }

    @Test
    public void testBoundingBox() {
        List received = GeomUtils.vertices((Polygon2D)((Polygon2D)ops.op("geom.boundingBox").input((Object)contour).outType(Polygon2D.class).apply()));
        RealPoint[] expected = new RealPoint[]{new RealPoint(new float[]{1.0f, 6.0f}), new RealPoint(new float[]{1.0f, 109.0f}), new RealPoint(new float[]{78.0f, 109.0f}), new RealPoint(new float[]{78.0f, 6.0f})};
        Assertions.assertEquals((int)expected.length, (int)received.size(), (String)"Number of polygon points differs.");
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((double)expected[i].getDoublePosition(0), (double)((RealLocalizable)received.get(i)).getDoublePosition(0), (double)1.0E-11, (String)("Polygon point " + i + " differs in x-coordinate."));
            Assertions.assertEquals((double)expected[i].getDoublePosition(1), (double)((RealLocalizable)received.get(i)).getDoublePosition(1), (double)1.0E-11, (String)("Polygon point " + i + " differs in y-coordinate."));
        }
    }

    @Test
    public void testBoxivity() {
        Assertions.assertEquals((double)0.6045142846804, (double)((DoubleType)ops.op("geom.boxivity").input((Object)contour).outType(DoubleType.class).apply()).get(), (double)1.0E-11, (String)"geom.boxivity");
    }

    @Test
    public void testCircularity() {
        Assertions.assertEquals((double)0.3566312416783, (double)((DoubleType)ops.op("geom.circularity").input((Object)contour).outType(DoubleType.class).apply()).get(), (double)1.0E-11, (String)"geom.circularity");
    }

    @Test
    public void testContour() {
        Polygon2D test = (Polygon2D)ops.op("geom.contour").input(ROI, (Object)true).outType(Polygon2D.class).apply();
        List expected = GeomUtils.vertices((Polygon2D)contour);
        List received = GeomUtils.vertices((Polygon2D)test);
        Assertions.assertEquals((int)expected.size(), (int)received.size(), (String)"Number of polygon points differs.");
        for (int i = 0; i < contour.numVertices(); ++i) {
            Assertions.assertEquals((double)((RealLocalizable)expected.get(i)).getDoublePosition(0), (double)((RealLocalizable)received.get(i)).getDoublePosition(0), (double)1.0E-11, (String)("Polygon point " + i + " differs in x-coordinate."));
            Assertions.assertEquals((double)((RealLocalizable)expected.get(i)).getDoublePosition(1), (double)((RealLocalizable)received.get(i)).getDoublePosition(1), (double)1.0E-11, (String)("Polygon point " + i + " differs in y-coordinate."));
        }
    }

    @Test
    public void testConvexHull2D() {
        Polygon2D test = (Polygon2D)ops.op("geom.convexHull").input((Object)contour).outType(Polygon2D.class).apply();
        List received = GeomUtils.vertices((Polygon2D)test);
        RealPoint[] expected = new RealPoint[]{new RealPoint(new float[]{1.0f, 30.0f}), new RealPoint(new float[]{2.0f, 29.0f}), new RealPoint(new float[]{26.0f, 6.0f}), new RealPoint(new float[]{31.0f, 6.0f}), new RealPoint(new float[]{42.0f, 9.0f}), new RealPoint(new float[]{49.0f, 22.0f}), new RealPoint(new float[]{72.0f, 65.0f}), new RealPoint(new float[]{78.0f, 77.0f}), new RealPoint(new float[]{48.0f, 106.0f}), new RealPoint(new float[]{42.0f, 109.0f}), new RealPoint(new float[]{34.0f, 109.0f}), new RealPoint(new float[]{28.0f, 106.0f}), new RealPoint(new float[]{26.0f, 104.0f}), new RealPoint(new float[]{23.0f, 98.0f})};
        Assertions.assertEquals((int)expected.length, (int)received.size(), (String)"Number of polygon points differs.");
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((double)expected[i].getDoublePosition(0), (double)((RealLocalizable)received.get(i)).getDoublePosition(0), (double)1.0E-11, (String)("Polygon point " + i + " differs in x-coordinate."));
            Assertions.assertEquals((double)expected[i].getDoublePosition(1), (double)((RealLocalizable)received.get(i)).getDoublePosition(1), (double)1.0E-11, (String)("Polygon point " + i + " differs in y-coordinate."));
        }
    }

    @Test
    public void testConvexity() {
        Assertions.assertEquals((double)0.7735853919277, (double)((DoubleType)ops.op("geom.convexity").input((Object)contour).outType(DoubleType.class).apply()).get(), (double)1.0E-11, (String)"geom.convexity");
    }

    @Test
    public void testEccentricity() {
        Assertions.assertEquals((double)0.863668314823, (double)((DoubleType)ops.op("geom.eccentricity").input((Object)contour).outType(DoubleType.class).apply()).get(), (double)1.0E-11, (String)"geom.eccentricity");
    }

    @Test
    public void testElongation() {
        Assertions.assertEquals((double)0.401789429879, (double)((DoubleType)ops.op("geom.mainElongation").input((Object)contour).outType(DoubleType.class).apply()).get(), (double)1.0E-11, (String)"geom.mainElongation");
    }

    @Test
    public void testFeretsDiameterForAngle() {
        Assertions.assertEquals((double)58.5849810104945, (double)((DoubleType)ops.op("geom.feretsDiameter").input((Object)contour, (Object)153.434948822922).outType(DoubleType.class).apply()).get(), (double)1.0E-11, (String)"geom.feretsDiameter");
    }

    @Test
    public void testMajorAxis() {
        Assertions.assertEquals((double)94.1937028134837, (double)((DoubleType)ops.op("geom.majorAxis").input((Object)contour).outType(DoubleType.class).apply()).get(), (double)1.0E-11, (String)"geom.majorAxis");
    }

    @Test
    public void testMaximumFeretsAngle() {
        Assertions.assertEquals((double)81.170255332091, (double)((DoubleType)ops.op("geom.maximumFeretsAngle").input((Object)contour).outType(DoubleType.class).apply()).get(), (double)1.0E-11, (String)"geom.maximumFeretsAngle");
    }

    @Test
    public void testMinimumFeretsDiameter() {
        Assertions.assertEquals((double)58.5849810104945, (double)((DoubleType)ops.op("geom.minimumFeretsDiameter").input((Object)contour).outType(DoubleType.class).apply()).get(), (double)1.0E-11, (String)"geom.minimumFeretsDiameter");
    }

    @Test
    public void testMinimumFeretsAngle() {
        Assertions.assertEquals((double)153.434948822922, (double)((DoubleType)ops.op("geom.minimumFeretsAngle").input((Object)contour).outType(DoubleType.class).apply()).get(), (double)1.0E-11, (String)"geom.minimumFeretAngle");
    }

    @Test
    public void testMaximumFeretsDiameter() {
        Assertions.assertEquals((double)104.2353107157071, (double)((DoubleType)ops.op("geom.maximumFeretsDiameter").input((Object)contour).outType(DoubleType.class).apply()).get(), (double)1.0E-11, (String)"geom.maximumFeretsDiameter");
    }

    @Test
    public void testMinorAxis() {
        Assertions.assertEquals((double)47.4793300114545, (double)((DoubleType)ops.op("geom.minorAxis").input((Object)contour).outType(DoubleType.class).apply()).get(), (double)1.0E-11, (String)"geom.minorAxis");
    }

    @Test
    public void testPerimeterLength() {
        Assertions.assertEquals((double)351.8061325481604, (double)((DoubleType)ops.op("geom.boundarySize").input((Object)contour).outType(DoubleType.class).apply()).get(), (double)1.0E-11, (String)"geom.boundarySize");
    }

    @Test
    public void testRoundness() {
        Assertions.assertEquals((double)0.504060553872, (double)((DoubleType)ops.op("geom.roundness").input((Object)contour).outType(DoubleType.class).apply()).get(), (double)1.0E-11, (String)"roundness");
    }

    @Test
    public void testSize() {
        Assertions.assertEquals((double)3512.5, (double)((DoubleType)ops.op("geom.size").input((Object)contour).outType(DoubleType.class).apply()).get(), (double)1.0E-11, (String)"geom.size");
    }

    @Test
    public void testSmallesEnclosingRectangle() {
        List received = GeomUtils.vertices((Polygon2D)((Polygon2D)ops.op("geom.smallestEnclosingBoundingBox").input((Object)contour).outType(Polygon2D.class).apply()));
        RealPoint[] expected = new RealPoint[]{new RealPoint(new double[]{37.229184188393, -0.006307821699}), new RealPoint(new double[]{-14.757779646762, 27.800672834315}), new RealPoint(new double[]{31.725820016821, 114.704793944491}), new RealPoint(new double[]{83.712783851976, 86.897813288478})};
        Assertions.assertEquals((int)expected.length, (int)received.size(), (String)"Number of polygon points differs.");
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((double)expected[i].getDoublePosition(0), (double)((RealLocalizable)received.get(i)).getDoublePosition(0), (double)1.0E-11, (String)("Polygon point " + i + " differs in x-coordinate."));
            Assertions.assertEquals((double)expected[i].getDoublePosition(1), (double)((RealLocalizable)received.get(i)).getDoublePosition(1), (double)1.0E-11, (String)("Polygon point " + i + " differs in y-coordinate."));
        }
    }

    @Test
    public void testSizeConvexHullPolygon() {
        Assertions.assertEquals((double)4731.0, (double)((DoubleType)ops.op("geom.sizeConvexHull").input((Object)contour).outType(DoubleType.class).apply()).get(), (double)1.0E-11, (String)"geom.sizeConvexHull");
    }

    @Test
    public void testSolidity2D() {
        Assertions.assertEquals((double)0.742443458043, (double)((DoubleType)ops.op("geom.solidity").input((Object)contour).outType(DoubleType.class).apply()).get(), (double)1.0E-11, (String)"geom.solidity");
    }

    @Test
    public void testVerticesCountConvexHull() {
        Assertions.assertEquals((double)14.0, (double)((DoubleType)ops.op("geom.verticesCountConvexHull").input((Object)contour).outType(DoubleType.class).apply()).get(), (double)1.0E-11, (String)"geom.verticesCountConvexHull");
    }

    @Test
    public void testVerticesCount() {
        Assertions.assertEquals((double)305.0, (double)((DoubleType)ops.op("geom.verticesCount").input((Object)contour).outType(DoubleType.class).apply()).get(), (double)1.0E-11, (String)"geom.verticesCount");
    }

    @Test
    public void testCentroid() {
        RealPoint expected = new RealPoint(new double[]{38.144483985765, 59.404175563464});
        RealPoint result = (RealPoint)ops.op("geom.centroid").input((Object)contour).apply();
        Assertions.assertEquals((double)expected.getDoublePosition(0), (double)result.getDoublePosition(0), (double)1.0E-11, (String)"Centroid X");
        Assertions.assertEquals((double)expected.getDoublePosition(1), (double)result.getDoublePosition(1), (double)1.0E-11, (String)"Centroid Y");
    }
}

