/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.geom.geom3d;

import java.util.Iterator;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.mesh.Mesh;
import net.imglib2.mesh.Triangle;
import net.imglib2.roi.labeling.LabelRegion;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.real.DoubleType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.scijava.ops.api.OpMatchingException;
import org.scijava.ops.image.AbstractFeatureTest;
import org.scijava.types.Nil;

public class MeshFeatureTests
extends AbstractFeatureTest {
    private static final double EPSILON = 1.0E-11;
    private static LabelRegion<String> ROI;
    private static Mesh mesh;

    @BeforeAll
    public static void setupBefore() {
        ROI = MeshFeatureTests.createLabelRegion(MeshFeatureTests.getTestImage3D(), 1.0f, 255.0f, new long[0]);
        mesh = MeshFeatureTests.getMesh();
    }

    @Test
    public void testBoxivityMesh() {
        Assertions.assertThrows(OpMatchingException.class, () -> ops.op("geom.boxivity").input((Object)mesh).outType(DoubleType.class).apply());
    }

    @Test
    public void testCompactness() {
        Assertions.assertEquals((double)0.572416357359835, (double)((DoubleType)ops.op("geom.compactness").input((Object)mesh).outType(DoubleType.class).apply()).get(), (double)1.0E-11, (String)"geom.compactness");
    }

    @Test
    public void testConvexHull3D() {
    }

    @Test
    public void testConvexityMesh() {
        Assertions.assertEquals((double)0.983930494866521, (double)((DoubleType)ops.op("geom.convexity").input((Object)mesh).outType(DoubleType.class).apply()).get(), (double)1.0E-11, (String)"geom.convexity");
    }

    @Test
    public void testMainElongation() {
        Assertions.assertEquals((double)0.2079585956045953, (double)((DoubleType)ops.op("geom.mainElongation").input((Object)mesh).outType(DoubleType.class).apply()).get(), (double)1.0E-11, (String)"geom.mainElongation");
    }

    @Test
    public void testMarchingCubes() {
        Mesh result = (Mesh)ops.op("geom.marchingCubes").input(ROI).apply();
        Assertions.assertEquals((int)mesh.triangles().size(), (int)result.triangles().size());
        Iterator expectedFacets = mesh.triangles().iterator();
        Iterator actualFacets = result.triangles().iterator();
        while (expectedFacets.hasNext() && actualFacets.hasNext()) {
            Triangle expected = (Triangle)expectedFacets.next();
            Triangle actual = (Triangle)actualFacets.next();
            Assertions.assertEquals((double)expected.v0x(), (double)actual.v0x(), (double)1.0E-11);
            Assertions.assertEquals((double)expected.v0y(), (double)actual.v0y(), (double)1.0E-11);
            Assertions.assertEquals((double)expected.v0z(), (double)actual.v0z(), (double)1.0E-11);
            Assertions.assertEquals((double)expected.v1x(), (double)actual.v1x(), (double)1.0E-11);
            Assertions.assertEquals((double)expected.v1y(), (double)actual.v1y(), (double)1.0E-11);
            Assertions.assertEquals((double)expected.v1z(), (double)actual.v1z(), (double)1.0E-11);
            Assertions.assertEquals((double)expected.v2x(), (double)actual.v2x(), (double)1.0E-11);
            Assertions.assertEquals((double)expected.v2y(), (double)actual.v2y(), (double)1.0E-11);
            Assertions.assertEquals((double)expected.v2z(), (double)actual.v2z(), (double)1.0E-11);
        }
        Assertions.assertTrue((!expectedFacets.hasNext() && !actualFacets.hasNext() ? 1 : 0) != 0);
    }

    @Test
    public void testMedianElongation() {
        Assertions.assertEquals((double)0.30059118825775455, (double)((DoubleType)ops.op("geom.medianElongation").input((Object)mesh).outType(DoubleType.class).apply()).get(), (double)1.0E-11, (String)"geom.medianElongation");
    }

    @Test
    public void testSizeConvexHullMesh() {
        Assertions.assertEquals((double)304.5, (double)((DoubleType)ops.op("geom.sizeConvexHull").input((Object)mesh).outType(DoubleType.class).apply()).get(), (double)1.0E-11, (String)"geom.sizeConvexHull");
    }

    @Test
    public void testSizeMesh() {
        Assertions.assertEquals((double)257.5, (double)((DoubleType)ops.op("geom.size").input((Object)mesh).outType(DoubleType.class).apply()).get(), (double)1.0E-11, (String)"geom.size");
    }

    @Test
    public void testSolidityMesh() {
        Assertions.assertEquals((double)0.845648604269294, (double)((DoubleType)ops.op("geom.solidity").input((Object)mesh).outType(DoubleType.class).apply()).get(), (double)1.0E-11, (String)"geom.solidity");
    }

    @Test
    public void testSpareness() {
        Assertions.assertEquals((double)0.7884710437076516, (double)((DoubleType)ops.op("geom.spareness").input((Object)mesh).outType(DoubleType.class).apply()).get(), (double)1.0E-11, (String)"geom.spareness");
    }

    @Test
    public void testSphericity() {
        Assertions.assertEquals((double)0.830304411183464, (double)((DoubleType)ops.op("geom.sphericity").input((Object)mesh).outType(DoubleType.class).apply()).get(), (double)1.0E-11, (String)"geom.sphericity");
    }

    @Test
    public void testSurfaceArea() {
        Assertions.assertEquals((double)235.7390893402464, (double)((DoubleType)ops.op("geom.boundarySize").input((Object)mesh).outType(DoubleType.class).apply()).get(), (double)1.0E-11, (String)"geom.boundarySize");
    }

    @Test
    public void testSurfaceAreaConvexHull() {
        Assertions.assertEquals((double)231.9508788339317, (double)((DoubleType)ops.op("geom.boundarySizeConvexHull").input((Object)mesh).outType(DoubleType.class).apply()).get(), (double)1.0E-11, (String)"geom.boundarySizeConvexHull");
    }

    @Test
    public void testVerticesCountConvexHullMesh() {
        Assertions.assertEquals((double)57.0, (double)((DoubleType)ops.op("geom.verticesCountConvexHull").input((Object)mesh).outType(DoubleType.class).apply()).get(), (double)1.0E-11, (String)"geom.verticesCountConvexHull");
    }

    @Test
    public void testVerticesCountMesh() {
        Assertions.assertEquals((double)184.0, (double)((DoubleType)ops.op("geom.verticesCount").input((Object)mesh).outType(DoubleType.class).apply()).get(), (double)1.0E-11, (String)"geom.verticesCount");
    }

    @Test
    public void testVoxelization3D() {
        ops.op("geom.voxelization").input((Object)mesh, (Object)10, (Object)10, (Object)10).outType((Nil)new Nil<RandomAccessibleInterval<BitType>>(){}).apply();
    }
}

