/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.image.integral;

import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.view.Views;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.scijava.function.Computers;
import org.scijava.ops.api.OpBuilder;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.ops.image.util.TestImgGeneration;
import org.scijava.types.Nil;

public class IntegralImgTest
extends AbstractOpTest {
    Img<ByteType> in;
    RandomAccessibleInterval<DoubleType> out1;
    RandomAccessibleInterval<DoubleType> out2;

    @BeforeEach
    public void before() throws Exception {
        this.in = TestImgGeneration.byteArray(true, 10L, 10L);
        this.out1 = TestImgGeneration.doubleArray(true, 10L, 10L);
    }

    @Test
    public void testIntegralImageSimilarity() {
        Computers.Arity1 defaultOp = OpBuilder.matchComputer((OpEnvironment)ops, (String)"image.integral", (Nil)new Nil<RandomAccessibleInterval<ByteType>>(){}, (Nil)new Nil<RandomAccessibleInterval<DoubleType>>(){});
        defaultOp.compute(this.in, this.out1);
        this.out2 = (RandomAccessibleInterval)ops.op("image.integral").input(this.in).outType((Nil)new Nil<RandomAccessibleInterval<DoubleType>>(){}).apply();
        long[] min = new long[this.out2.numDimensions()];
        long[] max = new long[this.out2.numDimensions()];
        for (int d = 0; d < this.out2.numDimensions(); ++d) {
            min[d] = this.out2.min(d) + 1L;
            max[d] = this.out2.max(d);
        }
        FinalInterval interval = new FinalInterval(min, max);
        IntegralImgTest.testIterableIntervalSimilarity(Views.iterable(this.out1), Views.iterable((RandomAccessibleInterval)Views.offsetInterval(this.out2, (Interval)interval)));
    }

    public ArrayImg<ByteType, ByteArray> generateKnownByteArrayTestImgLarge() {
        long[] dims = new long[]{3L, 3L};
        byte[] array = new byte[]{40, 40, 20, 40, 40, 20, 20, 20, 100};
        return ArrayImgs.bytes((byte[])array, (long[])dims);
    }

    public static <T extends RealType<T>, S extends RealType<S>> void testIterableIntervalSimilarity(IterableInterval<T> ii1, IterableInterval<S> ii2) {
        Cursor cursor1 = ii1.localizingCursor();
        Cursor cursor2 = ii2.cursor();
        while (cursor1.hasNext() && cursor2.hasNext()) {
            RealType value1 = (RealType)cursor1.next();
            RealType value2 = (RealType)cursor2.next();
            Assertions.assertEquals((double)value1.getRealDouble(), (double)value2.getRealDouble(), (double)1.0E-5);
        }
    }
}

