/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.image.integral;

import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.view.Views;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.ops.image.image.integral.IntegralImgTest;
import org.scijava.ops.image.util.TestImgGeneration;

public class SquareIntegralImgTest
extends AbstractOpTest {
    RandomAccessibleInterval<DoubleType> out;

    @BeforeEach
    public void before() throws Exception {
        this.out = TestImgGeneration.doubleArray(true, 3L, 3L);
    }

    @Test
    public void testSquareIntegralImageCorrectness() {
        ops.op("image.squareIntegral").input(this.generateKnownByteArrayTestImg()).output(this.out).compute();
        Img<ByteType> bytes = this.generateKnownSquareIntegralImage();
        IntegralImgTest.testIterableIntervalSimilarity(Views.iterable(bytes), Views.iterable(this.out));
    }

    private Img<ByteType> generateKnownSquareIntegralImage() {
        long[] dims = new long[]{3L, 3L};
        byte[] array = new byte[]{16, 32, 36, 32, 64, 72, 36, 72, 116};
        ArrayImg bytes = ArrayImgs.bytes((byte[])array, (long[])dims);
        return bytes;
    }

    public ArrayImg<ByteType, ByteArray> generateKnownByteArrayTestImg() {
        long[] dims = new long[]{3L, 3L};
        byte[] array = new byte[]{4, 4, 2, 4, 4, 2, 2, 2, 6};
        return ArrayImgs.bytes((byte[])array, (long[])dims);
    }
}

