/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.image.invert;

import java.math.BigInteger;
import net.imglib2.Cursor;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.img.basictypeaccess.array.DoubleArray;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.img.basictypeaccess.array.IntArray;
import net.imglib2.img.basictypeaccess.array.LongArray;
import net.imglib2.img.basictypeaccess.array.ShortArray;
import net.imglib2.img.list.ListImg;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.Unsigned128BitType;
import net.imglib2.type.numeric.integer.Unsigned12BitType;
import net.imglib2.type.numeric.integer.Unsigned2BitType;
import net.imglib2.type.numeric.integer.Unsigned4BitType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedLongType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.integer.UnsignedVariableBitLengthType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.ops.image.image.invert.Inverters;
import org.scijava.ops.image.util.TestImgGeneration;
import org.scijava.ops.image.util.UnboundedIntegerType;

public class InvertTest
extends AbstractOpTest {
    @Test
    public void testBitTypeInvert() {
        ArrayImg<BitType, LongArray> inBitType = TestImgGeneration.bitArray(true, 10L, 10L);
        Img outBitType = inBitType.factory().create(inBitType, (Object)new BitType());
        this.assertDefaultInvert((Img)inBitType, (Img)outBitType);
        this.assertDefaultInvertMinMaxProvided((Img)inBitType, (Img)outBitType, (RealType)new BitType(false), (RealType)new BitType(true));
        this.assertDefaultInvertMinMaxProvided((Img)inBitType, (Img)outBitType, (RealType)new BitType(false), (RealType)new BitType(false));
    }

    @Test
    public void testByteTypeInvert() {
        ArrayImg<ByteType, ByteArray> inByteType = TestImgGeneration.byteArray(true, 5L, 5L);
        Img outByteType = inByteType.factory().create(inByteType, (Object)new ByteType());
        this.assertDefaultInvert((Img)inByteType, (Img)outByteType);
        this.assertDefaultInvertMinMaxProvided((Img)inByteType, (Img)outByteType, (RealType)new ByteType(0), (RealType)new ByteType(0));
        this.assertDefaultInvertMinMaxProvided((Img)inByteType, (Img)outByteType, (RealType)new ByteType(20), (RealType)new ByteType(10));
        this.assertDefaultInvertMinMaxProvided((Img)inByteType, (Img)outByteType, (RealType)new ByteType(0), (RealType)new ByteType(0));
    }

    @Test
    public void testUnsigned2BitTypeInvert() {
        ArrayImg<Unsigned2BitType, LongArray> inUnsigned2BitType = TestImgGeneration.unsigned2BitArray(true, 5L, 5L);
        Img outUnsigned2BitType = inUnsigned2BitType.factory().create(inUnsigned2BitType, (Object)new Unsigned2BitType());
        this.assertDefaultInvert((Img)inUnsigned2BitType, (Img)outUnsigned2BitType);
        this.assertDefaultInvertMinMaxProvided((Img)inUnsigned2BitType, (Img)outUnsigned2BitType, (RealType)new Unsigned2BitType(2L), (RealType)new Unsigned2BitType(3L));
    }

    @Test
    public void testUnsigned4BitTypeInvert() {
        ArrayImg<Unsigned4BitType, LongArray> inUnsigned4BitType = TestImgGeneration.unsigned4BitArray(true, 5L, 5L);
        Img outUnsigned4BitType = inUnsigned4BitType.factory().create(inUnsigned4BitType, (Object)new Unsigned4BitType());
        this.assertDefaultInvert((Img)inUnsigned4BitType, (Img)outUnsigned4BitType);
        this.assertDefaultInvertMinMaxProvided((Img)inUnsigned4BitType, (Img)outUnsigned4BitType, (RealType)new Unsigned4BitType(14L), (RealType)new Unsigned4BitType(15L));
    }

    @Test
    public void testUnsigned12BitTypeInvert() {
        ArrayImg<Unsigned12BitType, LongArray> inUnsigned12BitType = TestImgGeneration.unsigned12BitArray(true, 5L, 5L);
        Img outUnsigned12BitType = inUnsigned12BitType.factory().create(inUnsigned12BitType, (Object)new Unsigned12BitType());
        this.assertDefaultInvert((Img)inUnsigned12BitType, (Img)outUnsigned12BitType);
        this.assertDefaultInvertMinMaxProvided((Img)inUnsigned12BitType, (Img)outUnsigned12BitType, (RealType)new Unsigned12BitType(3025L), (RealType)new Unsigned12BitType(3846L));
    }

    @Test
    public void testUnsignedByteTypeInvert() {
        ArrayImg<UnsignedByteType, ByteArray> inUnsignedByteType = TestImgGeneration.unsignedByteArray(true, 5L, 5L);
        Img outUnsignedByteType = inUnsignedByteType.factory().create(inUnsignedByteType, (Object)new UnsignedByteType());
        this.assertDefaultInvert((Img)inUnsignedByteType, (Img)outUnsignedByteType);
        this.assertDefaultInvertMinMaxProvided((Img)inUnsignedByteType, (Img)outUnsignedByteType, (RealType)new UnsignedByteType(127), (RealType)new UnsignedByteType(127));
        this.assertDefaultInvertMinMaxProvided((Img)inUnsignedByteType, (Img)outUnsignedByteType, (RealType)new UnsignedByteType(-12), (RealType)new UnsignedByteType(-10));
    }

    @Test
    public void testDoubleTypeInvert() {
        ArrayImg<DoubleType, DoubleArray> inDoubleType = TestImgGeneration.doubleArray(true, 5L, 5L);
        Img outDoubleType = inDoubleType.factory().create(inDoubleType, (Object)new DoubleType());
        this.assertDefaultInvert((Img)inDoubleType, (Img)outDoubleType);
        this.assertDefaultInvertMinMaxProvided((Img)inDoubleType, (Img)outDoubleType, (RealType)new DoubleType(437.0), (RealType)new DoubleType(8008.0));
        this.assertDefaultInvertMinMaxProvided((Img)inDoubleType, (Img)outDoubleType, (RealType)new DoubleType(5.0), (RealType)new DoubleType(Double.MAX_VALUE));
    }

    @Test
    public void testDoubleTypeCustomInvert() {
        ArrayImg<DoubleType, DoubleArray> inDoubleType = TestImgGeneration.doubleArray(true, 5L, 5L);
        Img outDoubleType = inDoubleType.factory().create(inDoubleType, (Object)new DoubleType());
        double[] nums = new double[]{Double.MAX_VALUE, Double.MIN_VALUE, 1.0, -1.0, 0.0, Double.MAX_VALUE, -1.7976931348623157E308, Math.PI, Math.E, Math.sqrt(Math.PI), Math.pow(25.0, 25.0), 2.0, 3.0, 5.0, 8.0, 13.0, 21.0, 34.0, 55.0, 89.0, 144.0, Double.NaN, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
        Cursor c = inDoubleType.localizingCursor();
        for (double i : nums) {
            c.next();
            ((DoubleType)c.get()).set(i);
        }
        this.assertDefaultInvert((Img)inDoubleType, (Img)outDoubleType);
        this.assertDefaultInvertMinMaxProvided((Img)inDoubleType, (Img)outDoubleType, (RealType)new DoubleType(437.0), (RealType)new DoubleType(8008.0));
    }

    @Test
    public void testFloatTypeInvert() {
        ArrayImg<FloatType, FloatArray> inFloatType = TestImgGeneration.floatArray(true, 5L, 5L);
        Img outFloatType = inFloatType.factory().create(inFloatType, (Object)new FloatType());
        this.assertDefaultInvert((Img)inFloatType, (Img)outFloatType);
        this.assertDefaultInvertMinMaxProvided((Img)inFloatType, (Img)outFloatType, (RealType)new FloatType(0.0f), (RealType)new FloatType(1.0f));
    }

    @Test
    public void testIntTypeInvert() {
        ArrayImg<IntType, IntArray> inIntType = TestImgGeneration.intArray(true, 5L, 5L);
        Img outIntType = inIntType.factory().create(inIntType, (Object)new IntType());
        this.assertDefaultInvert((Img)inIntType, (Img)outIntType);
        this.assertDefaultInvertMinMaxProvided((Img)inIntType, (Img)outIntType, (RealType)new IntType(10), (RealType)new IntType(40));
        this.assertDefaultInvertMinMaxProvided((Img)inIntType, (Img)outIntType, (RealType)new IntType(Integer.MIN_VALUE), (RealType)new IntType(-10));
    }

    @Test
    public void testUnsignedIntTypeInvert() {
        ArrayImg<UnsignedIntType, IntArray> inUnsignedIntType = TestImgGeneration.unsignedIntArray(true, 5L, 5L);
        Img outUnsignedIntType = inUnsignedIntType.factory().create(inUnsignedIntType, (Object)new UnsignedIntType());
        this.assertDefaultInvert((Img)inUnsignedIntType, (Img)outUnsignedIntType);
        this.assertDefaultInvertMinMaxProvided((Img)inUnsignedIntType, (Img)outUnsignedIntType, (RealType)new UnsignedIntType(237L), (RealType)new UnsignedIntType(257L));
        this.assertDefaultInvertMinMaxProvided((Img)inUnsignedIntType, (Img)outUnsignedIntType, (RealType)new UnsignedIntType(10L), (RealType)new UnsignedIntType(-10L));
    }

    @Test
    public void testLongTypeInvert() {
        ArrayImg<LongType, LongArray> inLongType = TestImgGeneration.longArray(true, 5L, 5L);
        Img outLongType = inLongType.factory().create(inLongType, (Object)new LongType());
        this.assertIntegerInvert((Img)inLongType, (Img)outLongType);
        this.assertIntegerInvertMinMaxProvided((Img)inLongType, (Img)outLongType, (IntegerType)new LongType(3025L), (IntegerType)new LongType(3846L));
    }

    @Test
    public void testUnsignedLongTypeInvert() {
        ArrayImg<UnsignedLongType, LongArray> inUnsignedLongType = TestImgGeneration.unsignedLongArray(true, 5L, 5L);
        Img outUnsignedLongType = inUnsignedLongType.factory().create(inUnsignedLongType, (Object)new UnsignedLongType());
        this.assertIntegerInvert((Img)inUnsignedLongType, (Img)outUnsignedLongType);
        this.assertIntegerInvertMinMaxProvided((Img)inUnsignedLongType, (Img)outUnsignedLongType, (IntegerType)new UnsignedLongType(3025L), (IntegerType)new UnsignedLongType(3846L));
    }

    @Test
    public void testUnsigned128ByteTypeInvert() {
        ArrayImg<Unsigned128BitType, LongArray> inUnsigned128BitType = TestImgGeneration.unsigned128BitArray(true, 5L, 5L);
        Img outUnsigned128BitType = inUnsigned128BitType.factory().create(inUnsigned128BitType, (Object)new Unsigned128BitType());
        this.assertIntegerInvert((Img)inUnsigned128BitType, (Img)outUnsigned128BitType);
        this.assertIntegerInvertMinMaxProvided((Img)inUnsigned128BitType, (Img)outUnsigned128BitType, (IntegerType)new Unsigned128BitType(BigInteger.valueOf(3025L)), (IntegerType)new Unsigned128BitType(BigInteger.valueOf(3468L)));
    }

    @Test
    public void testShortTypeInvert() {
        ArrayImg<ShortType, ShortArray> inShortType = TestImgGeneration.shortArray(true, 5L, 5L);
        Img outShortType = inShortType.factory().create(inShortType, (Object)new ShortType());
        this.assertDefaultInvert((Img)inShortType, (Img)outShortType);
        this.assertDefaultInvertMinMaxProvided((Img)inShortType, (Img)outShortType, (RealType)new ShortType(Short.MIN_VALUE), (RealType)new ShortType(-32767));
        this.assertDefaultInvertMinMaxProvided((Img)inShortType, (Img)outShortType, (RealType)new ShortType(Short.MAX_VALUE), (RealType)new ShortType(32766));
        this.assertDefaultInvertMinMaxProvided((Img)inShortType, (Img)outShortType, (RealType)new ShortType(Short.MAX_VALUE), (RealType)new ShortType(Short.MAX_VALUE));
    }

    @Test
    public void testUnsignedShortTypeInvert() {
        ArrayImg<UnsignedShortType, ShortArray> inUnsignedShortType = TestImgGeneration.unsignedShortArray(true, 5L, 5L);
        Img outUnsignedShortType = inUnsignedShortType.factory().create(inUnsignedShortType, (Object)new UnsignedShortType());
        this.assertDefaultInvert((Img)inUnsignedShortType, (Img)outUnsignedShortType);
        this.assertDefaultInvertMinMaxProvided((Img)inUnsignedShortType, (Img)outUnsignedShortType, (RealType)new UnsignedShortType(437), (RealType)new UnsignedShortType(8008));
    }

    @Test
    public void testUnboundedIntegerTypeInvert() {
        ListImg<UnboundedIntegerType> inUnboundedIntegerType = TestImgGeneration.generateUnboundedIntegerTypeListTestImg(true, 5L, 5L);
        Img outUnboundedIntegerType = inUnboundedIntegerType.factory().create(inUnboundedIntegerType, (Object)new UnboundedIntegerType());
        this.assertIntegerInvert((Img)inUnboundedIntegerType, (Img)outUnboundedIntegerType);
        this.assertIntegerInvertMinMaxProvided((Img)inUnboundedIntegerType, (Img)outUnboundedIntegerType, (IntegerType)new UnboundedIntegerType(437L), (IntegerType)new UnboundedIntegerType(8008L));
        this.assertIntegerInvertMinMaxProvided((Img)inUnboundedIntegerType, (Img)outUnboundedIntegerType, (IntegerType)new UnboundedIntegerType(0L), (IntegerType)new UnboundedIntegerType(1L));
    }

    @Test
    public void testUnsignedVariableBitLengthTypeInvert() {
        ArrayImg<UnsignedVariableBitLengthType, LongArray> inUnsignedVariableBitLengthType = TestImgGeneration.unsignedVariableBitLengthTypeArray(true, 64, 5L, 5L);
        Img outUnsignedVariableBitLengthType = inUnsignedVariableBitLengthType.factory().create(inUnsignedVariableBitLengthType, (Object)new UnsignedVariableBitLengthType(1L, 64));
        this.assertIntegerInvert((Img)inUnsignedVariableBitLengthType, (Img)outUnsignedVariableBitLengthType);
        this.assertIntegerInvertMinMaxProvided((Img)inUnsignedVariableBitLengthType, (Img)outUnsignedVariableBitLengthType, (IntegerType)new UnsignedVariableBitLengthType((long)Math.pow(2.0, 64.0) - 1L, 64), (IntegerType)new UnsignedVariableBitLengthType((long)Math.pow(2.0, 64.0) - 1L, 64));
        this.assertIntegerInvertMinMaxProvided((Img)inUnsignedVariableBitLengthType, (Img)outUnsignedVariableBitLengthType, (IntegerType)new UnsignedVariableBitLengthType(123456789L, 64), (IntegerType)new UnsignedVariableBitLengthType(123456790L, 64));
        this.assertIntegerInvertMinMaxProvided((Img)inUnsignedVariableBitLengthType, (Img)outUnsignedVariableBitLengthType, (IntegerType)new UnsignedVariableBitLengthType(4L, 12), (IntegerType)new UnsignedVariableBitLengthType(6L, 12));
        this.assertIntegerInvertMinMaxProvided((Img)inUnsignedVariableBitLengthType, (Img)outUnsignedVariableBitLengthType, (IntegerType)new UnsignedVariableBitLengthType(0L, 6), (IntegerType)new UnsignedVariableBitLengthType(1L, 6));
    }

    private <T extends RealType<T>> void assertDefaultInvert(Img<T> in, Img<T> out) {
        RealType type = (RealType)in.firstElement();
        RealType min = (RealType)type.copy();
        min.setReal(type.getMinValue());
        RealType max = (RealType)type.copy();
        max.setReal(type.getMaxValue());
        ops.op("image.invert").input(in).output(out).compute();
        this.defaultCompare(in, out, min, max);
    }

    private <T extends RealType<T>> void assertDefaultInvertMinMaxProvided(Img<T> in, Img<T> out, T min, T max) {
        ops.op("image.invert").input(in, min, max).output(out).compute();
        this.defaultCompare(in, out, min, max);
    }

    private <T extends RealType<T>> void defaultCompare(Img<T> in, Img<T> out, T min, T max) {
        Cursor inAccess = in.localizingCursor();
        RandomAccess outAccess = out.randomAccess();
        while (inAccess.hasNext()) {
            RealType inVal = (RealType)inAccess.next();
            outAccess.setPosition((Localizable)inAccess);
            RealType outVal = (RealType)outAccess.get();
            double bigIn = inVal.getRealDouble();
            double minMax = min.getRealDouble() + max.getRealDouble() - bigIn;
            double bigOut = outVal.getRealDouble();
            RealType minMaxType = (RealType)outVal.createVariable();
            minMaxType.setReal(minMax);
            if (minMax <= outVal.getMinValue()) {
                Assertions.assertEquals((double)outVal.getMinValue(), (double)bigOut, (double)5.0E-5);
                continue;
            }
            if (minMax >= outVal.getMaxValue()) {
                Assertions.assertEquals((double)outVal.getMaxValue(), (double)bigOut, (double)5.0E-5);
                continue;
            }
            Assertions.assertEquals((Object)minMaxType, (Object)outVal);
        }
    }

    private <T extends IntegerType<T>> void assertIntegerInvertMinMaxProvided(Img<T> in, Img<T> out, T min, T max) {
        ops.op("image.invert").input(in, min, max).output(out).compute();
        this.integerCompare(in, out, min, max);
    }

    private <T extends IntegerType<T>> void assertIntegerInvert(Img<T> in, Img<T> out) {
        ops.op("image.invert").input(in).output(out).compute();
        Cursor inCursor = in.localizingCursor();
        Cursor outCursor = out.localizingCursor();
        while (inCursor.hasNext()) {
            inCursor.fwd();
            outCursor.fwd();
        }
        this.integerCompare(in, out, null, null);
    }

    private <T extends IntegerType<T>> void integerCompare(Img<T> in, Img<T> out, IntegerType<T> min, IntegerType<T> max) {
        BigInteger minOut = ((IntegerType)Inverters.minValue((RealType)((IntegerType)out.firstElement()))).getBigInteger();
        BigInteger maxOut = ((IntegerType)Inverters.maxValue((RealType)((IntegerType)out.firstElement()))).getBigInteger();
        BigInteger minMax = BigInteger.ZERO;
        if (min == null && max == null) {
            minMax = ((IntegerType)Inverters.minValue((RealType)((IntegerType)in.firstElement()))).getBigInteger().add(((IntegerType)Inverters.maxValue((RealType)((IntegerType)in.firstElement()))).getBigInteger());
        } else if (min == null || max == null) {
            Assertions.fail((String)"Internal coding error");
        } else {
            minMax = min.getBigInteger().add(max.getBigInteger());
        }
        Cursor inAccess = in.localizingCursor();
        RandomAccess outAccess = out.randomAccess();
        while (inAccess.hasNext()) {
            IntegerType inVal = (IntegerType)inAccess.next();
            outAccess.setPosition((Localizable)inAccess);
            IntegerType outVal = (IntegerType)outAccess.get();
            BigInteger bigIn = inVal.getBigInteger();
            BigInteger bigOut = outVal.getBigInteger();
            BigInteger calcOut = minMax.subtract(bigIn);
            if (calcOut.compareTo(minOut) <= 0) {
                Assertions.assertEquals((Object)minOut, (Object)bigOut);
                continue;
            }
            if (calcOut.compareTo(maxOut) >= 0) {
                Assertions.assertEquals((Object)maxOut, (Object)bigOut);
                continue;
            }
            Assertions.assertEquals((Object)calcOut, (Object)bigOut);
        }
    }
}

