/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.math;

import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;

public class UnaryRealTypeMathTest
extends AbstractOpTest {
    private static final long LARGE_NUM = 0x20000000000001L;

    @Test
    public void testAbs() {
        LongType in = new LongType(-9007199254740993L);
        LongType out = in.createVariable();
        ops.op("math.abs").input((Object)in).output((Object)out).compute();
        Assertions.assertEquals((long)out.get(), (long)0x20000000000000L);
    }

    @Test
    public void testArccos() {
        FloatType in = new FloatType(0.5f);
        DoubleType out = new DoubleType();
        ops.op("math.arccos").input((Object)in).output((Object)out).compute();
        Assertions.assertEquals((double)out.get(), (double)Math.acos(0.5), (double)0.0);
    }

    @Test
    public void testArccosh() {
        LongType in = new LongType(1234567890L);
        DoubleType out = new DoubleType();
        ops.op("math.arccosh").input((Object)in).output((Object)out).compute();
        double delta = Math.sqrt(1.524157875019052E18);
        Assertions.assertEquals((double)out.get(), (double)Math.log(1.23456789E9 + delta), (double)0.0);
    }

    @Test
    public void testArccot() {
        LongType in = new LongType(1234567890L);
        DoubleType out = new DoubleType();
        ops.op("math.arccot").input((Object)in).output((Object)out).compute();
        Assertions.assertEquals((double)out.get(), (double)Math.atan(8.10000007371E-10), (double)0.0);
    }

    @Test
    public void testArccoth() {
        LongType in = new LongType(1234567890L);
        DoubleType out = new DoubleType();
        ops.op("math.arccoth").input((Object)in).output((Object)out).compute();
        double result = 0.5 * Math.log(1.00000000162);
        Assertions.assertEquals((double)out.get(), (double)result, (double)0.0);
    }

    @Test
    public void testArccsch() {
        LongType in = new LongType(1234567890L);
        DoubleType out = new DoubleType();
        ops.op("math.arccsch").input((Object)in).output((Object)out).compute();
        double delta = Math.sqrt(1.0);
        Assertions.assertEquals((double)out.get(), (double)Math.log(8.10000007371E-10 + delta), (double)0.0);
    }

    @Test
    public void testArcsech() {
        LongType in = new LongType(1234567890L);
        DoubleType out = new DoubleType();
        ops.op("math.arcsech").input((Object)in).output((Object)out).compute();
        double numer = 1.0 + Math.sqrt(-1.524157875019052E18);
        Assertions.assertEquals((double)out.get(), (double)Math.log(numer / 1.23456789E9), (double)0.0);
    }

    @Test
    public void testArcsin() {
        LongType in = new LongType(1234567890L);
        DoubleType out = new DoubleType();
        ops.op("math.arcsin").input((Object)in).output((Object)out).compute();
        Assertions.assertEquals((double)out.get(), (double)Math.asin(1.23456789E9), (double)0.0);
    }

    @Test
    public void testArcsinh() {
        LongType in = new LongType(1234567890L);
        DoubleType out = new DoubleType();
        ops.op("math.arcsinh").input((Object)in).output((Object)out).compute();
        double delta = Math.sqrt(1.524157875019052E18);
        Assertions.assertEquals((double)out.get(), (double)Math.log(1.23456789E9 + delta), (double)0.0);
    }

    @Test
    public void testArctan() {
        LongType in = new LongType(1234567890L);
        DoubleType out = new DoubleType();
        ops.op("math.arctan").input((Object)in).output((Object)out).compute();
        Assertions.assertEquals((double)out.get(), (double)Math.atan(1.23456789E9), (double)0.0);
    }

    @Test
    public void testArctanh() {
        LongType in = new LongType(1234567890L);
        DoubleType out = new DoubleType();
        ops.op("math.arctanh").input((Object)in).output((Object)out).compute();
        Assertions.assertEquals((double)out.get(), (double)(0.5 * Math.log(-1.00000000162)), (double)0.0);
    }

    @Test
    public void testCeil() {
        LongType in = new LongType(0x20000000000001L);
        LongType out = in.createVariable();
        ops.op("math.ceil").input((Object)in).output((Object)out).compute();
        Assertions.assertEquals((long)out.get(), (long)0x20000000000000L);
    }

    @Test
    public void testCos() {
        LongType in = new LongType(1234567890L);
        DoubleType out = new DoubleType();
        ops.op("math.cos").input((Object)in).output((Object)out).compute();
        Assertions.assertEquals((double)out.get(), (double)Math.cos(1.23456789E9), (double)0.0);
    }

    @Test
    public void testCosh() {
        LongType in = new LongType(1234567890L);
        DoubleType out = new DoubleType();
        ops.op("math.cosh").input((Object)in).output((Object)out).compute();
        Assertions.assertEquals((double)out.get(), (double)Math.cosh(1.23456789E9), (double)0.0);
    }

    @Test
    public void testCot() {
        LongType in = new LongType(1234567890L);
        DoubleType out = new DoubleType();
        ops.op("math.cot").input((Object)in).output((Object)out).compute();
        Assertions.assertEquals((double)out.get(), (double)(1.0 / Math.tan(1.23456789E9)), (double)0.0);
    }

    @Test
    public void testCoth() {
        LongType in = new LongType(1234567890L);
        DoubleType out = new DoubleType();
        ops.op("math.coth").input((Object)in).output((Object)out).compute();
        Assertions.assertEquals((double)out.get(), (double)(1.0 / Math.tanh(1.23456789E9)), (double)0.0);
    }

    @Test
    public void testCsc() {
        LongType in = new LongType(1234567890L);
        DoubleType out = new DoubleType();
        ops.op("math.csc").input((Object)in).output((Object)out).compute();
        Assertions.assertEquals((double)out.get(), (double)(1.0 / Math.sin(1.23456789E9)), (double)0.0);
    }

    @Test
    public void testCsch() {
        LongType in = new LongType(1234567890L);
        DoubleType out = new DoubleType();
        ops.op("math.csch").input((Object)in).output((Object)out).compute();
        Assertions.assertEquals((double)out.get(), (double)(1.0 / Math.sinh(1.23456789E9)), (double)0.0);
    }

    @Test
    public void testCubeRoot() {
        LongType in = new LongType(1234567890L);
        DoubleType out = new DoubleType();
        ops.op("math.cubeRoot").input((Object)in).output((Object)out).compute();
        Assertions.assertEquals((double)out.get(), (double)Math.cbrt(1.23456789E9), (double)0.0);
    }

    @Test
    public void testExp() {
        LongType in = new LongType(1234567890L);
        DoubleType out = new DoubleType();
        ops.op("math.exp").input((Object)in).output((Object)out).compute();
        Assertions.assertEquals((double)out.get(), (double)Math.exp(1.23456789E9), (double)0.0);
    }

    @Test
    public void testExpMinusOne() {
        LongType in = new LongType(1234567890L);
        DoubleType out = new DoubleType();
        ops.op("math.expMinusOne").input((Object)in).output((Object)out).compute();
        Assertions.assertEquals((double)out.get(), (double)(Math.exp(1.23456789E9) - 1.0), (double)0.0);
    }

    @Test
    public void testFloor() {
        LongType in = new LongType(0x20000000000001L);
        LongType out = in.createVariable();
        ops.op("math.floor").input((Object)in).output((Object)out).compute();
        Assertions.assertEquals((long)out.get(), (long)0x20000000000000L);
    }

    @Test
    public void testInvert() {
        LongType in = new LongType(0x20000000000001L);
        LongType out = in.createVariable();
        ops.op("math.invert").input((Object)in, (Object)9.007199254740992E15, (Object)9.007199254740994E15).output((Object)out).compute();
        Assertions.assertEquals((long)out.get(), (long)0x20000000000002L);
    }

    @Test
    public void testLog() {
        LongType in = new LongType(1234567890L);
        DoubleType out = new DoubleType();
        ops.op("math.log").input((Object)in).output((Object)out).compute();
        Assertions.assertEquals((double)out.get(), (double)Math.log(1.23456789E9), (double)0.0);
    }

    @Test
    public void testLog10() {
        LongType in = new LongType(1234567890L);
        DoubleType out = new DoubleType();
        ops.op("math.log10").input((Object)in).output((Object)out).compute();
        Assertions.assertEquals((double)out.get(), (double)Math.log10(1.23456789E9), (double)0.0);
    }

    @Test
    public void testLog2() {
        LongType in = new LongType(1234567890L);
        DoubleType out = new DoubleType();
        ops.op("math.log2").input((Object)in).output((Object)out).compute();
        Assertions.assertEquals((double)out.get(), (double)(Math.log(1.23456789E9) / Math.log(2.0)), (double)0.0);
    }

    @Test
    public void testLogOnePlusX() {
        LongType in = new LongType(1234567890L);
        DoubleType out = new DoubleType();
        ops.op("math.logOnePlusX").input((Object)in).output((Object)out).compute();
        Assertions.assertEquals((double)out.get(), (double)Math.log1p(1.23456789E9), (double)0.0);
    }

    @Test
    public void testMax() {
        LongType in = new LongType(0x20000000000001L);
        LongType out = in.createVariable();
        ops.op("math.max").input((Object)in, (Object)9.007199254740992E15).output((Object)out).compute();
        Assertions.assertEquals((long)out.get(), (long)0x20000000000000L);
    }

    @Test
    public void testMin() {
        LongType in = new LongType(0x20000000000001L);
        LongType out = in.createVariable();
        ops.op("math.min").input((Object)in, (Object)9.007199254740991E15).output((Object)out).compute();
        Assertions.assertEquals((long)out.get(), (long)0x20000000000000L);
    }

    @Test
    public void testNearestInt() {
        LongType in = new LongType(0x20000000000001L);
        LongType out = in.createVariable();
        ops.op("math.nearestInt").input((Object)in).output((Object)out).compute();
        Assertions.assertEquals((long)out.get(), (long)0x20000000000000L);
    }

    @Test
    public void testNegate() {
        LongType in = new LongType(-9007199254740993L);
        LongType out = in.createVariable();
        ops.op("math.negate").input((Object)in).output((Object)out).compute();
        Assertions.assertEquals((long)out.get(), (long)0x20000000000000L);
    }

    @Test
    public void testPower() {
        LongType in = new LongType(1234567890L);
        DoubleType out = new DoubleType();
        ops.op("math.power").input((Object)in, (Object)1.5).output((Object)out).compute();
        Assertions.assertEquals((double)out.get(), (double)Math.pow(1.23456789E9, 1.5), (double)0.0);
    }

    @Test
    public void testReciprocal() {
        LongType in = new LongType(1234567890L);
        DoubleType out = new DoubleType();
        ops.op("math.reciprocal").input((Object)in, (Object)0.0).output((Object)out).compute();
        Assertions.assertEquals((double)out.get(), (double)8.10000007371E-10, (double)0.0);
    }

    @Test
    public void testRound() {
        LongType in = new LongType(0x20000000000001L);
        LongType out = in.createVariable();
        ops.op("math.round").input((Object)in).output((Object)out).compute();
        Assertions.assertEquals((long)out.get(), (long)0x20000000000000L);
    }

    @Test
    public void testSec() {
        LongType in = new LongType(1234567890L);
        DoubleType out = new DoubleType();
        ops.op("math.sec").input((Object)in).output((Object)out).compute();
        Assertions.assertEquals((double)out.get(), (double)(1.0 / Math.cos(1.23456789E9)), (double)0.0);
    }

    @Test
    public void testSech() {
        LongType in = new LongType(1234567890L);
        DoubleType out = new DoubleType();
        ops.op("math.sech").input((Object)in).output((Object)out).compute();
        Assertions.assertEquals((double)out.get(), (double)(1.0 / Math.cosh(1.23456789E9)), (double)0.0);
    }

    @Test
    public void testSignum() {
        LongType in = new LongType(1234567890L);
        DoubleType out = new DoubleType();
        ops.op("math.signum").input((Object)in).output((Object)out).compute();
        Assertions.assertEquals((double)out.get(), (double)1.0, (double)0.0);
    }

    @Test
    public void testSin() {
        LongType in = new LongType(1234567890L);
        DoubleType out = new DoubleType();
        ops.op("math.sin").input((Object)in).output((Object)out).compute();
        Assertions.assertEquals((double)out.get(), (double)Math.sin(1.23456789E9), (double)0.0);
    }

    @Test
    public void testSinc() {
        LongType in = new LongType(1234567890L);
        DoubleType out = new DoubleType();
        ops.op("math.sinc").input((Object)in).output((Object)out).compute();
        Assertions.assertEquals((double)out.get(), (double)(Math.sin(1.23456789E9) / 1.23456789E9), (double)0.0);
    }

    @Test
    public void testSincPi() {
        LongType in = new LongType(1234567890L);
        DoubleType out = new DoubleType();
        ops.op("math.sincPi").input((Object)in).output((Object)out).compute();
        double PI = Math.PI;
        Assertions.assertEquals((double)out.get(), (double)(Math.sin(3.878509413581852E9) / 3.878509413581852E9), (double)0.0);
    }

    @Test
    public void testSinh() {
        LongType in = new LongType(1234567890L);
        DoubleType out = new DoubleType();
        ops.op("math.sinh").input((Object)in).output((Object)out).compute();
        Assertions.assertEquals((double)out.get(), (double)Math.sinh(1.23456789E9), (double)0.0);
    }

    @Test
    public void testSqr() {
        LongType in = new LongType(94906267L);
        LongType out = in.createVariable();
        ops.op("math.sqr").input((Object)in).output((Object)out).compute();
        Assertions.assertEquals((long)out.get(), (long)9007199515875288L);
    }

    @Test
    public void testSqrt() {
        LongType in = new LongType(1234567890L);
        DoubleType out = new DoubleType();
        ops.op("math.sqrt").input((Object)in).output((Object)out).compute();
        Assertions.assertEquals((double)out.get(), (double)Math.sqrt(1.23456789E9), (double)0.0);
    }

    @Test
    public void testStep() {
        LongType in = new LongType(1234567890L);
        DoubleType out = new DoubleType();
        ops.op("math.step").input((Object)in).output((Object)out).compute();
        Assertions.assertEquals((double)out.get(), (double)1.0, (double)0.0);
    }

    @Test
    public void testTan() {
        LongType in = new LongType(1234567890L);
        DoubleType out = new DoubleType();
        ops.op("math.tan").input((Object)in).output((Object)out).compute();
        Assertions.assertEquals((double)out.get(), (double)Math.tan(1.23456789E9), (double)0.0);
    }

    @Test
    public void testTanh() {
        LongType in = new LongType(1234567890L);
        DoubleType out = new DoubleType();
        ops.op("math.tanh").input((Object)in).output((Object)out).compute();
        Assertions.assertEquals((double)out.get(), (double)Math.tanh(1.23456789E9), (double)0.0);
    }

    @Test
    public void testUlp() {
        LongType in = new LongType(0x20000000000001L);
        DoubleType out = new DoubleType();
        ops.op("math.ulp").input((Object)in).output((Object)out).compute();
        Assertions.assertEquals((double)out.get(), (double)2.0, (double)0.0);
    }

    @Test
    public void testArccsc() {
        this.assertArccsc(-1.0, -1.5707963267948966);
        this.assertArccsc(1.0, 1.5707963267948966);
        this.assertArccsc(2.0, 0.5235987755982988);
        this.assertArccsc(-2.0, -0.5235987755982988);
        this.assertArccsc(2.0 * Math.sqrt(3.0) / 3.0, 1.0471975511965976);
        this.assertArccsc(-(2.0 * Math.sqrt(3.0)) / 3.0, -1.0471975511965976);
    }

    @Test
    public void testArccscIllegalArgument() {
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.assertArccsc(0.0, 0.0));
        Assertions.assertTrue((boolean)e.getMessage().equalsIgnoreCase("arccsc(x) : x out of range"));
    }

    @Test
    public void testArcsec() {
        this.assertArcsec(-1.0, Math.PI);
        this.assertArcsec(1.0, 0.0);
        this.assertArcsec(Math.sqrt(2.0), 0.7853981633974483);
        this.assertArcsec(-Math.sqrt(2.0), 2.356194490192345);
        this.assertArcsec(2.0, 1.0471975511965976);
        this.assertArcsec(-2.0, 2.0943951023931953);
    }

    @Test
    public void testArcsecIllegalArgument() {
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> this.assertArcsec(0.0, 0.0));
        Assertions.assertTrue((boolean)e.getMessage().equalsIgnoreCase("arcsec(x) : x out of range"));
    }

    private void assertArccsc(double i, double o) {
        DoubleType in = new DoubleType(i);
        DoubleType out = in.createVariable();
        ops.op("math.arccsc").input((Object)in).output((Object)out).compute();
        Assertions.assertEquals((double)o, (double)out.get(), (double)1.0E-15);
    }

    private void assertArcsec(double i, double o) {
        DoubleType in = new DoubleType(i);
        DoubleType out = in.createVariable();
        ops.op("math.arcsec").input((Object)in).output((Object)out).compute();
        Assertions.assertEquals((double)o, (double)out.get(), (double)1.0E-15);
    }
}

