/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.morphology.blackTopHat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.morphology.BlackTopHat;
import net.imglib2.algorithm.neighborhood.DiamondShape;
import net.imglib2.algorithm.neighborhood.HorizontalLineShape;
import net.imglib2.algorithm.neighborhood.RectangleShape;
import net.imglib2.algorithm.neighborhood.Shape;
import net.imglib2.img.Img;
import net.imglib2.test.ImgLib2Assert;
import net.imglib2.type.numeric.integer.ByteType;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.ops.image.util.TestImgGeneration;
import org.scijava.types.Nil;

public class BlackTopHatTest
extends AbstractOpTest {
    private Img<ByteType> in;

    @BeforeEach
    public void initialize() {
        this.in = TestImgGeneration.byteArray(true, 10L, 10L);
    }

    @Test
    public void testSingleBlackTopHat() {
        DiamondShape shape = new DiamondShape(1L);
        List<Shape> shapes = Arrays.asList(shape);
        Img out1 = (Img)ops.op("morphology.BlackTopHat").input(this.in, shapes, (Object)1).outType((Nil)new Nil<Img<ByteType>>(){}).apply();
        Img out2 = BlackTopHat.blackTopHat(this.in, (Shape)shape, (int)1);
        ImgLib2Assert.assertImageEquals((RandomAccessibleInterval)out2, (RandomAccessibleInterval)out1);
    }

    @Test
    public void testListBlackTopHat() {
        ArrayList<Object> shapes = new ArrayList<Object>();
        shapes.add(new DiamondShape(1L));
        shapes.add(new DiamondShape(1L));
        shapes.add(new RectangleShape(1, false));
        shapes.add(new HorizontalLineShape(2L, 1, false));
        Img out1 = (Img)ops.op("morphology.BlackTopHat").input(this.in, shapes, (Object)1).outType((Nil)new Nil<Img<ByteType>>(){}).apply();
        Img out2 = BlackTopHat.blackTopHat(this.in, shapes, (int)1);
        ImgLib2Assert.assertImageEquals((RandomAccessibleInterval)out2, (RandomAccessibleInterval)out1);
    }
}

