/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.morphology.outline;

import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.type.logic.BitType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.types.Nil;

public class OutlineTest
extends AbstractOpTest {
    @Test
    public void testOutput() throws Exception {
        long[] inputDims = new long[]{3L, 3L, 3L};
        ArrayImg img = ArrayImgs.bits((long[])inputDims);
        Img result = (Img)ops.op("morphology.outline").input((Object)img, (Object)Boolean.TRUE).outType((Nil)new Nil<Img<BitType>>(){}).apply();
        Assertions.assertNotNull((Object)result);
        long[] outputDims = new long[result.numDimensions()];
        result.dimensions(outputDims);
        Assertions.assertArrayEquals((long[])inputDims, (long[])outputDims);
    }

    @Test
    public void testAllBackground() throws Exception {
        ArrayImg img = ArrayImgs.bits((long[])new long[]{3L, 3L, 3L});
        Img result = (Img)ops.op("morphology.outline").input((Object)img, (Object)Boolean.TRUE).outType((Nil)new Nil<Img<BitType>>(){}).apply();
        Assertions.assertEquals((int)0, (int)this.countForeground((IterableInterval<BitType>)result), (String)"Output should contain no foreground");
    }

    @Test
    public void testAllForeground() throws Exception {
        ArrayImg img = ArrayImgs.bits((long[])new long[]{3L, 3L, 3L});
        img.forEach(BitType::setOne);
        Img result = (Img)ops.op("morphology.outline").input((Object)img, (Object)Boolean.TRUE).outType((Nil)new Nil<Img<BitType>>(){}).apply();
        Assertions.assertEquals((int)0, (int)this.countForeground((IterableInterval<BitType>)result), (String)"Output should contain no foreground");
    }

    @Test
    public void testSquare() throws Exception {
        ArrayImg img = ArrayImgs.bits((long[])new long[]{4L, 4L});
        IntervalView square = Views.offsetInterval((RandomAccessible)img, (long[])new long[]{1L, 1L}, (long[])new long[]{2L, 2L});
        square.cursor().forEachRemaining(BitType::setOne);
        Img result = (Img)ops.op("morphology.outline").input((Object)img, (Object)Boolean.TRUE).outType((Nil)new Nil<Img<BitType>>(){}).apply();
        Assertions.assertEquals((int)4, (int)this.countForeground((IterableInterval<BitType>)result), (String)"Wrong number of foreground elements in interval");
        IntervalView resultSquare = Views.offsetInterval((RandomAccessible)result, (long[])new long[]{1L, 1L}, (long[])new long[]{2L, 2L});
        Assertions.assertTrue((boolean)this.allForeground((IterableInterval<BitType>)resultSquare), (String)"Wrong number of foreground elements in object");
    }

    @Test
    public void testOutlineSquare() throws Exception {
        ArrayImg img = ArrayImgs.bits((long[])new long[]{5L, 5L});
        IntervalView square = Views.offsetInterval((RandomAccessible)img, (long[])new long[]{1L, 1L}, (long[])new long[]{3L, 3L});
        square.cursor().forEachRemaining(BitType::setOne);
        RandomAccess access = square.randomAccess();
        access.setPosition(new long[]{1L, 1L});
        ((BitType)access.get()).setZero();
        Img result = (Img)ops.op("morphology.outline").input((Object)img, (Object)Boolean.TRUE).outType((Nil)new Nil<Img<BitType>>(){}).apply();
        Assertions.assertEquals((int)8, (int)this.countForeground((IterableInterval<BitType>)result), (String)"Wrong number of foreground elements in interval");
        IntervalView resultSquare = Views.offsetInterval((RandomAccessible)result, (long[])new long[]{1L, 1L}, (long[])new long[]{3L, 3L});
        Assertions.assertEquals((int)8, (int)this.countForeground((IterableInterval<BitType>)resultSquare), (String)"Wrong number of foreground elements in object");
        this.assertPositionBackground((RandomAccessibleInterval<BitType>)result, new long[]{2L, 2L});
    }

    @Test
    public void testEdgeSquare() throws Exception {
        ArrayImg img = ArrayImgs.bits((long[])new long[]{5L, 5L});
        IntervalView square = Views.offsetInterval((RandomAccessible)img, (long[])new long[]{0L, 1L}, (long[])new long[]{3L, 3L});
        square.cursor().forEachRemaining(BitType::setOne);
        Img result = (Img)ops.op("morphology.outline").input((Object)img, (Object)Boolean.TRUE).outType((Nil)new Nil<Img<BitType>>(){}).apply();
        Assertions.assertEquals((int)7, (int)this.countForeground((IterableInterval<BitType>)result), (String)"Wrong number of foreground elements in interval");
        IntervalView resultSquare = Views.offsetInterval((RandomAccessible)result, (long[])new long[]{0L, 1L}, (long[])new long[]{3L, 3L});
        Assertions.assertEquals((int)7, (int)this.countForeground((IterableInterval<BitType>)resultSquare), (String)"Wrong number of foreground elements in object");
        this.assertPositionBackground((RandomAccessibleInterval<BitType>)result, new long[]{0L, 2L});
        this.assertPositionBackground((RandomAccessibleInterval<BitType>)result, new long[]{1L, 2L});
    }

    @Test
    public void testEdgeSquareExcludeEdgesFalse() throws Exception {
        ArrayImg img = ArrayImgs.bits((long[])new long[]{5L, 5L});
        IntervalView square = Views.offsetInterval((RandomAccessible)img, (long[])new long[]{0L, 1L}, (long[])new long[]{3L, 3L});
        square.cursor().forEachRemaining(BitType::setOne);
        Img result = (Img)ops.op("morphology.outline").input((Object)img, (Object)Boolean.FALSE).outType((Nil)new Nil<Img<BitType>>(){}).apply();
        Assertions.assertEquals((int)8, (int)this.countForeground((IterableInterval<BitType>)result), (String)"Wrong number of foreground elements in interval");
        IntervalView resultSquare = Views.offsetInterval((RandomAccessible)result, (long[])new long[]{0L, 1L}, (long[])new long[]{3L, 3L});
        Assertions.assertEquals((int)8, (int)this.countForeground((IterableInterval<BitType>)resultSquare), (String)"Wrong number of foreground elements in object");
        this.assertPositionBackground((RandomAccessibleInterval<BitType>)result, new long[]{1L, 2L});
    }

    @Test
    public void testHyperCube() throws Exception {
        ArrayImg img = ArrayImgs.bits((long[])new long[]{5L, 5L, 5L, 5L});
        IntervalView hyperCube = Views.offsetInterval((RandomAccessible)img, (long[])new long[]{1L, 1L, 1L, 1L}, (long[])new long[]{3L, 3L, 3L, 3L});
        hyperCube.cursor().forEachRemaining(BitType::setOne);
        Img result = (Img)ops.op("morphology.outline").input((Object)img, (Object)Boolean.TRUE).outType((Nil)new Nil<Img<BitType>>(){}).apply();
        Assertions.assertEquals((int)80, (int)this.countForeground((IterableInterval<BitType>)result), (String)"Wrong number of foreground elements in interval");
        IntervalView resultHyperCube = Views.offsetInterval((RandomAccessible)result, (long[])new long[]{1L, 1L, 1L, 1L}, (long[])new long[]{3L, 3L, 3L, 3L});
        Assertions.assertEquals((int)80, (int)this.countForeground((IterableInterval<BitType>)resultHyperCube), (String)"Wrong number of foreground elements in object");
        this.assertPositionBackground((RandomAccessibleInterval<BitType>)result, new long[]{2L, 2L, 2L, 2L});
    }

    private boolean allForeground(IterableInterval<BitType> interval) {
        for (BitType element : interval) {
            if (element.get()) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private int countForeground(IterableInterval<BitType> interval) {
        int count = 0;
        for (BitType element : interval) {
            count += element.getInteger();
        }
        return count;
    }

    private void assertPositionBackground(RandomAccessibleInterval<BitType> interval, long[] position) {
        RandomAccess access = interval.randomAccess();
        access.setPosition(position);
        Assertions.assertFalse((boolean)((BitType)access.get()).get(), (String)"Element should be background");
    }
}

