/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.stats;

import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Pair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.ops.image.util.TestImgGeneration;
import org.scijava.types.Nil;

public class StatisticsTest
extends AbstractOpTest {
    double delta = 0.001;
    ArrayImg<FloatType, FloatArray> img;
    float[] array;
    long arraySize;
    private Img<UnsignedByteType> randomlyFilledImg;

    @BeforeEach
    public void setUp() {
        this.img = TestImgGeneration.floatArray(true, 100L, 100L);
        this.array = ((FloatArray)this.img.update(null)).getCurrentStorageArray();
        this.arraySize = 1L;
        for (int d = 0; d < this.img.numDimensions(); ++d) {
            this.arraySize *= this.img.dimension(d);
        }
        this.randomlyFilledImg = TestImgGeneration.randomlyFilledUnsignedByteWithSeed(new long[]{100L, 100L}, 1234567890L);
    }

    @Test
    public void testMinMax() {
        float min = Float.MAX_VALUE;
        float max = Float.MIN_VALUE;
        int i = 0;
        while ((long)i < this.arraySize) {
            if (this.array[i] < min) {
                min = this.array[i];
            }
            if (this.array[i] > max) {
                max = this.array[i];
            }
            ++i;
        }
        Pair minMax = (Pair)ops.op("stats.minMax").input(this.img).outType((Nil)new Nil<Pair<FloatType, FloatType>>(){}).apply();
        Assertions.assertEquals((float)min, (float)((FloatType)minMax.getA()).get(), (float)0.0f);
        Assertions.assertEquals((float)max, (float)((FloatType)minMax.getB()).get(), (float)0.0f);
    }

    @Test
    public void testMeanStd() {
        float sum = 0.0f;
        int i = 0;
        while ((long)i < this.arraySize) {
            sum += this.array[i];
            ++i;
        }
        float variance = 0.0f;
        float mean1 = sum / (float)this.arraySize;
        int i2 = 0;
        while ((long)i2 < this.arraySize) {
            float temp = this.array[i2] - mean1;
            variance += temp * temp;
            ++i2;
        }
        float std1 = (float)Math.sqrt(variance /= (float)this.arraySize);
        FloatType mean2 = new FloatType();
        ops.op("stats.mean").input(this.img).output((Object)mean2).compute();
        Assertions.assertEquals((double)1.0, (double)(mean1 / mean2.getRealFloat()), (double)this.delta);
        DoubleType std2 = new DoubleType();
        ops.op("stats.stdDev").input(this.img).output((Object)std2).compute();
        Assertions.assertEquals((double)1.0, (double)(std1 / std2.getRealFloat()), (double)this.delta);
    }

    @Test
    public void testMax() {
        UnsignedByteType max = new UnsignedByteType();
        ops.op("stats.max").input(this.randomlyFilledImg).output((Object)max).compute();
        Assertions.assertEquals((double)254.0, (double)max.getRealDouble(), (double)1.0E-5, (String)"Max");
        ByteType maxByte = new ByteType();
        ops.op("stats.max").input((Object)ArrayImgs.bytes((byte[])new byte[]{-1, -2, -4, -3}, (long[])new long[]{2L, 2L})).output((Object)maxByte).compute();
        Assertions.assertEquals((double)-1.0, (double)maxByte.getRealDouble(), (double)0.0, (String)"Max");
    }

    @Test
    public void testMin() {
        UnsignedByteType min = new UnsignedByteType();
        ops.op("stats.min").input(this.randomlyFilledImg).output((Object)min).compute();
        Assertions.assertEquals((double)0.0, (double)min.getRealDouble(), (double)1.0E-5, (String)"Min");
    }

    @Test
    public void testMinAdapted() {
        UnsignedByteType min = (UnsignedByteType)ops.op("stats.min").input(this.randomlyFilledImg).apply();
        Assertions.assertEquals((double)0.0, (double)min.getRealDouble(), (double)1.0E-5, (String)"Min");
    }

    @Test
    public void testMaxAdapted() {
        UnsignedByteType min = (UnsignedByteType)ops.op("stats.max").input(this.randomlyFilledImg).apply();
        Assertions.assertEquals((double)254.0, (double)min.getRealDouble(), (double)1.0E-5, (String)"Max");
    }

    @Test
    public void testStdDev() {
        DoubleType stdDev = new DoubleType();
        ops.op("stats.stdDev").input(this.randomlyFilledImg).output((Object)stdDev).compute();
        Assertions.assertEquals((double)73.7460374274008, (double)stdDev.getRealDouble(), (double)1.0E-5, (String)"StdDev");
    }

    @Test
    public void testSum() {
        FloatType sum = new FloatType();
        ops.op("stats.sum").input(this.randomlyFilledImg).output((Object)sum).compute();
        Assertions.assertEquals((double)1277534.0, (double)sum.getRealDouble(), (double)1.0E-5, (String)"Sum");
    }

    @Test
    public void testVariance() {
        DoubleType variance = new DoubleType();
        ops.op("stats.variance").input(this.randomlyFilledImg).output((Object)variance).compute();
        Assertions.assertEquals((double)5438.4780362436, (double)variance.getRealDouble(), (double)1.0E-5, (String)"Variance");
    }

    @Test
    public void testGeometricMean() {
        DoubleType geoMetricMean = new DoubleType();
        ops.op("stats.geometricMean").input(this.randomlyFilledImg).output((Object)geoMetricMean).compute();
        Assertions.assertEquals((double)0.0, (double)geoMetricMean.getRealDouble(), (double)1.0E-5, (String)"Geometric Mean");
    }

    @Test
    public void testHarmonicMean() {
        DoubleType harmonicMean = new DoubleType();
        ops.op("stats.harmonicMean").input(this.randomlyFilledImg).output((Object)harmonicMean).compute();
        Assertions.assertEquals((double)0.0, (double)harmonicMean.getRealDouble(), (double)1.0E-5, (String)"Harmonic Mean");
    }

    @Test
    public void testKurtosis() {
        DoubleType kurtosis = new DoubleType();
        ops.op("stats.kurtosis").input(this.randomlyFilledImg).output((Object)kurtosis).compute();
        Assertions.assertEquals((double)1.794289587623922, (double)kurtosis.getRealDouble(), (double)1.0E-5, (String)"Kurtosis");
    }

    @Test
    public void testMoment1AboutMean() {
        DoubleType moment1 = new DoubleType();
        ops.op("stats.moment1AboutMean").input(this.randomlyFilledImg).output((Object)moment1).compute();
        Assertions.assertEquals((double)0.0, (double)moment1.getRealDouble(), (double)1.0E-5, (String)"Moment 1 About Mean");
    }

    @Test
    public void testMoment2AboutMean() {
        DoubleType moment2 = new DoubleType();
        ops.op("stats.moment2AboutMean").input(this.randomlyFilledImg).output((Object)moment2).compute();
        Assertions.assertEquals((double)5437.93418843998, (double)moment2.getRealDouble(), (double)1.0E-5, (String)"Moment 2 About Mean");
    }

    @Test
    public void testMoment3AboutMean() {
        DoubleType moment3 = new DoubleType();
        ops.op("stats.moment3AboutMean").input(this.randomlyFilledImg).output((Object)moment3).compute();
        Assertions.assertEquals((double)-507.810691261427, (double)moment3.getRealDouble(), (double)1.0E-5, (String)"Moment 3 About Mean");
    }

    @Test
    public void testMoment4AboutMean() {
        DoubleType moment4 = new DoubleType();
        ops.op("stats.moment4AboutMean").input(this.randomlyFilledImg).output((Object)moment4).compute();
        Assertions.assertEquals((double)5.30697809168701E7, (double)moment4.getRealDouble(), (double)1.0E-5, (String)"Moment 4 About Mean");
    }

    @Test
    public void testPercentile() {
        DoubleType percentile = new DoubleType();
        ops.op("stats.percentile").input(this.randomlyFilledImg, (Object)50.0).output((Object)percentile).compute();
        Assertions.assertEquals((double)128.0, (double)percentile.getRealDouble(), (double)1.0E-5, (String)"50-th Percentile");
    }

    @Test
    public void testQuantile() {
        DoubleType quantile = new DoubleType();
        UnsignedByteType test = new UnsignedByteType();
        ops.op("stats.quantile").input(this.randomlyFilledImg, (Object)0.5).output((Object)quantile).compute();
        Assertions.assertEquals((double)128.0, (double)quantile.getRealDouble(), (double)1.0E-5, (String)"0.5-th Quantile");
    }

    @Test
    public void testSkewness() {
        DoubleType skewness = new DoubleType();
        ops.op("stats.skewness").input(this.randomlyFilledImg).output((Object)skewness).compute();
        Assertions.assertEquals((double)-0.0012661517853476312, (double)skewness.getRealDouble(), (double)1.0E-5, (String)"Skewness");
    }

    @Test
    public void testSumOfInverses() {
        DoubleType sumOfInverses = new DoubleType();
        ops.op("stats.sumOfInverses").input(this.randomlyFilledImg, (Object)new DoubleType(0.0)).output((Object)sumOfInverses).compute();
        Assertions.assertEquals((double)236.60641289378648, (double)sumOfInverses.getRealDouble(), (double)1.0E-5, (String)"Sum Of Inverses");
    }

    @Test
    public void testSumOfLogs() {
        DoubleType sumOfLogs = new DoubleType();
        ops.op("stats.sumOfLogs").input(this.randomlyFilledImg).output((Object)sumOfLogs).compute();
        Assertions.assertEquals((double)Double.NEGATIVE_INFINITY, (double)sumOfLogs.getRealDouble(), (double)1.0E-5, (String)"Sum Of Logs");
    }

    @Test
    public void testSumOfSquares() {
        DoubleType sumOfSquares = new DoubleType();
        ops.op("stats.sumOfSquares").input(this.randomlyFilledImg).output((Object)sumOfSquares).compute();
        Assertions.assertEquals((double)2.17588654E8, (double)sumOfSquares.getRealDouble(), (double)1.0E-5, (String)"Sum Of Squares");
    }
}

