/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.threshold;

import java.util.List;
import java.util.Random;
import java.util.function.BiFunction;
import net.imglib2.RandomAccess;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.histogram.Histogram1d;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.scijava.ops.api.OpBuilder;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.types.Nil;
import org.scijava.util.ListUtils;

public class AbstractThresholdTest
extends AbstractOpTest {
    private final int xSize = 10;
    private final int ySize = 10;
    protected Img<UnsignedShortType> in;
    private BiFunction<Img<UnsignedShortType>, Integer, Histogram1d<UnsignedShortType>> createFunc;

    @BeforeEach
    public void initialize() {
        long[] dimensions = new long[]{10L, 10L};
        Random r = new Random(-559038737L);
        this.in = ArrayImgs.unsignedShorts((long[])dimensions);
        RandomAccess ra = this.in.randomAccess();
        for (int x = 0; x < 10; ++x) {
            int y = 0;
            while (y < 10) {
                ra.setPosition(new int[]{x, y++});
                ((UnsignedShortType)ra.get()).setReal((float)r.nextInt(65535));
            }
        }
        this.createFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"image.histogram", (Nil)new Nil<Img<UnsignedShortType>>(){}, (Nil)new Nil<Integer>(){}, (Nil)new Nil<Histogram1d<UnsignedShortType>>(){});
    }

    protected Histogram1d<UnsignedShortType> histogram() {
        return this.createFunc.apply(this.in, 256);
    }

    protected void assertThreshold(int expected, Object actual) {
        Object value = actual instanceof List ? ListUtils.first((List)((List)actual)) : actual;
        Assertions.assertTrue((boolean)(value instanceof UnsignedShortType));
        UnsignedShortType threshold = (UnsignedShortType)value;
        Assertions.assertEquals((int)expected, (int)threshold.get());
    }

    protected Img<BitType> bitmap() throws IncompatibleTypeException {
        return this.in.factory().imgFactory((Object)new BitType()).create(this.in, (Object)new BitType());
    }

    protected void assertCount(Img<BitType> out, int expected) {
        long count = 0L;
        for (BitType b : out) {
            if (!(b.getRealFloat() > 0.0f)) continue;
            ++count;
        }
        Assertions.assertEquals((long)expected, (long)count);
    }
}

