/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.topology.eulerCharacteristic;

import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.real.DoubleType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.ops.image.topology.eulerCharacteristic.EulerCorrection;
import org.scijava.ops.image.topology.eulerCharacteristic.TestHelper;

public class EulerCorrectionTest
extends AbstractOpTest {
    @Test
    public void testConforms() throws Exception {
        ArrayImg img = ArrayImgs.bits((long[])new long[]{3L, 3L});
        DoubleType result = new DoubleType();
        Assertions.assertThrows(IllegalArgumentException.class, () -> EulerCorrectionTest.lambda$testConforms$0((Img)img, result));
    }

    @Test
    public void testCube() throws Exception {
        Img<BitType> cube = TestHelper.drawCube(3L, 3L, 3L, 1L);
        EulerCorrection.Traverser traverser = new EulerCorrection.Traverser(cube);
        int vertices = EulerCorrection.stackCorners((EulerCorrection.Traverser)traverser);
        Assertions.assertEquals((int)0, (int)vertices, (String)"Number of stack vertices is incorrect");
        long edges = EulerCorrection.stackEdges((EulerCorrection.Traverser)traverser);
        Assertions.assertEquals((long)0L, (long)edges, (String)"Number stack edge voxels is incorrect");
        int faces = EulerCorrection.stackFaces((EulerCorrection.Traverser)traverser);
        Assertions.assertEquals((int)0, (int)faces, (String)"Number stack face voxels is incorrect");
        long voxelEdgeIntersections = EulerCorrection.voxelEdgeIntersections((EulerCorrection.Traverser)traverser);
        Assertions.assertEquals((long)0L, (long)voxelEdgeIntersections, (String)"Number intersections is incorrect");
        long voxelFaceIntersections = EulerCorrection.voxelFaceIntersections((EulerCorrection.Traverser)traverser);
        Assertions.assertEquals((long)0L, (long)voxelFaceIntersections, (String)"Number intersections is incorrect");
        long voxelEdgeFaceIntersections = EulerCorrection.voxelEdgeFaceIntersections((EulerCorrection.Traverser)traverser);
        Assertions.assertEquals((long)0L, (long)voxelEdgeFaceIntersections, (String)"Number intersections is incorrect");
        DoubleType result = new DoubleType();
        ops.op("topology.eulerCorrection").input(cube).output((Object)result).compute();
        Assertions.assertEquals((double)0.0, (double)result.get(), (double)1.0E-12, (String)"Euler correction is incorrect");
    }

    @Test
    public void testEdgeCube() throws Exception {
        int edges = 12;
        int cubeSize = 3;
        boolean edgeSize = true;
        Img<BitType> cube = TestHelper.drawCube(3L, 3L, 3L, 0L);
        EulerCorrection.Traverser traverser = new EulerCorrection.Traverser(cube);
        int vertices = EulerCorrection.stackCorners((EulerCorrection.Traverser)traverser);
        Assertions.assertEquals((int)8, (int)vertices, (String)"Number of stack vertices is incorrect");
        long stackEdges = EulerCorrection.stackEdges((EulerCorrection.Traverser)traverser);
        Assertions.assertEquals((long)12L, (long)stackEdges, (String)"Number stack edge voxels is incorrect");
        int faces = EulerCorrection.stackFaces((EulerCorrection.Traverser)traverser);
        Assertions.assertEquals((int)6, (int)faces, (String)"Number stack face voxels is incorrect");
        long voxelEdgeIntersections = EulerCorrection.voxelEdgeIntersections((EulerCorrection.Traverser)traverser);
        long expectedVEIntersections = 24L;
        Assertions.assertEquals((long)24L, (long)voxelEdgeIntersections, (String)"Number intersections is incorrect");
        long xyVFIntersections = 16L;
        long yzVFIntersections = 8L;
        long xzVFIntersections = 4L;
        long expectedVFIntersections = 56L;
        long voxelFaceIntersections = EulerCorrection.voxelFaceIntersections((EulerCorrection.Traverser)traverser);
        Assertions.assertEquals((long)56L, (long)voxelFaceIntersections, (String)"Number intersections is incorrect");
        long voxelEdgeFaceIntersections = EulerCorrection.voxelEdgeFaceIntersections((EulerCorrection.Traverser)traverser);
        Assertions.assertEquals((long)108L, (long)voxelEdgeFaceIntersections, (String)"Number intersections is incorrect");
        DoubleType result = new DoubleType();
        ops.op("topology.eulerCorrection").input(cube).output((Object)result).compute();
        Assertions.assertEquals((double)1.0, (double)result.get(), (double)1.0E-12, (String)"Euler contribution is incorrect");
    }

    private static /* synthetic */ void lambda$testConforms$0(Img img, DoubleType result) throws Throwable {
        ops.op("topology.eulerCorrection").input((Object)img).output((Object)result).compute();
    }
}

