/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.transform.addDimensionView;

import java.util.function.Function;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.MixedTransformView;
import net.imglib2.view.Views;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.function.Functions;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.types.Nil;

public class AddDimensionViewTest
extends AbstractOpTest {
    @Test
    public void testAddDimension() {
        ArrayImg img = new ArrayImgFactory((NativeType)new DoubleType()).create(new int[]{10, 10});
        MixedTransformView il2 = Views.addDimension((RandomAccessible)img);
        Function addDimFunc = (Function)ops.op("transform.addDimensionView", (Nil)new Nil<Function<RandomAccessible<DoubleType>, MixedTransformView<DoubleType>>>(){}, new Nil[]{new Nil<RandomAccessible<DoubleType>>(){}}, (Nil)new Nil<MixedTransformView<DoubleType>>(){});
        MixedTransformView opr = (MixedTransformView)addDimFunc.apply(img);
        Assertions.assertEquals((int)il2.numDimensions(), (int)opr.numDimensions());
        boolean[] il2Transform = new boolean[3];
        boolean[] oprTransform = new boolean[3];
        il2.getTransformToSource().getComponentZero(il2Transform);
        opr.getTransformToSource().getComponentZero(oprTransform);
        for (int i = 0; i < il2Transform.length; ++i) {
            Assertions.assertEquals((Object)il2Transform[i], (Object)oprTransform[i]);
        }
    }

    @Test
    public void testAddDimensionMinMax() {
        ArrayImg img = new ArrayImgFactory((NativeType)new DoubleType()).create(new int[]{10, 10});
        long max = 20L;
        long min = 0L;
        IntervalView il2 = Views.addDimension((RandomAccessibleInterval)img, (long)min, (long)max);
        Functions.Arity3 addDimFunc = (Functions.Arity3)ops.op("transform.addDimensionView", (Nil)new Nil<Functions.Arity3<RandomAccessibleInterval<DoubleType>, Long, Long, IntervalView<DoubleType>>>(){}, new Nil[]{new Nil<RandomAccessibleInterval<DoubleType>>(){}, new Nil<Long>(){}, new Nil<Long>(){}}, (Nil)new Nil<IntervalView<DoubleType>>(){});
        IntervalView opr = (IntervalView)addDimFunc.apply((Object)img, (Object)min, (Object)max);
        Assertions.assertEquals((double)il2.numDimensions(), (double)opr.numDimensions(), (double)0.0);
        for (int i = 0; i < il2.numDimensions(); ++i) {
            Assertions.assertEquals((double)il2.dimension(i), (double)opr.dimension(i), (double)0.0);
        }
    }
}

