/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.transform.flatIterableView;

import java.util.function.Function;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.view.Views;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.api.OpBuilder;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.types.Nil;

public class FlatIterableViewTest
extends AbstractOpTest {
    Nil<RandomAccessibleInterval<DoubleType>> raiNil = new Nil<RandomAccessibleInterval<DoubleType>>(){};
    Nil<IterableInterval<DoubleType>> iiNil = new Nil<IterableInterval<DoubleType>>(){};

    @Test
    public void testDefaultFlatIterable() {
        Function flatIterableFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"transform.flatIterableView", this.raiNil, this.iiNil);
        ArrayImg img = new ArrayImgFactory((NativeType)new DoubleType()).create(new int[]{10, 10});
        Cursor il2 = Views.flatIterable((RandomAccessibleInterval)img).cursor();
        Cursor opr = ((IterableInterval)flatIterableFunc.apply(img)).cursor();
        while (il2.hasNext()) {
            il2.next();
            opr.next();
            Assertions.assertEquals((double)il2.getDoublePosition(0), (double)opr.getDoublePosition(0), (double)1.0E-10);
            Assertions.assertEquals((double)il2.getDoublePosition(1), (double)opr.getDoublePosition(1), (double)1.0E-10);
        }
    }
}

