/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.transform.hyperSliceView;

import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.MixedTransformView;
import net.imglib2.view.Views;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.function.Functions;
import org.scijava.ops.api.OpBuilder;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.types.Nil;

public class HyperSliceViewTest
extends AbstractOpTest {
    Nil<RandomAccessibleInterval<DoubleType>> raiNil = new Nil<RandomAccessibleInterval<DoubleType>>(){};
    Nil<RandomAccessible<DoubleType>> raNil = new Nil<RandomAccessible<DoubleType>>(){};
    Nil<Integer> integerNil = new Nil<Integer>(){};
    Nil<Long> longNil = new Nil<Long>(){};

    public static <T> RandomAccessible<T> deinterval(RandomAccessibleInterval<T> input) {
        return Views.extendBorder(input);
    }

    @Test
    public void testDefaultHyperSlice() {
        Functions.Arity3 hyperSliceFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"transform.hyperSliceView", this.raNil, this.integerNil, this.longNil, (Nil)new Nil<MixedTransformView<DoubleType>>(){});
        ArrayImg img = new ArrayImgFactory((NativeType)new DoubleType()).create(new int[]{10, 10, 10});
        MixedTransformView il2 = Views.hyperSlice((RandomAccessible)img, (int)1, (long)8L);
        MixedTransformView opr = (MixedTransformView)hyperSliceFunc.apply(HyperSliceViewTest.deinterval(img), (Object)1, (Object)8L);
        for (int i = 0; i < il2.getTransformToSource().getMatrix().length; ++i) {
            for (int j = 0; j < il2.getTransformToSource().getMatrix()[i].length; ++j) {
                Assertions.assertEquals((double)il2.getTransformToSource().getMatrix()[i][j], (double)opr.getTransformToSource().getMatrix()[i][j], (double)1.0E-10);
            }
        }
    }

    @Test
    public void testIntervalHyperSlice() {
        Functions.Arity3 hyperSliceFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"transform.hyperSliceView", this.raiNil, this.integerNil, this.longNil, (Nil)new Nil<IntervalView<DoubleType>>(){});
        ArrayImg img = new ArrayImgFactory((NativeType)new DoubleType()).create(new int[]{10, 10, 10});
        IntervalView il2 = Views.hyperSlice((RandomAccessibleInterval)img, (int)1, (long)8L);
        IntervalView opr = (IntervalView)hyperSliceFunc.apply((Object)img, (Object)1, (Object)8L);
        for (int i = 0; i < ((MixedTransformView)il2.getSource()).getTransformToSource().getMatrix().length; ++i) {
            for (int j = 0; j < ((MixedTransformView)il2.getSource()).getTransformToSource().getMatrix()[i].length; ++j) {
                Assertions.assertEquals((double)((MixedTransformView)il2.getSource()).getTransformToSource().getMatrix()[i][j], (double)((MixedTransformView)opr.getSource()).getTransformToSource().getMatrix()[i][j], (double)1.0E-10);
            }
        }
        Assertions.assertEquals((int)(img.numDimensions() - 1), (int)opr.numDimensions());
    }
}

