/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.transform.invertAxisView;

import java.util.function.BiFunction;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.MixedTransformView;
import net.imglib2.view.Views;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.api.OpBuilder;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.types.Nil;

public class InvertAxisViewTest
extends AbstractOpTest {
    public static <T> RandomAccessible<T> deinterval(RandomAccessibleInterval<T> input) {
        return Views.extendBorder(input);
    }

    @Test
    public void testDefaultInvertAxis() {
        BiFunction invertFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"transform.invertAxisView", (Nil)new Nil<RandomAccessible<DoubleType>>(){}, (Nil)new Nil<Integer>(){}, (Nil)new Nil<MixedTransformView<DoubleType>>(){});
        ArrayImg img = new ArrayImgFactory((NativeType)new DoubleType()).create(new int[]{10, 10});
        MixedTransformView il2 = Views.invertAxis((RandomAccessible)img, (int)1);
        MixedTransformView opr = (MixedTransformView)invertFunc.apply(InvertAxisViewTest.deinterval(img), 1);
        for (int i = 0; i < il2.getTransformToSource().getMatrix().length; ++i) {
            for (int j = 0; j < il2.getTransformToSource().getMatrix()[i].length; ++j) {
                Assertions.assertEquals((double)il2.getTransformToSource().getMatrix()[i][j], (double)opr.getTransformToSource().getMatrix()[i][j], (double)1.0E-10);
            }
        }
    }

    @Test
    public void testIntervalInvertAxis() {
        BiFunction invertFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"transform.invertAxisView", (Nil)new Nil<RandomAccessibleInterval<DoubleType>>(){}, (Nil)new Nil<Integer>(){}, (Nil)new Nil<IntervalView<DoubleType>>(){});
        ArrayImg img = new ArrayImgFactory((NativeType)new DoubleType()).create(new int[]{10, 10});
        IntervalView il2 = Views.invertAxis((RandomAccessibleInterval)img, (int)1);
        IntervalView opr = (IntervalView)invertFunc.apply(img, 1);
        for (int i = 0; i < ((MixedTransformView)il2.getSource()).getTransformToSource().getMatrix().length; ++i) {
            for (int j = 0; j < ((MixedTransformView)il2.getSource()).getTransformToSource().getMatrix()[i].length; ++j) {
                Assertions.assertEquals((double)((MixedTransformView)il2.getSource()).getTransformToSource().getMatrix()[i][j], (double)((MixedTransformView)opr.getSource()).getTransformToSource().getMatrix()[i][j], (double)1.0E-10);
            }
        }
    }
}

