/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.transform.rasterView;

import java.util.function.Function;
import net.imglib2.Cursor;
import net.imglib2.EuclideanSpace;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RealRandomAccessible;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.interpolation.randomaccess.FloorInterpolatorFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.view.RandomAccessibleOnRealRandomAccessible;
import net.imglib2.view.Views;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.api.OpBuilder;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.types.Nil;
import org.scijava.util.MersenneTwisterFast;

public class RasterViewTest
extends AbstractOpTest {
    private static final long SEED = 305419896L;

    @Test
    public void testDefaultRaster() {
        Function rasterFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"transform.rasterView", (Nil)new Nil<RealRandomAccessible<DoubleType>>(){}, (Nil)new Nil<RandomAccessibleOnRealRandomAccessible<DoubleType>>(){});
        ArrayImg img = new ArrayImgFactory((NativeType)new DoubleType()).create(new int[]{10, 10});
        MersenneTwisterFast r = new MersenneTwisterFast(305419896L);
        for (DoubleType d : img) {
            d.set(r.nextDouble());
        }
        RealRandomAccessible realImg = Views.interpolate((EuclideanSpace)img, (InterpolatorFactory)new FloorInterpolatorFactory());
        RandomAccessibleOnRealRandomAccessible il2 = Views.raster((RealRandomAccessible)realImg);
        RandomAccessibleOnRealRandomAccessible opr = (RandomAccessibleOnRealRandomAccessible)rasterFunc.apply(realImg);
        Cursor il2C = Views.interval((RandomAccessible)il2, (Interval)img).localizingCursor();
        RandomAccess oprRA = Views.interval((RandomAccessible)opr, (Interval)img).randomAccess();
        while (il2C.hasNext()) {
            il2C.next();
            oprRA.setPosition((Localizable)il2C);
            Assertions.assertEquals((double)((DoubleType)il2C.get()).get(), (double)((DoubleType)oprRA.get()).get(), (double)1.0E-10);
        }
    }
}

