/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.transform.stackView;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.view.StackView;
import net.imglib2.view.Views;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.api.OpBuilder;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.types.Nil;

public class StackViewTest
extends AbstractOpTest {
    @Test
    public void testDefaultStack() {
        Function stackFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"transform.stackView", (Nil)new Nil<List<Img<DoubleType>>>(){}, (Nil)new Nil<RandomAccessibleInterval<DoubleType>>(){});
        ArrayImg img = new ArrayImgFactory((NativeType)new DoubleType()).create(new int[]{10, 10});
        ArrayList<ArrayImg> list = new ArrayList<ArrayImg>();
        list.add(img);
        list.add(img);
        RandomAccessibleInterval il2 = Views.stack(list);
        RandomAccessibleInterval opr = (RandomAccessibleInterval)stackFunc.apply(list);
        Assertions.assertEquals((long)il2.dimension(2), (long)opr.dimension(2));
    }

    @Test
    public void testStackWithAccessMode() {
        BiFunction stackFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"transform.stackView", (Nil)new Nil<StackView.StackAccessMode>(){}, (Nil)new Nil<List<Img<DoubleType>>>(){}, (Nil)new Nil<RandomAccessibleInterval<DoubleType>>(){});
        ArrayImg img = new ArrayImgFactory((NativeType)new DoubleType()).create(new int[]{10, 10});
        ArrayList<ArrayImg> list = new ArrayList<ArrayImg>();
        list.add(img);
        list.add(img);
        RandomAccessibleInterval il2 = Views.stack((StackView.StackAccessMode)StackView.StackAccessMode.DEFAULT, list);
        RandomAccessibleInterval opr = (RandomAccessibleInterval)stackFunc.apply(StackView.StackAccessMode.DEFAULT, list);
        Assertions.assertEquals((long)il2.dimension(2), (long)opr.dimension(2));
    }
}

