/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.convert;

import java.math.BigDecimal;
import java.math.BigInteger;

public final class Types {
    private static BigInteger mask128 = new BigInteger("+FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", 16);
    private static BigInteger maskU64 = new BigInteger("+FFFFFFFFFFFFFFFF", 16);

    private Types() {
    }

    public static boolean bit(long value) {
        return value != 0L;
    }

    public static boolean bit(double value) {
        return value != 0.0;
    }

    public static boolean bit(boolean value) {
        return value;
    }

    public static boolean bit(BigInteger value) {
        return value.compareTo(BigInteger.ZERO) != 0;
    }

    public static byte uint2(long value) {
        return (byte)(value & 3L);
    }

    public static byte uint2(double value) {
        return Types.uint2((long)value);
    }

    public static byte uint2(Number value) {
        return Types.uint2(value.longValue());
    }

    public static byte uint2(boolean value) {
        return (byte)Types.uint8(value);
    }

    public static byte uint4(long value) {
        return (byte)(value & 0xFL);
    }

    public static byte uint4(double value) {
        return Types.uint4((long)value);
    }

    public static byte uint4(Number value) {
        return Types.uint4(value.longValue());
    }

    public static byte uint4(boolean value) {
        return (byte)Types.uint8(value);
    }

    public static byte int8(long value) {
        return (byte)value;
    }

    public static byte int8(double value) {
        return (byte)value;
    }

    public static byte int8(BigInteger value) {
        return value.and(mask128).byteValue();
    }

    public static byte int8(boolean value) {
        return value ? (byte)1 : 0;
    }

    public static short uint8(long value) {
        return (short)(value & 0xFFL);
    }

    public static short uint8(double value) {
        return Types.uint8((long)value);
    }

    public static short uint8(Number value) {
        return Types.uint8(value.longValue());
    }

    public static short uint8(boolean value) {
        return (short)(value ? 1 : 0);
    }

    public static short uint12(long value) {
        return (short)(value & 0xFFFL);
    }

    public static short uint12(double value) {
        return Types.uint12((long)value);
    }

    public static short uint12(Number value) {
        return Types.uint12(value.longValue());
    }

    public static short uint12(boolean value) {
        return Types.uint8(value);
    }

    public static short int16(long value) {
        return (short)value;
    }

    public static short int16(double value) {
        return (short)value;
    }

    public static short int16(BigInteger value) {
        return value.and(mask128).shortValue();
    }

    public static short int16(boolean value) {
        return value ? (short)1 : 0;
    }

    public static int uint16(long value) {
        return (int)(value & 0xFFFFL);
    }

    public static int uint16(double value) {
        return Types.uint16((long)value);
    }

    public static int uint16(Number value) {
        return Types.uint16(value.longValue());
    }

    public static int uint16(boolean value) {
        return value ? 1 : 0;
    }

    public static int int32(long value) {
        return (int)value;
    }

    public static int int32(double value) {
        return (int)value;
    }

    public static int int32(Number value) {
        return value.intValue();
    }

    public static int int32(boolean value) {
        return value ? 1 : 0;
    }

    public static long uint32(long value) {
        return value & 0xFFFFFFFFL;
    }

    public static long uint32(double value) {
        return Types.uint32((long)value);
    }

    public static long uint32(Number value) {
        return Types.uint32(value.longValue());
    }

    public static long uint32(boolean value) {
        return value ? 1L : 0L;
    }

    public static long int64(long value) {
        return value;
    }

    public static long int64(double value) {
        return (long)value;
    }

    public static long int64(BigInteger value) {
        return value.and(mask128).longValue();
    }

    public static long int64(boolean value) {
        return Types.uint8(value);
    }

    public static BigInteger uint64(long value) {
        BigInteger original = BigInteger.valueOf(value);
        return original.and(maskU64);
    }

    public static BigInteger uint64(double value) {
        return Types.bigInt(value).and(maskU64);
    }

    public static BigInteger uint64(Number value) {
        return Types.uint64(value.longValue());
    }

    public static BigInteger uint64(boolean value) {
        return value ? BigInteger.ONE : BigInteger.ZERO;
    }

    public static BigInteger uint128(long value) {
        BigInteger bi = BigInteger.valueOf(value);
        if (bi.compareTo(BigInteger.ZERO) >= 0) {
            return bi;
        }
        return new BigInteger(Types.validBytes(bi.toByteArray()));
    }

    public static BigInteger uint128(double value) {
        BigInteger bi = Types.bigInt(value);
        if (bi.compareTo(BigInteger.ZERO) >= 0) {
            return bi;
        }
        return new BigInteger(Types.validBytes(bi.toByteArray()));
    }

    private static byte[] validBytes(byte[] value) {
        int start = 0;
        int startBI = 16 - value.length + 1;
        if (value.length > 16) {
            start = value.length - 16;
            startBI = 0;
        }
        byte[] b = new byte[17];
        b[0] = 0;
        int cutoff = Math.min(value.length, start + 16);
        int i = start;
        for (int h = startBI; i < cutoff || h < 16; ++i, ++h) {
            b[h] = (byte)((long)value[i] & 0xFFFL);
        }
        return b;
    }

    public static BigInteger uint128(BigInteger value) {
        return value.and(mask128);
    }

    public static BigInteger uint64Uint128(BigInteger value) {
        return value.and(maskU64);
    }

    public static BigInteger uint128(boolean value) {
        return value ? BigInteger.ONE : BigInteger.ZERO;
    }

    public static float float32(long value) {
        return value;
    }

    public static float float32(double value) {
        return (float)value;
    }

    public static float float32(BigInteger value) {
        return value.and(mask128).floatValue();
    }

    public static float float32(boolean value) {
        return value ? 1.0f : 0.0f;
    }

    public static double float64(long value) {
        return value;
    }

    public static double float64(double value) {
        return value;
    }

    public static double float64(BigInteger value) {
        return value.and(mask128).doubleValue();
    }

    public static double float64(boolean value) {
        return value ? 1.0 : 0.0;
    }

    private static BigInteger bigInt(double value) {
        return BigDecimal.valueOf(value).toBigInteger();
    }
}

