/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.deconvolve;

import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Util;
import net.imglib2.view.Views;
import org.scijava.function.Computers;
import org.scijava.function.Inplaces;
import org.scijava.ops.image.deconvolve.AccelerationState;
import org.scijava.ops.spi.Nullable;
import org.scijava.ops.spi.OpDependency;
import org.scijava.progress.Progress;

public class RichardsonLucyC<I extends RealType<I>, O extends RealType<O>, K extends RealType<K>, C extends ComplexType<C>>
implements Computers.Arity12<RandomAccessibleInterval<I>, RandomAccessibleInterval<K>, RandomAccessibleInterval<C>, RandomAccessibleInterval<C>, Boolean, Boolean, C, Integer, Boolean, Computers.Arity1<RandomAccessibleInterval<O>, RandomAccessibleInterval<O>>, List<Inplaces.Arity1<RandomAccessibleInterval<O>>>, RandomAccessibleInterval<O>, RandomAccessibleInterval<O>> {
    @OpDependency(name="deconvolve.richardsonLucyUpdate")
    private Computers.Arity1<RandomAccessibleInterval<O>, RandomAccessibleInterval<O>> updateOp;
    @OpDependency(name="deconvolve.richardsonLucyCorrection")
    private Computers.Arity4<RandomAccessibleInterval<I>, RandomAccessibleInterval<O>, RandomAccessibleInterval<C>, RandomAccessibleInterval<C>, RandomAccessibleInterval<O>> rlCorrectionOp;
    @OpDependency(name="deconvolve.accelerate")
    private Inplaces.Arity1<AccelerationState<O>> accelerator;
    @OpDependency(name="create.img")
    private BiFunction<Interval, O, Img<O>> createOp;
    @OpDependency(name="filter.fft")
    private Computers.Arity1<RandomAccessibleInterval<K>, RandomAccessibleInterval<C>> fftKernelOp;
    @OpDependency(name="filter.convolve")
    private Computers.Arity6<RandomAccessibleInterval<O>, RandomAccessibleInterval<K>, RandomAccessibleInterval<C>, RandomAccessibleInterval<C>, Boolean, Boolean, RandomAccessibleInterval<O>> convolverOp;
    @OpDependency(name="copy.rai")
    private Computers.Arity1<RandomAccessibleInterval<I>, RandomAccessibleInterval<O>> copyOp;
    @OpDependency(name="copy.rai")
    private Computers.Arity1<RandomAccessibleInterval<O>, RandomAccessibleInterval<O>> copy2Op;

    /*
     * WARNING - void declaration
     */
    public void compute(RandomAccessibleInterval<I> in, RandomAccessibleInterval<K> kernel, RandomAccessibleInterval<C> fftInput, RandomAccessibleInterval<C> fftKernel, Boolean performInputFFT, Boolean performKernelFFT, C complexType, Integer maxIterations, @Nullable Boolean accelerate, @Nullable Computers.Arity1<RandomAccessibleInterval<O>, RandomAccessibleInterval<O>> updateOp, @Nullable List<Inplaces.Arity1<RandomAccessibleInterval<O>>> iterativePostProcessingOps, @Nullable RandomAccessibleInterval<O> raiExtendedEstimate, RandomAccessibleInterval<O> out) {
        void var18_21;
        if (updateOp == null) {
            updateOp = this.updateOp;
        }
        if (iterativePostProcessingOps == null) {
            iterativePostProcessingOps = Collections.emptyList();
        }
        if (raiExtendedEstimate == null) {
            raiExtendedEstimate = (RandomAccessibleInterval)this.createOp.apply((Interval)in, (O)((RealType)Util.getTypeFromInterval(out)));
            this.copyOp.compute(in, (Object)raiExtendedEstimate);
        }
        RandomAccessibleInterval raiExtendedReblurred = (RandomAccessibleInterval)this.createOp.apply((Interval)in, (O)((RealType)Util.getTypeFromInterval(out)));
        this.fftKernelOp.compute(kernel, fftKernel);
        AccelerationState state = new AccelerationState(raiExtendedEstimate);
        Progress.defineTotal((long)maxIterations.intValue());
        for (int i = 0; i < maxIterations; ++i) {
            this.convolverOp.compute((Object)raiExtendedEstimate, null, fftInput, fftKernel, (Object)true, (Object)false, (Object)raiExtendedReblurred);
            this.rlCorrectionOp.compute(in, (Object)raiExtendedReblurred, fftInput, fftKernel, (Object)raiExtendedReblurred);
            updateOp.compute((Object)raiExtendedReblurred, (Object)raiExtendedEstimate);
            for (Inplaces.Arity1 arity1 : iterativePostProcessingOps) {
                arity1.mutate((Object)raiExtendedEstimate);
            }
            if (accelerate.booleanValue()) {
                this.accelerator.mutate(state);
            }
            Progress.update();
        }
        long[] start = new long[out.numDimensions()];
        long[] end = new long[out.numDimensions()];
        boolean bl = false;
        while (var18_21 < out.numDimensions()) {
            start[var18_21] = 0L;
            end[var18_21] = start[var18_21] + out.dimension((int)var18_21) - 1L;
            ++var18_21;
        }
        this.copy2Op.compute((Object)Views.interval((RandomAccessible)raiExtendedEstimate, (Interval)new FinalInterval(start, end)), out);
    }
}

