/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.features.haralick;

import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.ops.image.features.haralick.AbstractHaralickFeature;
import org.scijava.ops.image.image.cooccurrenceMatrix.MatrixOrientation;

public class DefaultTextureHomogeneity<T extends RealType<T>>
extends AbstractHaralickFeature<T> {
    public DoubleType apply(RandomAccessibleInterval<T> input, Integer numGreyLevels, Integer distance, MatrixOrientation orientation) {
        double[][] matrix = this.getCooccurrenceMatrix(input, numGreyLevels, distance, orientation);
        double nrGreyLevel = matrix.length;
        double res = 0.0;
        int i = 0;
        while ((double)i < nrGreyLevel) {
            int j = 0;
            while ((double)j < nrGreyLevel) {
                res += matrix[i][j] / (double)(1 + Math.abs(i - j));
                ++j;
            }
            ++i;
        }
        DoubleType output = new DoubleType();
        output.set(res);
        return output;
    }
}

