/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.filter.convolve;

import java.util.function.BiFunction;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.outofbounds.OutOfBoundsConstantValueFactory;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Util;
import org.scijava.function.Computers;
import org.scijava.function.Functions;
import org.scijava.ops.spi.Nullable;
import org.scijava.ops.spi.OpDependency;

public class ConvolveFFTF<I extends RealType<I> & NativeType<I>, O extends RealType<O> & NativeType<O>, K extends RealType<K> & NativeType<K>, C extends ComplexType<C> & NativeType<C>>
implements Functions.Arity6<RandomAccessibleInterval<I>, RandomAccessibleInterval<K>, O, C, long[], OutOfBoundsFactory<I, RandomAccessibleInterval<I>>, RandomAccessibleInterval<O>> {
    @OpDependency(name="create.img")
    private BiFunction<Dimensions, O, RandomAccessibleInterval<O>> outputCreator;
    @OpDependency(name="filter.padInputFFTMethods")
    private Functions.Arity4<RandomAccessibleInterval<I>, Dimensions, Boolean, OutOfBoundsFactory<I, RandomAccessibleInterval<I>>, RandomAccessibleInterval<I>> padOp;
    @OpDependency(name="filter.padShiftKernelFFTMethods")
    private BiFunction<RandomAccessibleInterval<K>, Dimensions, RandomAccessibleInterval<K>> padKernelOp;
    @OpDependency(name="filter.createFFTOutput")
    private Functions.Arity3<Dimensions, C, Boolean, RandomAccessibleInterval<C>> createOp;
    @OpDependency(name="filter.convolve")
    private Computers.Arity6<RandomAccessibleInterval<I>, RandomAccessibleInterval<K>, RandomAccessibleInterval<C>, RandomAccessibleInterval<C>, Boolean, Boolean, RandomAccessibleInterval<O>> convolveOp;

    public RandomAccessibleInterval<O> apply(RandomAccessibleInterval<I> input, RandomAccessibleInterval<K> kernel, O outType, C complexType, @Nullable long[] borderSize, @Nullable OutOfBoundsFactory<I, RandomAccessibleInterval<I>> obfInput) {
        int d;
        RandomAccessibleInterval<O> output = this.outputCreator.apply((Dimensions)input, outType);
        int numDimensions = input.numDimensions();
        long[] paddedSize = new long[numDimensions];
        if (borderSize == null) {
            for (d = 0; d < numDimensions; ++d) {
                paddedSize[d] = (int)input.dimension(d) + (int)kernel.dimension(d) - 1;
            }
        } else {
            for (d = 0; d < numDimensions; ++d) {
                paddedSize[d] = Math.max(kernel.dimension(d) + 2L * borderSize[d], input.dimension(d) + 2L * borderSize[d]);
            }
        }
        if (obfInput == null) {
            obfInput = new OutOfBoundsConstantValueFactory((Object)((RealType)((RealType)Util.getTypeFromInterval(input)).createVariable()));
        }
        RandomAccessibleInterval paddedInput = (RandomAccessibleInterval)this.padOp.apply(input, (Object)new FinalDimensions(paddedSize), (Object)true, (Object)obfInput);
        RandomAccessibleInterval<K> paddedKernel = this.padKernelOp.apply(kernel, (Dimensions)new FinalDimensions(paddedSize));
        this.computeFilter(paddedInput, paddedKernel, output, paddedSize, complexType);
        return output;
    }

    public void computeFilter(RandomAccessibleInterval<I> input, RandomAccessibleInterval<K> kernel, RandomAccessibleInterval<O> output, long[] paddedSize, C complexType) {
        RandomAccessibleInterval fftInput = (RandomAccessibleInterval)this.createOp.apply((Object)new FinalDimensions(paddedSize), complexType, (Object)true);
        RandomAccessibleInterval fftKernel = (RandomAccessibleInterval)this.createOp.apply((Object)new FinalDimensions(paddedSize), complexType, (Object)true);
        Computers.Arity2<RandomAccessibleInterval<I>, RandomAccessibleInterval<K>, RandomAccessibleInterval<O>> filter = this.createFilterComputer(input, kernel, fftInput, fftKernel, output);
        filter.compute(input, kernel, output);
    }

    public Computers.Arity2<RandomAccessibleInterval<I>, RandomAccessibleInterval<K>, RandomAccessibleInterval<O>> createFilterComputer(RandomAccessibleInterval<I> raiExtendedInput, RandomAccessibleInterval<K> raiExtendedKernel, RandomAccessibleInterval<C> fftImg, RandomAccessibleInterval<C> fftKernel, RandomAccessibleInterval<O> output) {
        return (in1, in2, out) -> this.convolveOp.compute(in1, in2, (Object)fftImg, (Object)fftKernel, (Object)true, (Object)true, out);
    }
}

