/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.geom;

import java.util.function.Function;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.mesh.Mesh;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.ops.spi.OpDependency;

public class CentroidMesh
implements Function<Mesh, RealLocalizable> {
    @OpDependency(name="geom.size")
    private Function<Mesh, DoubleType> sizeFunc;

    @Override
    public RealLocalizable apply(Mesh input) {
        double c_x = 0.0;
        double c_y = 0.0;
        double c_z = 0.0;
        for (int i = 0; i < input.triangles().size(); ++i) {
            long v0 = input.triangles().vertex0(i);
            long v1 = input.triangles().vertex1(i);
            long v2 = input.triangles().vertex2(i);
            double nx = input.triangles().nx((long)i);
            double ny = input.triangles().ny((long)i);
            double nz = input.triangles().nz((long)i);
            double v0x = input.vertices().x(v0);
            double v0y = input.vertices().y(v0);
            double v0z = input.vertices().z(v0);
            double v1x = input.vertices().x(v1);
            double v1y = input.vertices().y(v1);
            double v1z = input.vertices().z(v1);
            double v2x = input.vertices().x(v2);
            double v2y = input.vertices().y(v2);
            double v2z = input.vertices().z(v2);
            c_x += 0.041666666666666664 * nx * (Math.pow(v0x + v1x, 2.0) + Math.pow(v1x + v2x, 2.0) + Math.pow(v2x + v0x, 2.0));
            c_y += 0.041666666666666664 * ny * (Math.pow(v0y + v1y, 2.0) + Math.pow(v1y + v2y, 2.0) + Math.pow(v2y + v0y, 2.0));
            c_z += 0.041666666666666664 * nz * (Math.pow(v0z + v1z, 2.0) + Math.pow(v1z + v2z, 2.0) + Math.pow(v2z + v0z, 2.0));
        }
        double d = 1.0 / (2.0 * this.sizeFunc.apply(input).get());
        return new RealPoint(new double[]{-(c_x *= d), -(c_y *= d), -(c_z *= d)});
    }
}

