/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.geom.geom2d;

import java.util.List;
import java.util.function.Function;
import net.imglib2.RealLocalizable;
import net.imglib2.roi.geom.real.Polygon2D;
import net.imglib2.util.Pair;
import net.imglib2.util.ValuePair;
import org.scijava.ops.image.geom.GeomUtils;
import org.scijava.ops.spi.OpDependency;

public class DefaultMaximumFeret
implements Function<Polygon2D, Pair<RealLocalizable, RealLocalizable>> {
    @OpDependency(name="geom.convexHull")
    private Function<Polygon2D, Polygon2D> function;

    @Override
    public Pair<RealLocalizable, RealLocalizable> apply(Polygon2D input) {
        List<RealLocalizable> points = GeomUtils.vertices(this.function.apply(input));
        double distance = Double.NEGATIVE_INFINITY;
        RealLocalizable p0 = points.get(0);
        RealLocalizable p1 = points.get(0);
        for (int i = 0; i < points.size(); ++i) {
            for (int j = i + 2; j < points.size(); ++j) {
                RealLocalizable tmpP0 = points.get(i);
                RealLocalizable tmpP1 = points.get(j);
                double tmp = Math.sqrt(Math.pow(tmpP0.getDoublePosition(0) - tmpP1.getDoublePosition(0), 2.0) + Math.pow(tmpP0.getDoublePosition(1) - tmpP1.getDoublePosition(1), 2.0));
                if (!(tmp > distance)) continue;
                distance = tmp;
                p0 = tmpP0;
                p1 = tmpP1;
            }
        }
        return new ValuePair((Object)p0, (Object)p1);
    }
}

