/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.image.distancetransform;

import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.RealType;

class Phase2Runnable2DCal<T extends RealType<T>>
implements Runnable {
    private final RandomAccessibleInterval<T> raOut;
    private final double[][] tempValues;
    private final int xPos;
    private final int height;
    private final double[] calibration;

    public Phase2Runnable2DCal(double[][] tempValues, RandomAccessibleInterval<T> raOut, int xPos, double[] calibration) {
        this.tempValues = tempValues;
        this.raOut = raOut;
        this.xPos = xPos;
        this.height = (int)raOut.dimension(1);
        this.calibration = calibration;
    }

    private double distancefunc(int x, int i, double raOutValue) {
        return this.calibration[1] * this.calibration[1] * (double)(x - i) * (double)(x - i) + raOutValue * raOutValue;
    }

    private int sep(int i, int u, double w, double v) {
        return (int)Math.floor(Math.nextUp(((double)(u * u - i * i) + w * w / (this.calibration[1] * this.calibration[1]) - v * v / (this.calibration[1] * this.calibration[1])) / (double)(2 * (u - i))));
    }

    @Override
    public void run() {
        int[] s = new int[this.height];
        int[] t = new int[this.height];
        int q = 0;
        s[0] = 0;
        t[0] = 0;
        for (int u = 1; u < this.height; ++u) {
            while (q >= 0 && this.distancefunc(t[q], s[q], this.tempValues[this.xPos][s[q]]) > this.distancefunc(t[q], u, this.tempValues[this.xPos][u])) {
                --q;
            }
            if (q < 0) {
                q = 0;
                s[0] = u;
                continue;
            }
            int w = 1 + this.sep(s[q], u, this.tempValues[this.xPos][u], this.tempValues[this.xPos][s[q]]);
            if (w >= this.height) continue;
            s[++q] = u;
            t[q] = w;
        }
        RandomAccess ra = this.raOut.randomAccess();
        for (int u = this.height - 1; u >= 0; --u) {
            ra.setPosition(u, 1);
            ra.setPosition(this.xPos, 0);
            ((RealType)ra.get()).setReal(Math.sqrt(this.distancefunc(u, s[q], this.tempValues[this.xPos][s[q]])));
            if (u != t[q]) continue;
            --q;
        }
    }
}

