/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.imagemoments.centralmoments;

import java.util.List;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Intervals;
import org.scijava.function.Computers;
import org.scijava.ops.image.imagemoments.AbstractImageMomentOp;
import org.scijava.ops.spi.OpDependency;

public class DefaultCentralMoment12<I extends RealType<I>, O extends RealType<O>>
implements AbstractImageMomentOp<I, O> {
    @OpDependency(name="imageMoments.moment00")
    private Computers.Arity1<RandomAccessibleInterval<I>, O> moment00Func;
    @OpDependency(name="imageMoments.moment01")
    private Computers.Arity1<RandomAccessibleInterval<I>, O> moment01Func;
    @OpDependency(name="imageMoments.moment10")
    private Computers.Arity1<RandomAccessibleInterval<I>, O> moment10Func;

    @Override
    public void computeMoment(RandomAccessibleInterval<I> input, O output) {
        RealType moment00 = (RealType)output.createVariable();
        this.moment00Func.compute(input, (Object)moment00);
        RealType moment01 = (RealType)output.createVariable();
        this.moment01Func.compute(input, (Object)moment01);
        RealType moment10 = (RealType)output.createVariable();
        this.moment10Func.compute(input, (Object)moment10);
        RealType centerX = (RealType)moment10.copy();
        centerX.div((Object)moment00);
        RealType centerY = (RealType)moment01.copy();
        centerY.div((Object)moment00);
        List sums = LoopBuilder.setImages(input, (RandomAccessibleInterval)Intervals.positions(input)).multiThreaded().forEachChunk(chunk -> {
            RealType sum = (RealType)output.createVariable();
            sum.setZero();
            RealType x = (RealType)output.createVariable();
            RealType y = (RealType)output.createVariable();
            RealType temp = (RealType)output.createVariable();
            chunk.forEachPixel((pixel, pos) -> {
                x.setReal(pos.getDoublePosition(0));
                x.sub((Object)centerX);
                y.setReal(pos.getDoublePosition(1));
                y.sub((Object)centerY);
                temp.setReal(pixel.getRealDouble());
                temp.mul((Object)x);
                temp.mul((Object)y);
                temp.mul((Object)y);
                sum.add((Object)temp);
            });
            return sum;
        });
        output.setZero();
        for (RealType sum : sums) {
            output.add((Object)sum);
        }
    }
}

