/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.imagemoments.centralmoments;

import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.type.numeric.RealType;
import org.scijava.function.Computers;

public class IterableCentralMoment11<I extends RealType<I>, O extends RealType<O>>
implements Computers.Arity1<IterableInterval<I>, O> {
    public void compute(IterableInterval<I> input, O output) {
        if (input.numDimensions() != 2) {
            throw new IllegalArgumentException("Only two-dimensional inputs allowed!");
        }
        double moment00 = 0.0;
        double moment01 = 0.0;
        double moment10 = 0.0;
        double moment11 = 0.0;
        Cursor cursor = input.localizingCursor();
        while (cursor.hasNext()) {
            cursor.fwd();
            double x = cursor.getDoublePosition(0);
            double y = cursor.getDoublePosition(1);
            double val = ((RealType)cursor.get()).getRealDouble();
            moment00 += val;
            moment01 += y * val;
            moment10 += x * val;
            moment11 += x * y * val;
        }
        double centerx = moment10 / moment00;
        output.setReal(moment11 - centerx * moment01);
    }
}

