/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.stats;

import java.util.ArrayList;
import net.imglib2.type.numeric.RealType;
import org.scijava.function.Computers;
import org.scijava.ops.image.stats.DefaultQuantile;
import org.scijava.ops.spi.OpDependency;

public class DefaultMedian<I extends RealType<I>, O extends RealType<O>>
implements Computers.Arity1<Iterable<I>, O> {
    @OpDependency(name="stats.quantile")
    private Computers.Arity2<Iterable<I>, Double, O> quantileOp;

    public void compute(Iterable<I> input, O median) {
        ArrayList<Double> statistics = new ArrayList<Double>();
        input.forEach(i -> statistics.add(i.getRealDouble()));
        int k = statistics.size() / 2;
        double result = DefaultQuantile.select(statistics, k);
        if (statistics.size() % 2 == 0) {
            result += DefaultQuantile.select(statistics, k - 1);
            result *= 0.5;
        }
        median.setReal(result);
    }
}

