/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.stats;

import java.util.NoSuchElementException;
import java.util.function.Function;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Pair;
import net.imglib2.util.ValuePair;

public class IterableMinMax<I extends RealType<I>>
implements Function<Iterable<I>, Pair<I, I>> {
    @Override
    public Pair<I, I> apply(Iterable<I> input) {
        RealType maxVal;
        RealType minVal;
        try {
            minVal = (RealType)((RealType)input.iterator().next()).createVariable();
            minVal.setReal(minVal.getMaxValue());
            maxVal = (RealType)minVal.createVariable();
            maxVal.setReal(maxVal.getMinValue());
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("Cannot determine minimum/maximum of an empty Iterator!");
        }
        for (RealType in : input) {
            if (in.compareTo((Object)minVal) < 0) {
                minVal.set((Type)in);
            }
            if (in.compareTo((Object)maxVal) <= 0) continue;
            maxVal.set((Type)in);
        }
        return new ValuePair((Object)minVal, (Object)maxVal);
    }
}

