/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.threshold.localPhansalkar;

import net.imglib2.algorithm.neighborhood.RectangleNeighborhood;
import net.imglib2.converter.RealDoubleConverter;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.AbstractRealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.view.composite.Composite;
import org.scijava.function.Computers;
import org.scijava.ops.spi.Nullable;
import org.scijava.ops.spi.OpDependency;

public class ComputeLocalPhansalkarThresholdIntegral<T extends RealType<T>>
implements Computers.Arity4<RectangleNeighborhood<? extends Composite<DoubleType>>, T, Double, Double, BitType> {
    public static final double DEFAULT_K = 0.25;
    public static final double DEFAULT_R = 0.5;
    private static final double P = 2.0;
    private static final double Q = 10.0;
    @OpDependency(name="stats.integralMean")
    private Computers.Arity1<RectangleNeighborhood<? extends Composite<DoubleType>>, DoubleType> integralMeanOp;
    @OpDependency(name="stats.integralVariance")
    private Computers.Arity1<RectangleNeighborhood<? extends Composite<DoubleType>>, DoubleType> integralVarianceOp;

    public void compute(RectangleNeighborhood<? extends Composite<DoubleType>> inputNeighborhood, T inputCenterPixel, @Nullable Double k, @Nullable Double r, BitType output) {
        if (k == null) {
            k = 0.25;
        }
        if (r == null) {
            r = 0.5;
        }
        DoubleType mean = new DoubleType();
        this.integralMeanOp.compute(inputNeighborhood, (Object)mean);
        DoubleType variance = new DoubleType();
        this.integralVarianceOp.compute(inputNeighborhood, (Object)variance);
        DoubleType stdDev = new DoubleType(Math.sqrt(variance.get()));
        DoubleType threshold = new DoubleType(mean.getRealDouble() * (1.0 + 2.0 * Math.exp(-10.0 * mean.getRealDouble()) + k * (stdDev.getRealDouble() / r - 1.0)));
        RealDoubleConverter conv = new RealDoubleConverter();
        DoubleType centerPixelAsDoubleType = variance;
        conv.convert(inputCenterPixel, (Object)centerPixelAsDoubleType);
        output.set(centerPixelAsDoubleType.compareTo((AbstractRealType)threshold) > 0);
    }
}

