/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.threshold.localSauvola;

import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.function.Computers;
import org.scijava.ops.spi.Nullable;
import org.scijava.ops.spi.OpDependency;

public class ComputeLocalSauvolaThreshold<T extends RealType<T>>
implements Computers.Arity4<Iterable<T>, T, Double, Double, BitType> {
    public static final double DEFAULT_K = 0.5;
    public static final double DEFAULT_R = 0.5;
    @OpDependency(name="stats.mean")
    private Computers.Arity1<Iterable<T>, DoubleType> meanOp;
    @OpDependency(name="stats.stdDev")
    private Computers.Arity1<Iterable<T>, DoubleType> stdDeviationOp;

    public void compute(Iterable<T> inputNeighborhood, T inputCenterPixel, @Nullable Double k, @Nullable Double r, BitType output) {
        ComputeLocalSauvolaThreshold.compute(inputNeighborhood, inputCenterPixel, k, r, this.meanOp, this.stdDeviationOp, output);
    }

    public static <T extends RealType<T>> void compute(Iterable<T> inputNeighborhood, T inputCenterPixel, Double k, Double r, Computers.Arity1<Iterable<T>, DoubleType> meanOp, Computers.Arity1<Iterable<T>, DoubleType> stdDeviationOp, BitType output) {
        if (k == null) {
            k = 0.5;
        }
        if (r == null) {
            r = 0.5;
        }
        DoubleType meanValue = new DoubleType();
        meanOp.compute(inputNeighborhood, (Object)meanValue);
        DoubleType stdDevValue = new DoubleType();
        stdDeviationOp.compute(inputNeighborhood, (Object)stdDevValue);
        double threshold = meanValue.get() * (1.0 + k * (Math.sqrt(stdDevValue.get()) / r - 1.0));
        output.set(inputCenterPixel.getRealDouble() >= threshold);
    }
}

