/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.tutorial;

import net.imglib2.Cursor;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import net.imglib2.algorithm.neighborhood.RectangleShape;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.spi.OpCollection;

public class OpParallelization
implements OpCollection {
    public static void invertOp(UnsignedByteType input, UnsignedByteType output) {
        output.set(255 - input.get());
    }

    public static void averageNeighborhood(Neighborhood<UnsignedByteType> input, UnsignedByteType output) {
        long tmp = 0L;
        Cursor cursor = input.cursor();
        while (cursor.hasNext()) {
            tmp += ((UnsignedByteType)cursor.next()).getIntegerLong();
        }
        output.setInteger(tmp / input.size());
    }

    public static void main(String ... args) {
        OpEnvironment ops = OpEnvironment.build();
        UnsignedByteType fillValue = new UnsignedByteType(5);
        ArrayImg inImg = ArrayImgs.unsignedBytes((long[])new long[]{10L, 10L});
        ops.op("image.fill").input((Object)fillValue).output((Object)inImg).compute();
        ArrayImg outImg = ArrayImgs.unsignedBytes((long[])new long[]{10L, 10L});
        ops.op("tutorial.invertPerPixel").input((Object)inImg).output((Object)outImg).compute();
        int original = ((UnsignedByteType)inImg.firstElement()).get();
        int inverted = ((UnsignedByteType)outImg.firstElement()).get();
        System.out.println("Original image was filled with value " + original + ", and the inverted image is filled with value (255 - " + original + ") = " + inverted);
        RectangleShape shape = new RectangleShape(1, false);
        ops.op("tutorial.neighborhoodAverage").input((Object)inImg, (Object)shape).output((Object)outImg).compute();
        original = ((UnsignedByteType)inImg.firstElement()).get();
        int mean = ((UnsignedByteType)outImg.firstElement()).get();
        System.out.println("Original image was filled with value " + original + ", and the radius-1 mean at the corner is (4 * " + original + " / 9) = " + mean);
    }
}

