/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.AREAnav;
import edu.wisc.ssec.mcidas.McIDASUtil;

public final class SINUnav
extends AREAnav {
    double drad;
    double decc;
    double r;
    double xrow;
    double xcol;
    double xlat;
    double xlon;
    double xblat;
    double xblon;
    double xspace;
    double yspace;
    int itype;
    int iwest;
    boolean isEastPositive = true;

    public SINUnav(int[] iparms) throws IllegalArgumentException {
        if (iparms[0] != 1397313056) {
            throw new IllegalArgumentException("Invalid navigation type " + iparms[0]);
        }
        this.itype = 2;
        this.xrow = iparms[1];
        this.xcol = iparms[2];
        this.xlat = McIDASUtil.integerLatLonToDouble(iparms[3]);
        this.xlon = McIDASUtil.integerLatLonToDouble(iparms[4]);
        this.yspace = this.xspace = (double)iparms[5] / 1000.0;
        this.r = this.drad = (double)iparms[6] / 1000.0;
        this.decc = (double)iparms[7] / 1000000.0;
        this.iwest = iparms[9];
        if (this.iwest >= 0) {
            this.iwest = 1;
        }
        this.xblat = this.r * (Math.PI / 180) / this.xspace;
        this.xblon = Math.PI / 180 * this.r / this.yspace;
    }

    @Override
    public double[][] toLatLon(double[][] linele) {
        int number = linele[0].length;
        double[][] latlon = new double[2][number];
        double[][] imglinele = this.areaCoordToImageCoord(linele);
        for (int point = 0; point < number; ++point) {
            double ylat;
            double ylon;
            double xlin = imglinele[1][point];
            double xldif = this.xrow - xlin;
            double xele = imglinele[0][point];
            double xedif = this.xcol - xele;
            double xdis = Math.sqrt(xldif * xldif + xedif * xedif);
            if (xdis > 0.001) {
                double xangl = Math.atan2(xldif, xedif) - 1.5707963267948966;
                double xange = Math.atan2(xldif, xedif) + 1.5707963267948966;
                xldif = xdis * Math.cos(xangl);
                xedif = xdis * Math.sin(xange);
            }
            if (Math.abs(ylon = (double)this.iwest * xedif / this.xblon / Math.cos((ylat = this.xlat + xldif / this.xblat) * (Math.PI / 180))) > 180.0) {
                latlon[0][point] = Double.NaN;
                latlon[1][point] = Double.NaN;
                continue;
            }
            if ((ylon = this.xlon + ylon) < -180.0) {
                ylon += 360.0;
            } else if (ylon > 180.0) {
                ylon -= 360.0;
            }
            if (Math.abs(ylat) > 90.0 || Math.abs(ylon) > 180.0) {
                latlon[0][point] = Double.NaN;
                latlon[1][point] = Double.NaN;
            }
            if (this.isEastPositive) {
                ylon = -ylon;
            }
            latlon[0][point] = ylat;
            latlon[1][point] = ylon;
        }
        return latlon;
    }

    @Override
    public double[][] toLinEle(double[][] latlon) {
        int number = latlon[0].length;
        double[][] linele = new double[2][number];
        for (int point = 0; point < number; ++point) {
            double xlin;
            double xele;
            double zlon;
            double zlat = latlon[0][point];
            double d = zlon = this.isEastPositive ? -latlon[1][point] : latlon[1][point];
            if (Double.isNaN(zlat) || Double.isNaN(zlon) || Math.abs(zlat) > 90.0) {
                xele = Double.NaN;
                xlin = Double.NaN;
            } else {
                double xedif;
                double xrlat;
                double xldif;
                double xdis;
                double xrlon = (double)this.iwest * (zlon - this.xlon);
                if (xrlon > 180.0) {
                    xrlon -= 360.0;
                }
                if (xrlon < -180.0) {
                    xrlon += 360.0;
                }
                if ((xdis = Math.sqrt((xldif = this.xblat * (xrlat = zlat - this.xlat)) * xldif + (xedif = xrlon * this.xblon * Math.cos(zlat * (Math.PI / 180))) * xedif)) > 0.001) {
                    double xangl = Math.atan2(xldif, xedif) - 1.5707963267948966;
                    double xange = Math.atan2(xldif, xedif) + 1.5707963267948966;
                    xldif = xdis * Math.cos(xangl);
                    xedif = xdis * Math.sin(xange);
                }
                xlin = this.xrow - xldif;
                xele = this.xcol - xedif;
            }
            linele[1][point] = xlin;
            linele[0][point] = xele;
        }
        return this.imageCoordToAreaCoord(linele, linele);
    }

    @Override
    public float[][] toLatLon(float[][] linele) {
        int number = linele[0].length;
        float[][] latlon = new float[2][number];
        float[][] imglinele = this.areaCoordToImageCoord(linele);
        for (int point = 0; point < number; ++point) {
            double ylat;
            double ylon;
            double xlin = imglinele[1][point];
            double xldif = this.xrow - xlin;
            double xele = imglinele[0][point];
            double xedif = this.xcol - xele;
            double xdis = Math.sqrt(xldif * xldif + xedif * xedif);
            if (xdis > 0.001) {
                double xangl = Math.atan2(xldif, xedif) - 1.5707963267948966;
                double xange = Math.atan2(xldif, xedif) + 1.5707963267948966;
                xldif = xdis * Math.cos(xangl);
                xedif = xdis * Math.sin(xange);
            }
            if (Math.abs(ylon = (double)this.iwest * xedif / this.xblon / Math.cos((ylat = this.xlat + xldif / this.xblat) * (Math.PI / 180))) > 180.0) {
                latlon[0][point] = Float.NaN;
                latlon[1][point] = Float.NaN;
                continue;
            }
            if ((ylon = this.xlon + ylon) < -180.0) {
                ylon += 360.0;
            } else if (ylon > 180.0) {
                ylon -= 360.0;
            }
            if (Math.abs(ylat) > 90.0 || Math.abs(ylon) > 180.0) {
                latlon[0][point] = Float.NaN;
                latlon[1][point] = Float.NaN;
            }
            if (this.isEastPositive) {
                ylon = -ylon;
            }
            latlon[0][point] = (float)ylat;
            latlon[1][point] = (float)ylon;
        }
        return latlon;
    }

    @Override
    public float[][] toLinEle(float[][] latlon) {
        int number = latlon[0].length;
        float[][] linele = new float[2][number];
        for (int point = 0; point < number; ++point) {
            double xlin;
            double xele;
            double zlon;
            double zlat = latlon[0][point];
            double d = zlon = this.isEastPositive ? (double)(-latlon[1][point]) : (double)latlon[1][point];
            if (Double.isNaN(zlat) || Double.isNaN(zlon) || Math.abs(zlat) > 90.0) {
                xele = Double.NaN;
                xlin = Double.NaN;
            } else {
                double xedif;
                double xrlat;
                double xldif;
                double xdis;
                double xrlon = (double)this.iwest * (zlon - this.xlon);
                if (xrlon > 180.0) {
                    xrlon -= 360.0;
                }
                if (xrlon < -180.0) {
                    xrlon += 360.0;
                }
                if ((xdis = Math.sqrt((xldif = this.xblat * (xrlat = zlat - this.xlat)) * xldif + (xedif = xrlon * this.xblon * Math.cos(zlat * (Math.PI / 180))) * xedif)) > 0.001) {
                    double xangl = Math.atan2(xldif, xedif) - 1.5707963267948966;
                    double xange = Math.atan2(xldif, xedif) + 1.5707963267948966;
                    xldif = xdis * Math.cos(xangl);
                    xedif = xdis * Math.sin(xange);
                }
                xlin = this.xrow - xldif;
                xele = this.xcol - xedif;
            }
            linele[1][point] = (float)xlin;
            linele[0][point] = (float)xele;
        }
        return this.imageCoordToAreaCoord(linele, linele);
    }

    public static void main(String[] a) {
        int[] p = new int[]{1397313056, 10000, 10000, 421353, 831951, 1000, 6378388, 81992, 0, 0};
        SINUnav sn = new SINUnav(p);
        double[][] latlon = new double[2][1];
        latlon[0][0] = 43.0;
        latlon[1][0] = -89.0;
        System.out.println("####  Doing double");
        System.out.println("####  Original latlon=" + latlon[0][0] + "  " + latlon[1][0]);
        double[][] pix = sn.toLinEle(latlon);
        System.out.println("####  pix=" + pix[0][0] + "  " + pix[1][0]);
        latlon = sn.toLatLon(pix);
        System.out.println("####  latlon=" + latlon[0][0] + "  " + latlon[1][0]);
        System.out.println("####  Now doing float....");
        float[][] flatlon = new float[2][1];
        flatlon[0][0] = 43.0f;
        flatlon[1][0] = -89.0f;
        System.out.println("####  Original flatlon=" + flatlon[0][0] + "  " + flatlon[1][0]);
        float[][] fpix = sn.toLinEle(flatlon);
        System.out.println("####  fpix=" + fpix[0][0] + "  " + fpix[1][0]);
        flatlon = sn.toLatLon(fpix);
        System.out.println("####  flatlon=" + flatlon[0][0] + "  " + flatlon[1][0]);
    }
}

