/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas.adde;

import edu.wisc.ssec.mcidas.adde.AddeURL;

public class AddeDatasetURL
extends AddeURL {
    public static final String KEY_GROUP = "GROUP";
    public static final String KEY_DESCRIPTOR = "DESCRIPTOR";
    private String group = null;
    private String descriptor = null;

    public AddeDatasetURL() {
    }

    public AddeDatasetURL(String host, String requestType, String group) {
        this(host, requestType, group, null);
    }

    public AddeDatasetURL(String host, String requestType, String group, String descriptor) {
        this(host, requestType, group, descriptor, null);
    }

    public AddeDatasetURL(String host, String requestType, String group, String descriptor, String extraKeys) {
        super(host, requestType, extraKeys);
        this.group = group;
        this.descriptor = descriptor;
    }

    @Override
    protected String makeQuery() {
        StringBuffer buf = new StringBuffer(super.makeQuery());
        if (this.getGroup() != null) {
            this.appendKeyValue(buf, KEY_GROUP, this.getGroup());
        }
        if (this.getDescriptor() != null) {
            this.appendKeyValue(buf, KEY_DESCRIPTOR, this.getDescriptor());
        }
        return buf.toString();
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(String desc) {
        this.descriptor = desc;
    }

    @Override
    protected void parseQuery(String query) {
        super.parseQuery(query);
        String test = this.getValue(query, KEY_GROUP);
        if (test != null) {
            this.setGroup(test);
        }
        if ((test = this.getValue(query, "DESC")) != null) {
            this.setDescriptor(test);
        }
    }
}

